/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.catalina.SessionListener;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class DeltaRequest
implements Externalizable {
    public static final Log log = LogFactory.getLog(DeltaRequest.class);
    protected static final StringManager sm = StringManager.getManager(DeltaRequest.class);
    public static final int TYPE_ATTRIBUTE = 0;
    public static final int TYPE_PRINCIPAL = 1;
    public static final int TYPE_ISNEW = 2;
    public static final int TYPE_MAXINTERVAL = 3;
    public static final int TYPE_AUTHTYPE = 4;
    public static final int TYPE_LISTENER = 5;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    public static final String NAME_PRINCIPAL = "__SET__PRINCIPAL__";
    public static final String NAME_MAXINTERVAL = "__SET__MAXINTERVAL__";
    public static final String NAME_ISNEW = "__SET__ISNEW__";
    public static final String NAME_AUTHTYPE = "__SET__AUTHTYPE__";
    public static final String NAME_LISTENER = "__SET__LISTENER__";
    private String sessionId;
    private LinkedList<AttributeInfo> actions = new LinkedList();
    private LinkedList<AttributeInfo> actionPool = new LinkedList();
    private boolean recordAllActions = false;

    public DeltaRequest() {
    }

    public DeltaRequest(String string, boolean bl) {
        this.recordAllActions = bl;
        if (string != null) {
            this.setSessionId(string);
        }
    }

    public void setAttribute(String string, Object object) {
        int n = object == null ? 1 : 0;
        this.addAction(0, n, string, object);
    }

    public void removeAttribute(String string) {
        this.addAction(0, 1, string, null);
    }

    public void setMaxInactiveInterval(int n) {
        this.addAction(3, 0, NAME_MAXINTERVAL, n);
    }

    public void setPrincipal(Principal principal) {
        int n = principal == null ? 1 : 0;
        SerializablePrincipal serializablePrincipal = null;
        if (principal != null) {
            if (principal instanceof GenericPrincipal) {
                serializablePrincipal = SerializablePrincipal.createPrincipal((GenericPrincipal)principal);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaRequest.showPrincipal", new Object[]{principal.getName(), this.getSessionId()}));
                }
            } else {
                log.error((Object)sm.getString("deltaRequest.wrongPrincipalClass", new Object[]{principal.getClass().getName()}));
            }
        }
        this.addAction(1, n, NAME_PRINCIPAL, serializablePrincipal);
    }

    public void setNew(boolean bl) {
        int n = 0;
        this.addAction(2, n, NAME_ISNEW, bl);
    }

    public void setAuthType(String string) {
        int n = string == null ? 1 : 0;
        this.addAction(4, n, NAME_AUTHTYPE, string);
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.addAction(5, 0, NAME_LISTENER, sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.addAction(5, 1, NAME_LISTENER, sessionListener);
    }

    protected void addAction(int n, int n2, String string, Object object) {
        AttributeInfo attributeInfo = null;
        if (this.actionPool.size() > 0) {
            try {
                attributeInfo = this.actionPool.removeFirst();
            }
            catch (Exception exception) {
                log.error((Object)"Unable to remove element:", (Throwable)exception);
                attributeInfo = new AttributeInfo(n, n2, string, object);
            }
            attributeInfo.init(n, n2, string, object);
        } else {
            attributeInfo = new AttributeInfo(n, n2, string, object);
        }
        if (!this.recordAllActions) {
            try {
                this.actions.remove(attributeInfo);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.actions.addLast(attributeInfo);
    }

    public void execute(DeltaSession deltaSession, boolean bl) {
        if (!this.sessionId.equals(deltaSession.getId())) {
            throw new IllegalArgumentException("Session id mismatch, not executing the delta request");
        }
        deltaSession.access();
        block8: for (AttributeInfo attributeInfo : this.actions) {
            switch (attributeInfo.getType()) {
                case 0: {
                    if (attributeInfo.getAction() == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Session.setAttribute('" + attributeInfo.getName() + "', '" + attributeInfo.getValue() + "')"));
                        }
                        deltaSession.setAttribute(attributeInfo.getName(), attributeInfo.getValue(), bl, false);
                        continue block8;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Session.removeAttribute('" + attributeInfo.getName() + "')"));
                    }
                    deltaSession.removeAttribute(attributeInfo.getName(), bl, false);
                    continue block8;
                }
                case 2: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Session.setNew('" + attributeInfo.getValue() + "')"));
                    }
                    deltaSession.setNew((Boolean)attributeInfo.getValue(), false);
                    continue block8;
                }
                case 3: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Session.setMaxInactiveInterval('" + attributeInfo.getValue() + "')"));
                    }
                    deltaSession.setMaxInactiveInterval((Integer)attributeInfo.getValue(), false);
                    continue block8;
                }
                case 1: {
                    Object object;
                    GenericPrincipal genericPrincipal = null;
                    if (attributeInfo.getAction() == 0) {
                        object = (SerializablePrincipal)attributeInfo.getValue();
                        genericPrincipal = ((SerializablePrincipal)object).getPrincipal();
                    }
                    deltaSession.setPrincipal((Principal)genericPrincipal, false);
                    continue block8;
                }
                case 4: {
                    Object object = null;
                    if (attributeInfo.getAction() == 0) {
                        object = (String)attributeInfo.getValue();
                    }
                    deltaSession.setAuthType((String)object, false);
                    continue block8;
                }
                case 5: {
                    SessionListener sessionListener = (SessionListener)attributeInfo.getValue();
                    if (attributeInfo.getAction() == 0) {
                        deltaSession.addSessionListener(sessionListener, false);
                        continue block8;
                    }
                    deltaSession.removeSessionListener(sessionListener, false);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid attribute info type=" + attributeInfo);
        }
        deltaSession.endAccess();
        this.reset();
    }

    public void reset() {
        while (this.actions.size() > 0) {
            try {
                AttributeInfo attributeInfo = this.actions.removeFirst();
                attributeInfo.recycle();
                this.actionPool.addLast(attributeInfo);
            }
            catch (Exception exception) {
                log.error((Object)"Unable to remove element", (Throwable)exception);
            }
        }
        this.actions.clear();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
        if (string == null) {
            new Exception("Session Id is null for setSessionId").fillInStackTrace().printStackTrace();
        }
    }

    public int getSize() {
        return this.actions.size();
    }

    public void clear() {
        this.actions.clear();
        this.actionPool.clear();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.reset();
        this.sessionId = objectInput.readUTF();
        this.recordAllActions = objectInput.readBoolean();
        int n = objectInput.readInt();
        if (this.actions == null) {
            this.actions = new LinkedList();
        } else {
            this.actions.clear();
        }
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = null;
            if (this.actionPool.size() > 0) {
                try {
                    attributeInfo = this.actionPool.removeFirst();
                }
                catch (Exception exception) {
                    log.error((Object)"Unable to remove element", (Throwable)exception);
                    attributeInfo = new AttributeInfo();
                }
            } else {
                attributeInfo = new AttributeInfo();
            }
            attributeInfo.readExternal(objectInput);
            this.actions.addLast(attributeInfo);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.getSessionId());
        objectOutput.writeBoolean(this.recordAllActions);
        objectOutput.writeInt(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            AttributeInfo attributeInfo = this.actions.get(i);
            attributeInfo.writeExternal(objectOutput);
        }
    }

    protected byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        this.writeExternal(objectOutputStream);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static class AttributeInfo
    implements Externalizable {
        private String name = null;
        private Object value = null;
        private int action;
        private int type;

        public AttributeInfo() {
            this(-1, -1, null, null);
        }

        public AttributeInfo(int n, int n2, String string, Object object) {
            this.init(n, n2, string, object);
        }

        public void init(int n, int n2, String string, Object object) {
            this.name = string;
            this.value = object;
            this.action = n2;
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public int getAction() {
            return this.action;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public void recycle() {
            this.name = null;
            this.value = null;
            this.type = -1;
            this.action = -1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AttributeInfo)) {
                return false;
            }
            AttributeInfo attributeInfo = (AttributeInfo)object;
            return attributeInfo.getName().equals(this.getName());
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.type = objectInput.readInt();
            this.action = objectInput.readInt();
            this.name = objectInput.readUTF();
            boolean bl = objectInput.readBoolean();
            if (bl) {
                this.value = objectInput.readObject();
            }
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.getType());
            objectOutput.writeInt(this.getAction());
            objectOutput.writeUTF(this.getName());
            objectOutput.writeBoolean(this.getValue() != null);
            if (this.getValue() != null) {
                objectOutput.writeObject(this.getValue());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("AttributeInfo[type=");
            stringBuilder.append(this.getType()).append(", action=").append(this.getAction());
            stringBuilder.append(", name=").append(this.getName()).append(", value=").append(this.getValue());
            stringBuilder.append(", addr=").append(super.toString()).append("]");
            return stringBuilder.toString();
        }
    }
}

