/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.variable;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.ControlFlowInfo;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfo;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfoImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Jw\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\f\"\"\b\u0000\u0010\u000f*\u001c\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0002\b\u00030\u0010j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u000f2$\u0010\u0016\u001a \u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\u0017\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JI\u0010\u001b\u001a\u0002H\u000f\"\"\b\u0000\u0010\u000f*\u001c\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0002\b\u00030\u0010j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u00122\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariableDataCollector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;)V", "blockScopeVariableInfo", "Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "getBlockScopeVariableInfo", "()Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "collectData", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/Edges;", "I", "Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/cfg/variable/VariableUsageControlFlowInfo;", "traversalOrder", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/TraversalOrder;", "initialInfo", "instructionDataMergeStrategy", "Lkotlin/Function2;", "", "(Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/TraversalOrder;Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;Lkotlin/jvm/functions/Function2;)Ljava/util/Map;", "computeBlockScopeVariableInfo", "filterOutVariablesOutOfScope", "from", "to", "info", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;)Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;", "frontend"})
public final class PseudocodeVariableDataCollector {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final BlockScopeVariableInfo blockScopeVariableInfo;

    public PseudocodeVariableDataCollector(@NotNull BindingContext bindingContext, @NotNull Pseudocode pseudocode) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(pseudocode, "pseudocode");
        this.bindingContext = bindingContext;
        this.pseudocode = pseudocode;
        this.blockScopeVariableInfo = this.computeBlockScopeVariableInfo(this.pseudocode);
    }

    @NotNull
    public final BlockScopeVariableInfo getBlockScopeVariableInfo() {
        return this.blockScopeVariableInfo;
    }

    @NotNull
    public final <I extends ControlFlowInfo<?, VariableDescriptor, ?>> Map<Instruction, Edges<I>> collectData(@NotNull TraversalOrder traversalOrder, @NotNull I initialInfo, @NotNull Function2<? super Instruction, ? super Collection<? extends I>, ? extends Edges<? extends I>> instructionDataMergeStrategy) {
        Intrinsics.checkNotNullParameter((Object)traversalOrder, "traversalOrder");
        Intrinsics.checkNotNullParameter(initialInfo, "initialInfo");
        Intrinsics.checkNotNullParameter(instructionDataMergeStrategy, "instructionDataMergeStrategy");
        return PseudocodeTraverserKt.collectData(this.pseudocode, traversalOrder, instructionDataMergeStrategy, new Function3<Instruction, Instruction, I, I>(this){
            final /* synthetic */ PseudocodeVariableDataCollector this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final I invoke(@NotNull Instruction from, @NotNull Instruction to, @NotNull I info) {
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                Intrinsics.checkNotNullParameter(info, "info");
                return (I)PseudocodeVariableDataCollector.access$filterOutVariablesOutOfScope(this.this$0, from, to, info);
            }
        }, initialInfo);
    }

    private final <I extends ControlFlowInfo<?, VariableDescriptor, ?>> I filterOutVariablesOutOfScope(Instruction from, Instruction to, I info) {
        int toDepth = to.getBlockScope().getDepth();
        if (toDepth >= from.getBlockScope().getDepth()) {
            return info;
        }
        return (I)info.retainAll((Function1)new Function1<VariableDescriptor, Boolean>(this, toDepth){
            final /* synthetic */ PseudocodeVariableDataCollector this$0;
            final /* synthetic */ int $toDepth;
            {
                this.this$0 = $receiver;
                this.$toDepth = $toDepth;
                super(1);
            }

            public final boolean invoke(@NotNull VariableDescriptor variable2) {
                int n;
                BlockScope blockScope;
                Intrinsics.checkNotNullParameter(variable2, "variable");
                BlockScope blockScope2 = blockScope = this.this$0.getBlockScopeVariableInfo().getDeclaredIn().get(variable2);
                int depth = blockScope2 == null ? -1 : (n = blockScope2.getDepth());
                return depth <= this.$toDepth;
            }
        });
    }

    private final BlockScopeVariableInfo computeBlockScopeVariableInfo(Pseudocode pseudocode) {
        BlockScopeVariableInfoImpl blockScopeVariableInfo = new BlockScopeVariableInfoImpl();
        PseudocodeTraverserKt.traverse(pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)new Function1<Instruction, Unit>(this, blockScopeVariableInfo){
            final /* synthetic */ PseudocodeVariableDataCollector this$0;
            final /* synthetic */ BlockScopeVariableInfoImpl $blockScopeVariableInfo;
            {
                this.this$0 = $receiver;
                this.$blockScopeVariableInfo = $blockScopeVariableInfo;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                if (instruction instanceof VariableDeclarationInstruction) {
                    KtDeclaration variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    DeclarationDescriptor declarationDescriptor = PseudocodeVariableDataCollector.access$getBindingContext$p(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement);
                    if (declarationDescriptor == null) {
                        return;
                    }
                    DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                    DeclarationDescriptor descriptor2 = declarationDescriptor2;
                    VariableDescriptor variableDescriptor = BindingContextUtils.variableDescriptorForDeclaration(descriptor2);
                    if (variableDescriptor == null) {
                        throw new AssertionError((Object)("Variable or class descriptor should correspond to the instruction for " + ((VariableDeclarationInstruction)instruction).getElement().getText() + ".\nDescriptor: " + descriptor2));
                    }
                    DeclarationDescriptor variableDescriptor2 = declarationDescriptor = variableDescriptor;
                    this.$blockScopeVariableInfo.registerVariableDeclaredInScope((VariableDescriptor)variableDescriptor2, instruction.getBlockScope());
                }
            }
        });
        return blockScopeVariableInfo;
    }

    public static final /* synthetic */ ControlFlowInfo access$filterOutVariablesOutOfScope(PseudocodeVariableDataCollector $this, Instruction from, Instruction to, ControlFlowInfo info) {
        return $this.filterOutVariablesOutOfScope(from, to, info);
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(PseudocodeVariableDataCollector $this) {
        return $this.bindingContext;
    }
}

