/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImplWithoutEntityAndAnonCaching;

public class OWLHasKeyAxiomImpl
extends OWLLogicalAxiomImplWithoutEntityAndAnonCaching
implements OWLHasKeyAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLClassExpression expression;
    @Nonnull
    private final List<OWLPropertyExpression> propertyExpressions;

    public OWLHasKeyAxiomImpl(@Nonnull OWLClassExpression expression, @Nonnull Set<? extends OWLPropertyExpression> propertyExpressions, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.expression = OWLAPIPreconditions.checkNotNull(expression, "expression cannot be null");
        OWLAPIPreconditions.checkNotNull(propertyExpressions, "propertyExpressions cannot be null");
        this.propertyExpressions = CollectionFactory.sortOptionally(propertyExpressions);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.addSignatureEntitiesToSetForValue(entities, this.expression);
        for (OWLPropertyExpression propertyExpression : this.propertyExpressions) {
            this.addSignatureEntitiesToSetForValue(entities, propertyExpression);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, this.expression);
        for (OWLPropertyExpression propertyExpression : this.propertyExpressions) {
            this.addAnonymousIndividualsToSetForValue(anons, propertyExpression);
        }
    }

    @Override
    public OWLHasKeyAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLHasKeyAxiomImpl(this.getClassExpression(), this.getPropertyExpressions(), NO_ANNOTATIONS);
    }

    @Override
    public OWLHasKeyAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLHasKeyAxiomImpl(this.getClassExpression(), this.getPropertyExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.HAS_KEY;
    }

    @Override
    public OWLClassExpression getClassExpression() {
        return this.expression;
    }

    @Override
    public Set<OWLPropertyExpression> getPropertyExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.propertyExpressions);
    }

    @Override
    public Set<OWLDataPropertyExpression> getDataPropertyExpressions() {
        TreeSet<OWLDataPropertyExpression> props = new TreeSet<OWLDataPropertyExpression>();
        for (OWLPropertyExpression prop : this.propertyExpressions) {
            if (!prop.isDataPropertyExpression()) continue;
            props.add((OWLDataPropertyExpression)prop);
        }
        return props;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getObjectPropertyExpressions() {
        TreeSet<OWLObjectPropertyExpression> props = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLPropertyExpression prop : this.propertyExpressions) {
            if (!prop.isObjectPropertyExpression()) continue;
            props.add((OWLObjectPropertyExpression)prop);
        }
        return props;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)object;
        int diff = this.expression.compareTo(other.getClassExpression());
        if (diff != 0) {
            return diff;
        }
        return OWLHasKeyAxiomImpl.compareSets(this.propertyExpressions, other.getPropertyExpressions());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLHasKeyAxiom)) {
            return false;
        }
        if (obj instanceof OWLHasKeyAxiomImpl) {
            return this.expression.equals(((OWLHasKeyAxiomImpl)obj).expression) && this.propertyExpressions.equals(((OWLHasKeyAxiomImpl)obj).propertyExpressions);
        }
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)obj;
        return this.expression.equals(other.getClassExpression()) && this.getPropertyExpressions().equals(other.getPropertyExpressions());
    }
}

