/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.TimezoneHelper;
import tim.prune.correlate.AudioTimestampSelector;
import tim.prune.correlate.Correlator;
import tim.prune.correlate.MediaPreviewTableModel;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.correlate.PointMediaPair;
import tim.prune.data.AudioClip;
import tim.prune.data.AudioList;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.TimeDifference;
import tim.prune.data.Timestamp;
import tim.prune.data.TimestampUtc;
import tim.prune.undo.UndoCorrelateAudios;

public class AudioCorrelator
extends Correlator {
    private AudioTimestampSelector _fileTimesSelector = null;
    private AudioTimestampSelector _correlTimesSelector = null;

    public AudioCorrelator(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.correlateaudios";
    }

    @Override
    protected String getMediaTypeKey() {
        return "audio";
    }

    @Override
    protected MediaList getMediaList() {
        return this._app.getTrackInfo().getAudioList();
    }

    @Override
    protected JPanel makeFirstPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        this._fileTimesSelector = new AudioTimestampSelector("dialog.correlate.filetimes", "dialog.correlate.filetimes2");
        jPanel2.add(this._fileTimesSelector);
        this._correlTimesSelector = new AudioTimestampSelector("dialog.correlate.correltimes", null);
        jPanel2.add(this._correlTimesSelector);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    protected boolean[] getCardEnabledFlags() {
        boolean[] blArray = super.getCardEnabledFlags();
        blArray[0] = AudioCorrelator.getAudioLengthAvailability(this._app.getTrackInfo().getAudioList());
        return blArray;
    }

    private static boolean getAudioLengthAvailability(AudioList audioList) {
        int n = 0;
        while (n < audioList.getNumMedia()) {
            AudioClip audioClip = audioList.getAudio(n);
            if (audioClip.getLengthInSeconds() > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void createPreview(TimeDifference timeDifference, boolean bl) {
        TimeDifference timeDifference2 = this.parseTimeLimit();
        double d = this.parseDistanceLimit();
        MediaPreviewTableModel mediaPreviewTableModel = new MediaPreviewTableModel("dialog.correlate.select.audioname");
        AudioList audioList = this._app.getTrackInfo().getAudioList();
        int n = audioList.getNumAudios();
        int n2 = 0;
        while (n2 < n) {
            AudioClip audioClip = audioList.getAudio(n2);
            PointMediaPair pointMediaPair = this.getPointPairForMedia(this._app.getTrackInfo().getTrack(), audioClip, timeDifference);
            MediaPreviewTableRow mediaPreviewTableRow = new MediaPreviewTableRow(pointMediaPair);
            boolean bl2 = pointMediaPair.isValid();
            if (audioClip.getCurrentStatus() != MediaObject.Status.NOT_CONNECTED) {
                bl2 = false;
            }
            if (timeDifference2 != null && bl2) {
                long l = pointMediaPair.getMinSeconds();
                boolean bl3 = bl2 = l <= timeDifference2.getTotalSeconds();
            }
            if (d > 0.0 && bl2) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter());
                double d4 = pointMediaPair.getFraction();
                if (d4 > 0.5) {
                    d4 = 1.0 - d4;
                }
                boolean bl4 = bl2 = (d2 = d3 * d4) < d;
            }
            if (pointMediaPair.getSecondsBefore() == 0L && pointMediaPair.getPointBefore().isDuplicate(audioClip.getDataPoint())) {
                bl2 = false;
            }
            mediaPreviewTableRow.setCorrelateFlag(bl2);
            mediaPreviewTableModel.addRow(mediaPreviewTableRow);
            ++n2;
        }
        this._previewTable.setModel(mediaPreviewTableModel);
        mediaPreviewTableModel.setDistanceUnits(this.getSelectedDistanceUnits());
        this._previewTable.setAutoResizeMode(4);
        int[] nArray = new int[]{150, 160, 100, 100, 50};
        int n3 = 0;
        while (n3 < mediaPreviewTableModel.getColumnCount()) {
            this._previewTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            ++n3;
        }
        this._okButton.setEnabled(mediaPreviewTableModel.hasAnySelected());
        if (bl && !mediaPreviewTableModel.hasAnySelected()) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.correlate.alloutsiderange"), I18nManager.getText(this.getNameKey()), 0);
        }
    }

    @Override
    protected Timestamp getMediaTimestamp(MediaObject mediaObject) {
        Timestamp timestamp = super.getMediaTimestamp(mediaObject);
        long l = timestamp.getMilliseconds(TimezoneHelper.getSelectedTimezone());
        try {
            AudioClip audioClip = (AudioClip)mediaObject;
            int n = audioClip.getLengthInSeconds();
            int n2 = n * (this._correlTimesSelector.getSelectedOption() - this._fileTimesSelector.getSelectedOption()) / 2;
            if (n > 0 && n2 != 0) {
                timestamp = new TimestampUtc(l += (long)n2 * 1000L);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return timestamp;
    }

    @Override
    protected void finishCorrelation() {
        Object object;
        PointMediaPair[] pointMediaPairArray = this.getPointPairs();
        if (pointMediaPairArray == null || pointMediaPairArray.length <= 0) {
            return;
        }
        UndoCorrelateAudios undoCorrelateAudios = new UndoCorrelateAudios(this._app.getTrackInfo());
        int n = pointMediaPairArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PointMediaPair pointMediaPair = null;
        n2 = 0;
        while (n2 < n) {
            pointMediaPair = pointMediaPairArray[n2];
            if (pointMediaPair != null && pointMediaPair.isValid()) {
                if (pointMediaPair.getMinSeconds() == 0L) {
                    object = pointMediaPair.getPointBefore().getAudio();
                    if (object == null) {
                        pointMediaPair.getPointBefore().setAudio((AudioClip)pointMediaPair.getMedia());
                        pointMediaPair.getMedia().setDataPoint(pointMediaPair.getPointBefore());
                    } else if (!object.equals(pointMediaPair.getMedia())) {
                        ++n4;
                    }
                } else {
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (n4 > 0) {
            object = new DataPoint[n4];
            int n5 = 0;
            DataPoint dataPoint = null;
            n2 = 0;
            while (n2 < n) {
                pointMediaPair = pointMediaPairArray[n2];
                if (pointMediaPair != null && pointMediaPair.isValid()) {
                    dataPoint = null;
                    if (pointMediaPair.getMinSeconds() == 0L && pointMediaPair.getPointBefore().getAudio() != null && !pointMediaPair.getPointBefore().getAudio().equals(pointMediaPair.getMedia())) {
                        dataPoint = pointMediaPair.getPointBefore().clonePoint();
                    } else if (pointMediaPair.getMinSeconds() > 0L) {
                        dataPoint = DataPoint.interpolate(pointMediaPair.getPointBefore(), pointMediaPair.getPointAfter(), pointMediaPair.getFraction());
                    }
                    if (dataPoint != null) {
                        dataPoint.setAudio((AudioClip)pointMediaPair.getMedia());
                        pointMediaPair.getMedia().setDataPoint(dataPoint);
                        dataPoint.setSegmentStart(true);
                        object[n5] = dataPoint;
                        ++n5;
                    }
                }
                ++n2;
            }
            this._app.getTrackInfo().getTrack().appendPoints((DataPoint[])object);
        }
        undoCorrelateAudios.setNumAudiosCorrelated(n3);
        this._app.completeFunction(undoCorrelateAudios, n3 + " " + (n3 == 1 ? I18nManager.getText("confirm.correlateaudios.single") : I18nManager.getText("confirm.correlateaudios.multi")));
        if (n4 == 0) {
            UpdateMessageBroker.informSubscribers((byte)4);
        }
    }
}

