/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.SourceInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchResult;
import tim.prune.load.MediaLinkInfo;

public class SearchMapillaryFunction
extends GenericDownloaderFunction {
    private static final int MAX_RESULTS = 20;

    public SearchMapillaryFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.mapillary";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    @Override
    public void run() {
        Object object;
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double d = 0.0;
        double d2 = 0.0;
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            object = this._app.getViewport().getBounds();
            d = (object[0] + object[2]) / 2.0;
            d2 = (object[1] + object[3]) / 2.0;
        } else {
            d = dataPoint.getLatitude().getDouble();
            d2 = dataPoint.getLongitude().getDouble();
        }
        object = "http://api.mapillary.com/v1/im/close?lat=" + d + "&lon=" + d2 + "&distance=1000&limit=" + 20;
        InputStream inputStream = null;
        try {
            inputStream = new URL((String)object).openStream();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while ((n = inputStream.read()) >= 0) {
                stringBuilder.append((char)n);
            }
            ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
            String[] stringArray = stringBuilder.toString().split("\\},\\{");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object2;
                String string = stringArray[n3];
                SearchResult searchResult = new SearchResult();
                String[] stringArray2 = string.split(",");
                int n4 = stringArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    object2 = stringArray2[n5];
                    String string2 = SearchMapillaryFunction.getKey((String)object2);
                    if (string2 != null) {
                        if (string2.equals("key")) {
                            String string3 = SearchMapillaryFunction.getValue((String)object2);
                            searchResult.setDownloadLink("http://images.mapillary.com/" + string3 + "/thumb-1024.jpg");
                            searchResult.setWebUrl("http://www.mapillary.com/map/im/" + string3);
                            searchResult.setTrackName(string3);
                        } else if (string2.equals("lat")) {
                            searchResult.setLatitude(SearchMapillaryFunction.getValue((String)object2));
                        } else if (string2.equals("lon")) {
                            searchResult.setLongitude(SearchMapillaryFunction.getValue((String)object2));
                        }
                    }
                    ++n5;
                }
                if (searchResult.getLatitude() != null && searchResult.getLongitude() != null && searchResult.getTrackName() != null) {
                    object2 = new DataPoint(new Latitude(searchResult.getLatitude()), new Longitude(searchResult.getLongitude()), null);
                    if (((DataPoint)object2).isValid() && dataPoint != null && dataPoint.isValid()) {
                        double d3 = DataPoint.calculateRadiansBetween(dataPoint, (DataPoint)object2);
                        double d4 = Distance.convertRadiansToDistance(d3, UnitSetLibrary.UNITS_METRES);
                        searchResult.setLength(d4);
                    }
                    if (searchResult.getTrackName() != null) {
                        arrayList.add(searchResult);
                    }
                }
                ++n3;
            }
            if (!arrayList.isEmpty()) {
                this._trackListModel.addTracks(arrayList);
            }
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.mapillary.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private static String getKey(String string) {
        char c;
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return null;
        }
        int n2 = 0;
        while ((c = string.charAt(n2)) == '[' || c == '{' || c == '\"') {
            ++n2;
        }
        int n3 = n;
        while ((c = string.charAt(n3 - 1)) == '\"') {
            --n3;
        }
        return string.substring(n2, n3);
    }

    private static String getValue(String string) {
        char c;
        int n = string.indexOf(58);
        if (n <= 0 || n >= string.length()) {
            return null;
        }
        int n2 = n + 1;
        while ((c = string.charAt(n2)) == '\"') {
            ++n2;
        }
        int n3 = string.length() - 1;
        while ((c = string.charAt(n3 - 1)) == '\"' || c == '}' || c == ']') {
            --n3;
        }
        return string.substring(n2, n3);
    }

    @Override
    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        Object[][] objectArray = new String[n][];
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new String[3];
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                SearchResult searchResult = this._trackListModel.getTrack(n3);
                objectArray[n2][0] = searchResult.getLatitude();
                objectArray[n2][1] = searchResult.getLongitude();
                objectArray[n2][2] = "1";
                stringArray[n2] = searchResult.getDownloadLink();
            }
            ++n2;
        }
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.NEW_SEGMENT};
        this._app.autoAppendNextFile();
        this._app.informDataLoaded(fieldArray, objectArray, null, new SourceInfo("mapillary", SourceInfo.FILE_TYPE.JSON), null, new MediaLinkInfo(stringArray));
        this._cancelled = true;
        this._dialog.dispose();
    }
}

