/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0015\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BE\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000bH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u0010092\u0006\u0010:\u001a\u00020\u0006H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\u00102\u0006\u0010<\u001a\u00020\u0010H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010>\u001a\u00020\u0010H\u0002J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u000bH&J\u001d\u0010B\u001a\u00020\u000b2\u0006\u0010<\u001a\u00028\u00002\u0006\u0010C\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u0010092\u0006\u0010F\u001a\u00020\u0006H\u0016J\u0015\u0010G\u001a\u00028\u00002\u0006\u0010F\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010HJ\u001d\u0010G\u001a\u00028\u00002\u0006\u0010C\u001a\u00020*2\u0006\u0010I\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010JJ\u0012\u0010K\u001a\u0004\u0018\u00010\u00102\u0006\u0010L\u001a\u00020\u0006H\u0002J\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001009*\b\u0012\u0004\u0012\u00020\u001009H\u0002R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0019\u001a\u0004\b&\u0010\u0015R*\u0010(\u001a\u001e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00028\u00000)j\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00028\u0000`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0019\u001a\u0004\b-\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0018\u00101\u001a\u00020\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "repositories", "", "", "directLibs", "distributionKlib", "localKotlinDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "currentDirHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getCurrentDirHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "defaultRoots", "getDefaultRoots", "()Ljava/util/List;", "directLibraries", "getDirectLibraries", "directLibraries$delegate", "Lkotlin/Lazy;", "distHead", "getDistHead", "distPlatformHead", "getDistPlatformHead", "getDistributionKlib", "()Ljava/lang/String;", "localHead", "getLocalHead", "getLocalKotlinDir", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "repoRoots", "getRepoRoots", "repoRoots$delegate", "resolvedLibraries", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "Lkotlin/collections/HashMap;", "searchRoots", "getSearchRoots", "searchRoots$delegate", "getSkipCurrentDir", "()Z", "klib", "getKlib", "(Lorg/jetbrains/kotlin/konan/file/File;)Lorg/jetbrains/kotlin/konan/file/File;", "defaultLinks", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "directLibsSequence", "Lkotlin/sequences/Sequence;", "givenName", "found", "candidate", "getDefaultLibrariesFromDir", "directory", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "unresolved", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "resolutionSequence", "givenPath", "resolve", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "isDefaultLink", "(Lorg/jetbrains/kotlin/library/UnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "validFileOrNull", "path", "filterOutPre_1_4_libraries", "kotlin-util-klib"})
public abstract class KotlinLibrarySearchPathResolver<L extends KotlinLibrary>
implements SearchPathResolver<L> {
    @Nullable
    private final String distributionKlib;
    @Nullable
    private final String localKotlinDir;
    private final boolean skipCurrentDir;
    @NotNull
    private final Logger logger;
    @Nullable
    private final File distPlatformHead;
    @NotNull
    private final Lazy repoRoots$delegate;
    @NotNull
    private final Lazy directLibraries$delegate;
    @NotNull
    private final Lazy searchRoots$delegate;
    @NotNull
    private final HashMap<UnresolvedLibrary, L> resolvedLibraries;

    public KotlinLibrarySearchPathResolver(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.distributionKlib = distributionKlib;
        this.localKotlinDir = localKotlinDir;
        this.skipCurrentDir = skipCurrentDir;
        this.logger = logger;
        this.repoRoots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends File>>(repositories){
            final /* synthetic */ List<String> $repositories;
            {
                this.$repositories = $repositories;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<File> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$repositories;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file2 = new File((String)it);
                    collection.add(file2);
                }
                return (List)destination$iv$iv;
            }
        });
        this.directLibraries$delegate = LazyKt.lazy(new Function0<List<? extends L>>(directLibs, this){
            final /* synthetic */ List<String> $directLibs;
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.$directLibs = $directLibs;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<L> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable iterable = this.$directLibs;
                KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var4_4 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    File file2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (KotlinLibrarySearchPathResolver.access$found(kotlinLibrarySearchPathResolver, new File(it)) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    File it$iv$iv = file2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                kotlinLibrarySearchPathResolver = this.this$0;
                boolean $i$f$flatMap = false;
                $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = kotlinLibrarySearchPathResolver.libraryComponentBuilder(it, false);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        this.searchRoots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends File>>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<File> invoke() {
                File[] fileArray = new File[]{this.this$0.getLocalHead(), this.this$0.getDistHead(), this.this$0.getDistPlatformHead()};
                return CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(this.this$0.getCurrentDirHead()), (Iterable)KotlinLibrarySearchPathResolver.access$getRepoRoots(this.this$0)), (Iterable)CollectionsKt.listOf(fileArray)));
            }
        });
        this.resolvedLibraries = new HashMap();
    }

    @Nullable
    public final String getDistributionKlib() {
        return this.distributionKlib;
    }

    @Nullable
    public final String getLocalKotlinDir() {
        return this.localKotlinDir;
    }

    public final boolean getSkipCurrentDir() {
        return this.skipCurrentDir;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final File getLocalHead() {
        File file2;
        String string2 = this.localKotlinDir;
        return string2 == null ? null : ((file2 = FileKt.File(string2)) == null ? null : this.getKlib(file2));
    }

    @Nullable
    public final File getDistHead() {
        File file2;
        String string2 = this.distributionKlib;
        return string2 == null ? null : ((file2 = FileKt.File(string2)) == null ? null : file2.child("common"));
    }

    @Nullable
    public File getDistPlatformHead() {
        return this.distPlatformHead;
    }

    @Nullable
    public final File getCurrentDirHead() {
        return !this.skipCurrentDir ? File.Companion.getUserDir() : null;
    }

    private final List<File> getRepoRoots() {
        Lazy lazy = this.repoRoots$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public abstract List<L> libraryComponentBuilder(@NotNull File var1, boolean var2);

    private final List<KotlinLibrary> getDirectLibraries() {
        Lazy lazy = this.directLibraries$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<File> getSearchRoots() {
        Lazy lazy = this.searchRoots$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private final File found(File candidate2) {
        File noSuffix = new File(UtilKt.removeSuffixIfPresent(candidate2.getPath(), ".klib"));
        File withSuffix = new File(UtilKt.suffixIfNot(candidate2.getPath(), ".klib"));
        return KotlinLibrarySearchPathResolver.found$check(withSuffix) ? withSuffix : (KotlinLibrarySearchPathResolver.found$check(noSuffix) ? noSuffix : null);
    }

    private final File validFileOrNull(String path2) {
        Object object;
        try {
            object = Paths.get(path2, new String[0]);
            Intrinsics.checkNotNullExpressionValue(object, "get(path)");
            object = new File((Path)object);
        }
        catch (InvalidPathException _) {
            object = null;
        }
        return object;
    }

    private final Sequence<File> directLibsSequence(String givenName) {
        return SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getDirectLibraries()), (Function1)new Function1<KotlinLibrary, Boolean>(givenName){
            final /* synthetic */ String $givenName;
            {
                this.$givenName = $givenName;
                super(1);
            }

            public final boolean invoke(@NotNull KotlinLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(KotlinLibraryKt.getUniqueName(it), this.$givenName);
            }
        }), directLibsSequence.2.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<File> resolutionSequence(@NotNull String givenPath) {
        Sequence<File> sequence2;
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        File given = this.validFileOrNull(givenPath);
        if (given == null) {
            sequence2 = this.directLibsSequence(givenPath);
        } else if (given.isAbsolute()) {
            File[] fileArray = new File[]{this.found(given)};
            sequence2 = SequencesKt.sequenceOf(fileArray);
        } else {
            Sequence repoLibs2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getSearchRoots()), (Function1)new Function1<File, File>(this, given){
                final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                final /* synthetic */ File $given;
                {
                    this.this$0 = $receiver;
                    this.$given = $given;
                    super(1);
                }

                @Nullable
                public final File invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return KotlinLibrarySearchPathResolver.access$found(this.this$0, new File(it, this.$given));
                }
            });
            sequence2 = SequencesKt.plus(this.directLibsSequence(givenPath), repoLibs2);
        }
        Sequence<File> sequence3 = sequence2;
        return SequencesKt.filterNotNull(sequence3);
    }

    private final Sequence<File> filterOutPre_1_4_libraries(Sequence<File> $this$filterOutPre_1_4_libraries) {
        return SequencesKt.filter($this$filterOutPre_1_4_libraries, (Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull File it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (KotlinLibraryImplKt.isPre_1_4_Library(it)) {
                    this.this$0.getLogger().warning("Skipping \"" + it + "\" as it is a pre 1.4 library");
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public L resolve(@NotNull UnresolvedLibrary unresolved, boolean isDefaultLink) {
        Object object;
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        Map $this$getOrPut$iv = this.resolvedLibraries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(unresolved);
        if (value$iv == null) {
            KotlinLibrary kotlinLibrary;
            boolean bl = false;
            String givenPath = unresolved.getPath();
            try {
                Sequence<File> fileSequence = this.resolutionSequence(givenPath);
                Sequence matching2 = SequencesKt.filterNotNull(SequencesKt.map(SequencesKt.flatMap(this.filterOutPre_1_4_libraries(fileSequence), new Function1<File, Sequence<? extends L>>(this, isDefaultLink){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ boolean $isDefaultLink;
                    {
                        this.this$0 = $receiver;
                        this.$isDefaultLink = $isDefaultLink;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<L> invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return CollectionsKt.asSequence((Iterable)this.this$0.libraryComponentBuilder(it, this.$isDefaultLink));
                    }
                }), new Function1<L, L>(this, unresolved){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ UnresolvedLibrary $unresolved;
                    {
                        this.this$0 = $receiver;
                        this.$unresolved = $unresolved;
                        super(1);
                    }

                    @Nullable
                    public final L invoke(@NotNull L it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        L l = it;
                        KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                        UnresolvedLibrary unresolvedLibrary = this.$unresolved;
                        boolean bl = false;
                        boolean bl2 = false;
                        L it2 = l;
                        boolean bl3 = false;
                        return (L)(kotlinLibrarySearchPathResolver.libraryMatch(it2, unresolvedLibrary) ? l : null);
                    }
                }));
                KotlinLibrary kotlinLibrary2 = (KotlinLibrary)SequencesKt.firstOrNull(matching2);
                if (kotlinLibrary2 == null) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    KotlinLibrarySearchPathResolver kotlinLibrarySearchPathResolver = this;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    KotlinLibrarySearchPathResolver $this$resolve_u24lambda_u2d2_u24lambda_u2d1 = kotlinLibrarySearchPathResolver;
                    boolean bl4 = false;
                    Iterable iterable = $this$resolve_u24lambda_u2d2_u24lambda_u2d1.getSearchRoots();
                    StringBuilder stringBuilder2 = new StringBuilder().append("Could not find \"").append(givenPath).append("\" in ");
                    Logger logger = $this$resolve_u24lambda_u2d2_u24lambda_u2d1.getLogger();
                    boolean $i$f$map = false;
                    void var20_21 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        File file2 = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        String string2 = it.getAbsolutePath();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    logger.fatal(stringBuilder2.append(collection).append('.').toString());
                    throw null;
                }
                kotlinLibrary = kotlinLibrary2;
            }
            catch (Throwable e) {
                this.getLogger().error(Intrinsics.stringPlus("Failed to resolve Kotlin library: ", givenPath));
                throw e;
            }
            KotlinLibrary answer$iv = kotlinLibrary;
            $this$getOrPut$iv.put(unresolved, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (L)((KotlinLibrary)object);
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        return true;
    }

    @Override
    @NotNull
    public L resolve(@NotNull String givenPath) {
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        return this.resolve(new UnresolvedLibrary(givenPath, null), false);
    }

    private final File getKlib(File $this$klib) {
        return new File($this$klib, "klib");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getDefaultRoots() {
        void $this$filterTo$iv$iv;
        File[] fileArray = new File[]{this.getDistHead(), this.getDistPlatformHead()};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull(fileArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.getExists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Sequence<L> getDefaultLibrariesFromDir(File directory) {
        return directory.getExists() ? SequencesKt.map(SequencesKt.map(SequencesKt.filterNot(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)directory.getListFiles()), getDefaultLibrariesFromDir.1.INSTANCE), getDefaultLibrariesFromDir.2.INSTANCE), getDefaultLibrariesFromDir.3.INSTANCE), new Function1<UnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final L invoke(@NotNull UnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.resolve(it, true);
            }
        }) : SequencesKt.emptySequence();
    }

    @Override
    @NotNull
    public List<L> defaultLinks(boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        File file2;
        File it;
        boolean bl;
        boolean bl2;
        File file3;
        File file4;
        boolean bl3 = false;
        List result2 = new ArrayList();
        if (!noStdLib) {
            result2.add(this.resolve(new UnresolvedLibrary("stdlib", null), true));
        }
        if (!noEndorsedLibs && (file4 = this.getDistHead()) != null) {
            file3 = file4;
            bl2 = false;
            bl = false;
            it = file3;
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)result2, this.getDefaultLibrariesFromDir(it));
        }
        if (!noDefaultLibs && (file2 = this.getDistPlatformHead()) != null) {
            file3 = file2;
            bl2 = false;
            bl = false;
            it = file3;
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)result2, this.getDefaultLibrariesFromDir(it));
        }
        return result2;
    }

    @Override
    public boolean isProvidedByDefault(@NotNull UnresolvedLibrary unresolved) {
        return SearchPathResolver.DefaultImpls.isProvidedByDefault(this, unresolved);
    }

    private static final boolean found$check(File file2) {
        return file2.getExists();
    }

    public static final /* synthetic */ File access$found(KotlinLibrarySearchPathResolver $this, File candidate2) {
        return $this.found(candidate2);
    }

    public static final /* synthetic */ List access$getRepoRoots(KotlinLibrarySearchPathResolver $this) {
        return $this.getRepoRoots();
    }
}

