/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.directwebremoting.ConversionException;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.convert.StringEnumAbstractBaseConverter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.PropertyDescriptorProperty;
import org.directwebremoting.util.LocalUtil;

public class XmlBeanConverter
extends BeanConverter {
    private final StringEnumAbstractBaseConverter enumConverter = new StringEnumAbstractBaseConverter();
    private static Log log = LogFactory.getLog(XmlBeanConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data == null) {
            return null;
        }
        String value = data.getValue();
        log.debug((Object)("handling variable (" + value + ") for class (" + paramType.getName() + ")"));
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{") || !value.endsWith("}")) {
            log.warn((Object)("Expected object while converting data for " + paramType.getName() + " in " + data.getContext().getCurrentProperty() + ". Passed: " + value));
            throw new ConversionException(paramType, "Data conversion error. See logs for more details.");
        }
        value = value.substring(1, value.length() - 1);
        try {
            if (this.instanceType != null) {
                LocalUtil.classForName(this.instanceType.getName());
            } else {
                LocalUtil.classForName(paramType.getName());
            }
            Class<?>[] innerClasses = paramType.getClasses();
            Class<?> factory = null;
            for (Class<?> aClass : innerClasses) {
                if (!aClass.getName().endsWith("Factory")) continue;
                factory = aClass;
            }
            if (factory == null) {
                log.error((Object)("XmlObject.Factory method not found for Class [" + paramType.toString() + "]"));
                throw new ConversionException(paramType, "XmlObject.Factory method not found");
            }
            Class[] emptyArglist = new Class[]{};
            Method newInstance = factory.getMethod("newInstance", emptyArglist);
            Object bean = newInstance.invoke(null, (Object[])emptyArglist);
            if (this.instanceType != null) {
                data.getContext().addConverted(data, this.instanceType, bean);
            } else {
                data.getContext().addConverted(data, paramType, bean);
            }
            Map<String, Property> properties = this.getPropertyMapFromClass(paramType, false, true);
            Map<String, String> tokens = XmlBeanConverter.extractInboundTokens(paramType, value);
            for (Map.Entry<String, String> entry : tokens.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                log.debug((Object)("token entry (" + key + ") with value (" + val + ")"));
                Property property = properties.get(key);
                if (property == null) {
                    log.warn((Object)("Missing java bean property to match javascript property: " + key + ". For causes see debug level logs:"));
                    log.debug((Object)"- The javascript may be refer to a property that does not exist");
                    log.debug((Object)("- You may be missing the correct setter: set" + Character.toTitleCase(key.charAt(0)) + key.substring(1) + "()"));
                    log.debug((Object)"- The property may be excluded using include or exclude rules.");
                    StringBuffer all = new StringBuffer();
                    Iterator<String> pit = properties.keySet().iterator();
                    while (pit.hasNext()) {
                        all.append(pit.next());
                        if (!pit.hasNext()) continue;
                        all.append(',');
                    }
                    log.debug((Object)("Fields exist for (" + all + ")."));
                    continue;
                }
                Class<?> propType = property.getPropertyType();
                Object output = this.convert(val, propType, data.getContext(), property);
                property.setValue(bean, output);
            }
            return bean;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public Map<String, Property> getPropertyMapFromClass(Class<?> paramType, boolean readRequired, boolean writeRequired) throws ConversionException {
        try {
            if (!XmlObject.class.isAssignableFrom(paramType)) {
                throw new ConversionException(paramType, "class (" + paramType.getName() + ") not assignable from XmlObject");
            }
            Class<Object> beanInterface = paramType.isInterface() ? paramType : paramType.getInterfaces()[0];
            Class superInterface = (Class)beanInterface.getGenericInterfaces()[0];
            HashMap<String, Property> properties = new HashMap<String, Property>();
            while (XmlObject.class.isAssignableFrom(superInterface)) {
                BeanInfo info = Introspector.getBeanInfo(beanInterface);
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor descriptor = descriptors[i];
                    String name = descriptor.getName();
                    String type = descriptor.getPropertyType().getName();
                    if (type.matches(".*\\$Enum")) {
                        this.getConverterManager().addConverter(type, (Converter)this.enumConverter);
                    }
                    if ("class".equals(name) || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && LocalUtil.getWriteMethod(paramType, descriptor) == null) continue;
                    properties.put(name, new PropertyDescriptorProperty(descriptor));
                }
                beanInterface = (Class<Object>)beanInterface.getGenericInterfaces()[0];
                superInterface = (Class)beanInterface.getGenericInterfaces()[0];
            }
            return properties;
        }
        catch (IntrospectionException ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }
}

