# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the eos_bgp_address_family module
"""


class Bgp_afArgs(object):  # pylint: disable=R0903
    """The arg spec for the eos_bgp_address_family module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "running_config": {"type": "str"},
        "state": {
            "default": "merged",
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
        },
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "str"},
                "address_family": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "network": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "route_map": {"type": "str"},
                                "address": {"type": "str"},
                            },
                        },
                        "redistribute": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "ospf_route": {
                                    "type": "str",
                                    "choices": [
                                        "internal",
                                        "external",
                                        "nssa_external_1",
                                        "nssa_external_2",
                                    ],
                                },
                                "route_map": {"type": "str"},
                                "protocol": {
                                    "type": "str",
                                    "choices": ["isis", "ospf3", "dhcp"],
                                },
                                "isis_level": {
                                    "type": "str",
                                    "choices": [
                                        "level-1",
                                        "level-2",
                                        "level-1-2",
                                    ],
                                },
                            },
                        },
                        "route_target": {
                            "type": "dict",
                            "options": {
                                "mode": {
                                    "type": "str",
                                    "choices": ["both", "import", "export"],
                                },
                                "target": {"type": "str"},
                            },
                        },
                        "graceful_restart": {"type": "bool"},
                        "bgp_params": {
                            "type": "dict",
                            "options": {
                                "next_hop_address_family": {
                                    "type": "str",
                                    "choices": ["ipv6"],
                                },
                                "redistribute_internal": {"type": "bool"},
                                "route": {"type": "str"},
                                "additional_paths": {
                                    "type": "str",
                                    "choices": ["install", "send", "receive"],
                                },
                                "next_hop_unchanged": {"type": "bool"},
                            },
                        },
                        "safi": {
                            "type": "str",
                            "choices": ["labeled-unicast", "multicast"],
                        },
                        "neighbor": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "activate": {"type": "bool"},
                                "graceful_restart": {"type": "bool"},
                                "weight": {"type": "int"},
                                "default_originate": {
                                    "type": "dict",
                                    "options": {
                                        "route_map": {"type": "str"},
                                        "always": {"type": "bool"},
                                    },
                                },
                                "route_map": {
                                    "type": "dict",
                                    "options": {
                                        "direction": {
                                            "type": "str",
                                            "choices": ["in", "out"],
                                        },
                                        "name": {"type": "str"},
                                    },
                                },
                                "next_hop_address_family": {
                                    "type": "str",
                                    "choices": ["ipv6"],
                                },
                                "additional_paths": {
                                    "type": "str",
                                    "choices": ["send", "receive"],
                                },
                                "peer": {"type": "str"},
                                "encapsulation": {
                                    "type": "dict",
                                    "options": {
                                        "transport": {
                                            "type": "str",
                                            "choices": ["mpls", "vxlan"],
                                        },
                                        "source_interface": {"type": "str"},
                                    },
                                },
                                "prefix_list": {
                                    "type": "dict",
                                    "options": {
                                        "direction": {
                                            "type": "str",
                                            "choices": ["in", "out"],
                                        },
                                        "name": {"type": "str"},
                                    },
                                },
                                "next_hop_unchanged": {"type": "bool"},
                            },
                        },
                        "afi": {
                            "type": "str",
                            "choices": ["ipv4", "ipv6", "evpn"],
                        },
                        "vrf": {"type": "str"},
                    },
                },
            },
        },
    }  # pylint: disable=C0301
