complete -c curl -n 'string match -qr "^@" -- (commandline -ct)' -k -xa "(printf '%s\n' -- @(__fish_complete_suffix (commandline -ct | string replace -r '^@' '') ''))"

# These based on the autogenerated completions.
complete -c curl -l abstract-unix-socket -d '(HTTP) Connect through an abstract Unix domain socket, instead of using the n…'
complete -c curl -l anyauth -d '(HTTP) Use most secure authentication method automatically'
complete -c curl -s a -l append -d '(FTP SFTP) Upload: append to the target file'
complete -c curl -l basic -d '(HTTP) Use HTTP Basic authentication'
complete -c curl -l cacert -d '(TLS) Use the specified certificate file'
complete -c curl -l capath -d '(TLS) Use the specified certificate directory'
complete -c curl -l cert-status -d '(TLS) Use Certificate Status Request (aka OCSP stapling)'
complete -c curl -l cert-type -d '(TLS) Set type of the provided client certificate' -a 'PEM, DER ENG P12'
complete -c curl -s E -l cert -d '(TLS) Use this cert'
complete -c curl -l ciphers -d '(TLS) Specifies which ciphers to use'
complete -c curl -l compressed-ssh -d '(SCP SFTP) Enables built-in SSH compression'
complete -c curl -l compressed -d '(HTTP) Request a compressed response'
complete -c curl -s K -l config -d 'Specify a text file to read curl arguments from'
complete -c curl -l connect-timeout -d 'Maximum time in seconds you allow connection to take'
complete -c curl -l connect-to -d 'For a request to the given HOST1:PORT1 pair, connect to HOST2:PORT2 instead'
complete -c curl -s C -l continue-at -d 'Continue/Resume a previous file transfer at the given offset'
complete -c curl -s c -l cookie-jar -d '(HTTP) Write all cookies to this file'
complete -c curl -s b -l cookie -d '(HTTP) Pass the data to the HTTP server in the Cookie header'
complete -c curl -l create-dirs -d 'Create dirs for -o/--output'
complete -c curl -l crlf -d '(FTP SMTP) Convert LF to CRLF in upload.  Useful for MVS (OS/390)'
complete -c curl -l crlfile -d '(TLS) Provide a file using PEM format with a Certificate Revocation List'
complete -c curl -l data-ascii -d '(HTTP) Alias for -d, --data'
complete -c curl -l data-binary -d '(HTTP) Post data exactly as specified with no processing'
complete -c curl -l data-raw -d '(HTTP) Post data like --data but without interpeting "@"'
complete -c curl -l data-urlencode -d '(HTTP) Post data URL-encoded'
complete -c curl -s d -l data -d '(HTTP) Sends the specified data in a POST request to the HTTP server'
complete -c curl -l delegation -d '(GSS/kerberos) Tell the server how much it can delegate for user creds' -xa '(
printf %s\t%s\n \
none "Don\'t allow any delegation" \
policy "Delegate only if the OK-AS-DELEGATE flag is set in the Kerberos service ticket" \
always "Allow the server to delegate")'
complete -c curl -l digest -d '(HTTP) Enables HTTP Digest authentication'
complete -c curl -l disable-eprt -d '(FTP) Don\'t use EPRT and LPRT commands in active FTP'
complete -c curl -l disable-epsv -d '(FTP) Don\'t use EPSV in passive FTP'
complete -c curl -s q -l disable -d 'Disable curlrc'
complete -c curl -l disallow-username-in-url -d '(HTTP) Exit if passed a url containing a username'
complete -c curl -l dns-interface -d '(DNS) Send outgoing DNS requests through <interface>'
complete -c curl -l dns-ipv4-addr -d '(DNS) Bind to <ip-address> when making IPv4 DNS requests'
complete -c curl -l dns-ipv6-addr -d '(DNS) Bind to <ip-address> when making IPv6 DNS requests'
complete -c curl -l dns-servers -d 'Set the list of DNS servers to use'
complete -c curl -l doh-url -d '(all) Specify which DNS-over-HTTPS (DOH) server to use to resolve hostnames'
complete -c curl -s D -l dump-header -d '(HTTP FTP) Write the received protocol headers to the specified file'
complete -c curl -l egd-file -d '(TLS) Specify the path name to the Entropy Gathering Daemon socket'
complete -c curl -l engine -d '(TLS) Select the OpenSSL crypto engine to use for cipher operations'
complete -c curl -l expect100-timeout -d '(HTTP) Maximum time in seconds to wait for a 100-continue'
complete -c curl -l fail-early -d 'Fail and exit on the first detected transfer error'
complete -c curl -s f -l fail -d '(HTTP) Fail silently (no output at all) on server errors'
complete -c curl -l false-start -d '(TLS) Use false start during the TLS handshake'
complete -c curl -l form-string -d '(HTTP SMTP IMAP) Like --form except using value string literally'
complete -c curl -s F -l form -d '(HTTP SMTP IMAP) Emulate pressing submit on filled-in form'
complete -c curl -l ftp-account -d '(FTP) Data for the ACCT command'
complete -c curl -l ftp-alternative-to-user -d '(FTP) If USER and PASS commands fail, send this command'
complete -c curl -l ftp-create-dirs -d '(FTP SFTP) Create missing dirs with ftp'
complete -c curl -l ftp-method -d '(FTP) Control what method curl should use to reach a file on an FTP(S) server'
complete -c curl -l ftp-pasv -d '(FTP) Use passive mode for the data connection'
complete -c curl -s P -l ftp-port -d '(FTP) Reverses the default initiator/listener roles when connecting with FTP'
complete -c curl -l ftp-pret -d '(FTP) Tell curl to send a PRET command before PASV (and EPSV)'
complete -c curl -l ftp-skip-pasv-ip -d '(FTP) Use same IP instead of IP the server suggests in response to PASV'
complete -c curl -l ftp-ssl-ccc-mode -d '(FTP) Sets the CCC mode'
complete -c curl -l ftp-ssl-ccc -d '(FTP) Use CCC (Clear Command Channel) Shuts down the SSL/TLS layer after auth'
complete -c curl -l ftp-ssl-control -d '(FTP) Require SSL/TLS for the FTP login, clear for transfer'
complete -c curl -s G -l get -d 'Use GET instead of POST'
complete -c curl -s g -l globoff -d 'This option switches off the "URL globbing parser"'
complete -c curl -l happy-eyeballs-timeout-ms -d 'Attempt to connect to both IPv4 and IPv6 in parallel'
complete -c curl -l haproxy-protocol -d '(HTTP) Send a HAProxy PROXY protocol v1 header at the beginning of the connection'
complete -c curl -s I -l head -d '(HTTP FTP FILE) Fetch the headers only'
complete -c curl -s H -l header -d '(HTTP) Extra header to include in the request when sending HTTP to a server'
complete -c curl -s h -l help -d 'Usage help'
complete -c curl -l hostpubmd5 -d '(SFTP SCP) Pass a string containing 32 hexadecimal digits'
complete -c curl -l 'http0.9' -d '(HTTP) Tells curl to be fine with HTTP version 0. 9 response.   HTTP/0'
complete -c curl -s 0 -l 'http1.0' -d '(HTTP) Use HTTP version 1'
complete -c curl -l 'http1.1' -d '(HTTP) Use HTTP version 1.1'
complete -c curl -l http2-prior-knowledge -d '(HTTP) Use HTTP/2 immediately (without trying HTTP1)'
complete -c curl -l http2 -d '(HTTP) Use HTTP version 2'
complete -c curl -l ignore-content-length -d '(FTP HTTP) Ignore the Content-Length header'
complete -c curl -s i -l include -d 'Include the HTTP response headers in the output'
complete -c curl -s k -l insecure -d '(TLS)  Allow insecure connections'
complete -c curl -l interface -d 'Perform an operation using a specified interface'
complete -c curl -s 4 -l ipv4 -d 'Use IPv4 only'
complete -c curl -s 6 -l ipv6 -d 'Use IPv6 only'
complete -c curl -s j -l junk-session-cookies -d '(HTTP) Discard all session cookies'
complete -c curl -l keepalive-time -d 'Specify idle time before keepalive is sent'
complete -c curl -l key-type -d '(TLS) Private key file type' -xa 'DER PEM ENG'
complete -c curl -l key -d '(TLS SSH) Private key file name'
complete -c curl -l krb -d '(FTP) Enable Kerberos authentication and use'
complete -c curl -l libcurl -d 'Write C-code equivalent to the invocation to the given file'
complete -c curl -l limit-rate -d 'Limit bandwidth (Examples: 200K, 3m and 1G)'
complete -c curl -s l -l list-only -d '(FTP POP3) (FTP) Use name-only view when listing'
complete -c curl -l local-port -d 'Set a preferred single number or range (FROM-TO) of local ports to use'
complete -c curl -l location-trusted -d '(HTTP) Like -L, --location, but allow sending the name + password'
complete -c curl -s L -l location -d '(HTTP) Follow redirects'
complete -c curl -l login-options -d '(IMAP POP3 SMTP) Specify the login options'
complete -c curl -l mail-auth -d '(SMTP) Specify a single address'
complete -c curl -l mail-from -d '(SMTP) Specify a single address that the given mail should get sent from'
complete -c curl -l mail-rcpt -d '(SMTP) Specify a single address, user name or mailing list name'
complete -c curl -s M -l manual -d 'Manual.  Display the huge help text'
complete -c curl -l max-filesize -d 'Specify the maximum size (in bytes) of a file to download'
complete -c curl -l max-redirs -d '(HTTP) Set maximum number of redirection-followings allowed'
complete -c curl -s m -l max-time -d 'Maximum time in seconds that you allow the whole operation to take'
complete -c curl -l metalink -d 'Process URI as Metalink file'
complete -c curl -l negotiate -d '(HTTP) Enables Negotiate (SPNEGO) authentication'
complete -c curl -l netrc-file -d 'Use this netrc file'
complete -c curl -l netrc-optional -d 'Make netrc optional'
complete -c curl -s n -l netrc -d 'Use ~/.netrc'
complete -c curl -l next -d 'Use a separate operation for the following URL'
complete -c curl -l no-alpn -d '(HTTPS) Disable the ALPN TLS extension'
complete -c curl -s N -l no-buffer -d 'Disable the buffering of the output stream'
complete -c curl -l no-keepalive -d 'Disable use of keepalive messages on the TCP connection'
complete -c curl -l no-npn -d '(HTTPS) Disable NPN TLS extension'
complete -c curl -l no-sessionid -d '(TLS) Disable use of SSL session-ID caching'
complete -c curl -l noproxy -d 'Comma-separated list of hosts which do not use a proxy'
complete -c curl -l ntlm-wb -d '(HTTP) Enable NTLM, but hand over auth to separate ntlmauth binary'
complete -c curl -l ntlm -d '(HTTP) Enable NTLM authentication'
complete -c curl -l oauth2-bearer -d '(IMAP POP3 SMTP) Specify the Bearer Token for OAUTH 2'
complete -c curl -s o -l output -d 'Write output to <file> instead of stdout'
complete -c curl -l pass -d '(SSH TLS) Passphrase for the private key'
complete -c curl -l path-as-is -d 'Do not handle sequences of /../ or /./ in the given URL path'
complete -c curl -l pinnedpubkey -d '(TLS) Use the specified public key file (or hashes)'
complete -c curl -l post301 -d '(HTTP) Respect RFC 7231/6.4'
complete -c curl -l post302 -d '(HTTP) Respect RFC 7231/6.4'
complete -c curl -l post303 -d '(HTTP) Violate RFC 7231/6.4'
complete -c curl -l preproxy -d 'Use the specified SOCKS proxy before connecting to HTTP(S) proxy'
complete -c curl -s '#' -l progress-bar -d 'Display progress as a simple progress bar'
complete -c curl -l proto-default -d 'Use this protocol for any URL missing a scheme name'
complete -c curl -l proto-redir -d 'Limit what protocols it may use on redirect'
# TODO: args
complete -c curl -l proto -d 'Limit what protocols it may use in the transfer'
complete -c curl -l proxy-anyauth -d 'Like --anyauth but for the proxy'
complete -c curl -l proxy-basic -d 'Tells curl to use HTTP Basic authentication when communicating with the given…'
complete -c curl -l proxy-cacert -d 'Same as --cacert but used in HTTPS proxy context'
complete -c curl -l proxy-capath -d 'Same as --capath but used in HTTPS proxy context'
complete -c curl -l proxy-cert-type -d 'Same as --cert-type but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-cert -d 'Same as -E, --cert but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-ciphers -d 'Same as --ciphers but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-crlfile -d 'Same as --crlfile but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-digest -d 'Tells curl to use HTTP Digest authentication when communicating with the give…'
complete -c curl -l proxy-header -d '(HTTP) Extra header to include in the request when sending HTTP to a proxy'
complete -c curl -l proxy-insecure -d 'Same as -k, --insecure but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-key-type -d 'Same as --key-type but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-key -d 'Same as --key but used in HTTPS proxy context'
complete -c curl -l proxy-negotiate -d 'Tells curl to use HTTP Negotiate (SPNEGO) authentication when communicating w…'
complete -c curl -l proxy-ntlm -d 'Tells curl to use HTTP NTLM authentication when communicating with the given …'
complete -c curl -l proxy-pass -d 'Same as --pass but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-pinnedpubkey -d '(TLS) Tells curl to use the specified public key file (or hashes) to verify t…'
complete -c curl -l proxy-service-name -d 'This option allows you to change the service name for proxy negotiation'
complete -c curl -l proxy-ssl-allow-beast -d 'Same as --ssl-allow-beast but used in HTTPS proxy context.   Added in 7. 52'
complete -c curl -l proxy-tls13-ciphers -d '(TLS) Specifies which cipher suites to use in the connection to your HTTPS pr…'
complete -c curl -l proxy-tlsauthtype -d 'Same as --tlsauthtype but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-tlspassword -d 'Same as --tlspassword but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-tlsuser -d 'Same as --tlsuser but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -l proxy-tlsv1 -d 'Same as -1, --tlsv1 but used in HTTPS proxy context.   Added in 7. 52. 0'
complete -c curl -s U -l proxy-user -d 'Specify the user name and password to use for proxy authentication'
complete -c curl -s x -l proxy -d 'Use the specified proxy'
complete -c curl -l 'proxy1.0' -d 'Use the specified HTTP 1.0 proxy'
complete -c curl -s p -l proxytunnel -d 'When an HTTP proxy is used -x, --proxy, this option will cause non-HTTP proto…'
complete -c curl -l pubkey -d '(SFTP SCP) Public key file name'
complete -c curl -s Q -l quote -d '(FTP SFTP)  Send an arbitrary command to the remote FTP or SFTP server'
complete -c curl -l random-file -d 'Specify the path name to file containing what will be considered as random da…'
complete -c curl -s r -l range -d '(HTTP FTP SFTP FILE) Retrieve a byte range (i. e'
complete -c curl -o 500 -d 'specifies the last 500 bytes'
complete -c curl -s 1 -d 'specifies the first and last byte only(*)(HTTP)'
complete -c curl -l raw -d '(HTTP) When used, it disables all internal HTTP decoding of content or transf…'
complete -c curl -s e -l referer -d '(HTTP) Sends the "Referrer Page" information to the HTTP server'
complete -c curl -s J -l remote-header-name -d '(HTTP) This option tells the -O, --remote-name option to use the server-speci…'
complete -c curl -l remote-name-all -d 'This option changes the default action for all given URLs to be dealt with as…'
complete -c curl -s O -l remote-name -d 'Write output to a local file named like the remote file we get'
complete -c curl -s R -l remote-time -d 'When used, this will make curl attempt to figure out the timestamp of the rem…'
complete -c curl -l request-target -d '(HTTP) Tells curl to use an alternative "target" (path) instead of using the …'
complete -c curl -s X -l request -d '(HTTP) Specifies a custom request method to use when communicating with the H…'
complete -c curl -l resolve -d 'Provide a custom address for a specific host and port pair'
complete -c curl -l retry-connrefused -d 'In addition to the other conditions, consider ECONNREFUSED as a transient err…'
complete -c curl -l retry-delay -d 'Make curl sleep this amount of time before each retry when a transfer has fai…'
complete -c curl -l retry-max-time -d 'The retry timer is reset before the first transfer attempt'
complete -c curl -l retry -d 'If a transient error is returned when curl tries to perform a transfer, it wi…'
complete -c curl -l sasl-ir -d 'Enable initial response in SASL authentication.   Added in 7. 31. 0'
complete -c curl -l service-name -d 'This option allows you to change the service name for SPNEGO'
complete -c curl -s S -l show-error -d 'When used with -s, --silent, it makes curl show an error message if it fails'
complete -c curl -s s -l silent -d 'Silent or quiet mode.  Don\'t show progress meter or error messages'
complete -c curl -l socks4 -d 'Use the specified SOCKS4 proxy'
complete -c curl -l socks4a -d 'Use the specified SOCKS4a proxy'
complete -c curl -l socks5-basic -d 'Tells curl to use username/password authentication when connecting to a SOCKS…'
complete -c curl -l socks5-gssapi-nec -d 'As part of the GSS-API negotiation a protection mode is negotiated'
complete -c curl -l socks5-gssapi-service -d 'The default service name for a socks server is rcmd/server-fqdn'
complete -c curl -l socks5-gssapi -d 'Tells curl to use GSS-API authentication when connecting to a SOCKS5 proxy'
complete -c curl -l socks5-hostname -d 'Use the specified SOCKS5 proxy (and let the proxy resolve the host name)'
complete -c curl -l socks5 -d 'Use the specified SOCKS5 proxy - but resolve the host name locally'
complete -c curl -s Y -l speed-limit -d 'If a download is slower than this given speed (in bytes per second) for speed…'
complete -c curl -s y -l speed-time -d 'If a download is slower than speed-limit bytes per second during a speed-time…'
complete -c curl -l ssl-allow-beast -d 'This option tells curl to not work around a security flaw in the SSL3 and TLS…'
complete -c curl -l ssl-no-revoke -d '(Schannel) This option tells curl to disable certificate revocation checks'
complete -c curl -l ssl-reqd -d '(FTP IMAP POP3 SMTP) Require SSL/TLS for the connection'
complete -c curl -l ssl -d '(FTP IMAP POP3 SMTP)  Try to use SSL/TLS for the connection'
complete -c curl -s 2 -l sslv2 -d '(SSL) Forces curl to use SSL version 2 when negotiating with a remote SSL ser…'
complete -c curl -s 3 -l sslv3 -d '(SSL) Forces curl to use SSL version 3 when negotiating with a remote SSL ser…'
complete -c curl -l stderr -d 'Redirect all writes to stderr to the specified file instead'
complete -c curl -l styled-output -d 'Enables the automatic use of bold font styles when writing HTTP headers to th…'
complete -c curl -l suppress-connect-headers -d 'When -p, --proxytunnel is used and a CONNECT request is made don\'t output pro…'
complete -c curl -l tcp-fastopen -d 'Enable use of TCP Fast Open (RFC7413).   Added in 7. 49. 0'
complete -c curl -l tcp-nodelay -d 'Turn on the TCP_NODELAY option'
complete -c curl -s t -l telnet-option -d 'Pass options to the telnet protocol'
complete -c curl -l tftp-blksize -d '(TFTP) Set TFTP BLKSIZE option (must be >512)'
complete -c curl -l tftp-no-options -d '(TFTP) Tells curl not to send TFTP options requests'
complete -c curl -s z -l time-cond -d '(HTTP FTP) Request a file that has been modified later than the given time an…'
complete -c curl -l tls-max -d '(SSL) VERSION defines maximum supported TLS version'
complete -c curl -l tls13-ciphers -d '(TLS) Specifies which cipher suites to use in the connection if it negotiates…'
complete -c curl -l tlsauthtype -d 'Set TLS authentication type'
complete -c curl -l tlspassword -d 'Set password for use with the TLS authentication method'
complete -c curl -l tlsuser -d 'Set username for use with the TLS authentication method'
complete -c curl -l 'tlsv1.0' -d '(TLS) Forces curl to use TLS version 1.0'
complete -c curl -l 'tlsv1.1' -d '(TLS) Forces curl to use TLS version 1.1'
complete -c curl -l 'tlsv1.2' -d '(TLS) Forces curl to use TLS version 1.2'
complete -c curl -l 'tlsv1.3' -d '(TLS) Forces curl to use TLS version 1.3'
complete -c curl -l tlsv1 -d '(SSL) Tells curl to use at least TLS version 1'
complete -c curl -l tr-encoding -d '(HTTP) Request a compressed Transfer-Encoding response using one of the algor…'
complete -c curl -l trace-ascii -d 'Enables a full trace dump of all incoming and outgoing data'
complete -c curl -l trace-time -d 'Prepends a time stamp to each trace or verbose line that curl displays'
complete -c curl -l trace -d 'Enables a full trace dump of all incoming and outgoing data'
complete -c curl -l unix-socket -d '(HTTP) Connect through this Unix domain socket, instead of using the network'
complete -c curl -s T -l upload-file -d 'This transfers the specified local file to the remote URL'
complete -c curl -l url -d 'Specify a URL to fetch'
complete -c curl -s B -l use-ascii -d '(FTP LDAP) Enable ASCII transfer'
complete -c curl -s A -l user-agent -d '(HTTP)  Specify the User-Agent string to send to the HTTP server'
complete -c curl -s u -l user -d 'Specify the user name and password to use for server authentication'
complete -c curl -s v -l verbose -d 'Makes curl verbose during the operation'
complete -c curl -s V -l version -d 'Displays information about curl and the libcurl version it uses'
complete -c curl -s w -l write-out -d 'Make curl display information on stdout after a completed transfer'
complete -c curl -l eprt -l no-eprt -d 'for --disable-eprt'
complete -c curl -l epsv -l no-epsv -d 'for --disable-epsv'
complete -c curl -l max-redir -d 'Set maximum number of redirects'
complete -c curl -l xattr -d 'Store metadata in xattrs (like origin URL)'
