/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.settings;

import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.fibs.geotag.Settings;
import org.fibs.geotag.gui.settings.SettingsPanel;

public class IntegerSettingsPanel
extends SettingsPanel {
    private SpinnerNumberModel spinnerModel;

    public IntegerSettingsPanel(JFrame parent, String title, Settings.SETTING setting, int defaultValue, int minimum, int maximum, int stepSize) {
        this(parent, title, null, true, setting, defaultValue, minimum, maximum, stepSize);
    }

    public IntegerSettingsPanel(JFrame parent, String title, Settings.SETTING enablingSetting, boolean defaultEnabled, Settings.SETTING setting, int defaultValue, int minimum, int maximum, int stepSize) {
        super(parent, title, enablingSetting, defaultEnabled, setting, Integer.toString(defaultValue));
        int value = Settings.get(setting, defaultValue);
        this.spinnerModel = new SpinnerNumberModel(value, minimum, maximum, stepSize);
        JSpinner spinner = new JSpinner(this.spinnerModel);
        this.addEditor(spinner);
    }

    @Override
    public String getValue() {
        return this.spinnerModel.getNumber().toString();
    }
}

