/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.order.Ordered;
import java.util.Map;

public interface PropertySource
extends Iterable<String>,
Ordered {
    public static final String CONTEXT = "context";

    public String getName();

    public Object get(String var1);

    default public PropertyConvention getConvention() {
        return PropertyConvention.JAVA_PROPERTIES;
    }

    public static PropertySource of(String name, Map<String, Object> map) {
        return new MapPropertySource(name, map);
    }

    public static PropertySource of(String name, Map<String, Object> map, final PropertyConvention convention) {
        return new MapPropertySource(name, map){

            @Override
            public PropertyConvention getConvention() {
                return convention;
            }
        };
    }

    public static PropertySource of(String name, Map<String, Object> map, final int priority) {
        return new MapPropertySource(name, map){

            public int getOrder() {
                return priority;
            }
        };
    }

    public static PropertySource of(Map<String, Object> map) {
        return new MapPropertySource("application", map);
    }

    public static enum PropertyConvention {
        ENVIRONMENT_VARIABLE,
        JAVA_PROPERTIES;

    }
}

