/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.WindowTableModel;
import org.gjt.sp.util.StandardUtilities;

public class DockingOptionPane
extends AbstractOptionPane {
    private JComboBox<String> dockingFramework;
    private WindowTableModel windowModel;
    private JCheckBox autoLoadModeLayout;
    private JCheckBox autoSaveModeLayout;
    private JComboBox<String> dockableSetSelection;
    private static final String DOCKING_OPTIONS_PREFIX = "options.docking.";
    public static final String AUTO_LOAD_MODE_LAYOUT_PROP = "options.docking.autoLoadModeLayout";
    private static final String AUTO_LOAD_MODE_LAYOUT_LABEL = "options.docking.autoLoadModeLayout.label";
    public static final String AUTO_SAVE_MODE_LAYOUT_PROP = "options.docking.autoSaveModeLayout";
    private static final String AUTO_SAVE_MODE_LAYOUT_LABEL = "options.docking.autoSaveModeLayout.label";

    public DockingOptionPane() {
        super("docking");
    }

    @Override
    public void _init() {
        this.setLayout(new BorderLayout());
        this.add("North", this.createDockingOptionsPanel());
        this.add("Center", this.createWindowTableScroller());
        this.add("South", this.createDockingFrameworkChooser());
        this.dockableSetSelection.setModel(new DefaultComboBoxModel<String>(this.windowModel.getDockableSets().toArray(StandardUtilities.EMPTY_STRING_ARRAY)));
    }

    @Override
    public void _save() {
        jEdit.setBooleanProperty(AUTO_LOAD_MODE_LAYOUT_PROP, this.autoLoadModeLayout.isSelected());
        jEdit.setBooleanProperty(AUTO_SAVE_MODE_LAYOUT_PROP, this.autoSaveModeLayout.isSelected());
        jEdit.setProperty("view.docking.framework", (String)this.dockingFramework.getSelectedItem());
        this.windowModel.save();
    }

    private JPanel createDockingFrameworkChooser() {
        String[] stringArray = ServiceManager.getServiceNames("org.gjt.sp.jedit.gui.DockingFrameworkProvider");
        this.dockingFramework = new JComboBox<String>(stringArray);
        String string = View.getDockingFrameworkName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            this.dockingFramework.setSelectedIndex(i);
            break;
        }
        this.dockingFramework.setToolTipText(jEdit.getProperty("options.docking.system-change.note"));
        JPanel jPanel = new JPanel();
        jPanel.setToolTipText(jEdit.getProperty("options.docking.system-change.note"));
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel(jEdit.getProperty("options.docking.selectFramework.label")));
        jPanel.add(this.dockingFramework);
        return jPanel;
    }

    private JPanel createDockingOptionsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        boolean bl = jEdit.getBooleanProperty(AUTO_LOAD_MODE_LAYOUT_PROP, false);
        this.autoLoadModeLayout = new JCheckBox(jEdit.getProperty(AUTO_LOAD_MODE_LAYOUT_LABEL), bl);
        jPanel.add(this.autoLoadModeLayout);
        this.autoSaveModeLayout = new JCheckBox(jEdit.getProperty(AUTO_SAVE_MODE_LAYOUT_LABEL), jEdit.getBooleanProperty(AUTO_SAVE_MODE_LAYOUT_PROP, false));
        jPanel.add(this.autoSaveModeLayout);
        this.autoSaveModeLayout.setEnabled(bl);
        this.autoLoadModeLayout.addActionListener(actionEvent -> this.autoSaveModeLayout.setEnabled(this.autoLoadModeLayout.isSelected()));
        Box box = Box.createVerticalBox();
        jPanel.add(box);
        Box box2 = Box.createHorizontalBox();
        box.add(box2);
        box2.add(Box.createHorizontalStrut(6));
        box2.add(new JLabel(jEdit.getProperty("options.docking.selectSet.label")));
        box2.add(Box.createHorizontalStrut(6));
        this.dockableSetSelection = new JComboBox();
        box2.add(this.dockableSetSelection);
        this.dockableSetSelection.addItemListener(itemEvent -> this.windowModel.showSet((String)this.dockableSetSelection.getSelectedItem()));
        box2.add(Box.createHorizontalStrut(6));
        box.add(Box.createVerticalStrut(6));
        return jPanel;
    }

    private JScrollPane createWindowTableScroller() {
        this.windowModel = DockingOptionPane.createWindowModel();
        JTable jTable = new JTable(this.windowModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        DockPositionCellRenderer dockPositionCellRenderer = new DockPositionCellRenderer();
        jTable.setRowHeight(dockPositionCellRenderer.getPreferredSize().height);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(dockPositionCellRenderer);
        tableColumn.setCellEditor(new DefaultCellEditor(new DockPositionCellRenderer()));
        Dimension dimension = jTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 50);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private static WindowTableModel createWindowModel() {
        return new WindowTableModel();
    }

    private static class DockPositionCellRenderer
    extends JComboBox<String>
    implements TableCellRenderer {
        DockPositionCellRenderer() {
            super(new String[]{"floating", "top", "left", "bottom", "right"});
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelectedItem(object);
            return this;
        }
    }
}

