/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.actions.IPrimitiveAction;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractRelationAction
extends AbstractAction
implements IPrimitiveAction,
Destroyable {
    protected transient Collection<IRelation<?>> relations = Collections.emptySet();

    protected static final Collection<IRelation<?>> getRelations(Collection<? extends IPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return Collections.emptySet();
        }
        return new SubclassFilteredCollection(primitives, IRelation.class::isInstance);
    }

    @Override
    public void setPrimitives(Collection<? extends IPrimitive> primitives) {
        this.relations = AbstractRelationAction.getRelations(primitives);
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty());
    }

    protected final boolean canModify() {
        SubclassFilteredCollection<IRelation<?>, Relation> filteredRelations = Utils.filteredCollection(this.relations, Relation.class);
        return OsmUtils.isOsmCollectionEditable(filteredRelations) && filteredRelations.parallelStream().anyMatch(r -> !r.isDeleted());
    }

    protected final boolean canDownload() {
        if (this.relations.isEmpty()) {
            return false;
        }
        OsmData<?, ?, ?, ?> ds = this.relations.iterator().next().getDataSet();
        return !NetworkManager.isOffline(OnlineResource.OSM_API) && ds != null && !ds.isLocked() && DownloadPolicy.BLOCKED != ds.getDownloadPolicy();
    }

    protected void setHelpId(String helpId) {
        this.putValue("help", helpId);
    }

    @Override
    public void destroy() {
        this.relations = null;
    }
}

