/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class Rainbow {
    private static final Rose rose = new Rose();
    private final List<HtmlColorAndStyle> colors = new ArrayList<HtmlColorAndStyle>();
    private final int colorArrowSeparationSpace;

    private Rainbow(int colorArrowSeparationSpace) {
        this.colorArrowSeparationSpace = colorArrowSeparationSpace;
    }

    public String toString() {
        return this.colors.toString();
    }

    public static Rainbow none() {
        return new Rainbow(0);
    }

    public static Rainbow fromColor(HColor arrowColor, HColor arrowHeadColor) {
        if (arrowColor == null) {
            return Rainbow.none();
        }
        return Rainbow.build(new HtmlColorAndStyle(arrowColor, arrowHeadColor));
    }

    public static Rainbow build(ISkinParam skinParam) {
        if (UseStyle.useBetaStyle()) {
            throw new IllegalStateException();
        }
        HColor arrow = rose.getHtmlColor(skinParam, ColorParam.arrow);
        HColor arrowHead = rose.getHtmlColor(skinParam, null, ColorParam.arrowHead, ColorParam.arrow);
        return Rainbow.fromColor(arrow, arrowHead);
    }

    public static Rainbow build(Style style, HColorSet set) {
        HColor color = style.value(PName.LineColor).asColor(set);
        return Rainbow.fromColor(color, null);
    }

    public Rainbow withDefault(Rainbow defaultColor) {
        if (this.size() == 0) {
            return defaultColor;
        }
        return this;
    }

    public static Rainbow build(HtmlColorAndStyle color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Rainbow result = new Rainbow(0);
        result.colors.add(color);
        return result;
    }

    public static Rainbow build(ISkinParam skinParam, String colorString, int colorArrowSeparationSpace) {
        if (colorString == null) {
            return Rainbow.none();
        }
        Rainbow result = new Rainbow(colorArrowSeparationSpace);
        for (String s : colorString.split(";")) {
            result.colors.add(HtmlColorAndStyle.build(skinParam, s));
        }
        return result;
    }

    public boolean isInvisible() {
        for (HtmlColorAndStyle style : this.colors) {
            if (!style.getStyle().isInvisible()) continue;
            return true;
        }
        return false;
    }

    public List<HtmlColorAndStyle> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public HColor getColor() {
        return this.colors.get(0).getArrowColor();
    }

    public int getColorArrowSeparationSpace() {
        return this.colorArrowSeparationSpace;
    }

    public int size() {
        return this.colors.size();
    }
}

