/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.picoweb;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.version.Version;

public class PicoWebServer
implements Runnable {
    private final Socket connect;

    public PicoWebServer(Socket c) {
        this.connect = c;
    }

    public static void main(String[] args) throws IOException {
        PicoWebServer.startServer(8080);
    }

    public static void startServer(int port) throws IOException {
        ServerSocket serverConnect = new ServerSocket(port);
        while (true) {
            PicoWebServer myServer = new PicoWebServer(serverConnect.accept());
            Thread thread = new Thread(myServer);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.connect.getInputStream(), "UTF-8"));
            out = new BufferedOutputStream(this.connect.getOutputStream());
            String first = in.readLine();
            if (first == null) {
                return;
            }
            StringTokenizer parse = new StringTokenizer(first);
            String method = parse.nextToken().toUpperCase();
            if (method.equals("GET")) {
                String path = parse.nextToken();
                if (path.startsWith("/plantuml/png/") && this.sendDiagram((BufferedOutputStream)out, path, "image/png", FileFormat.PNG)) {
                    return;
                }
                if (path.startsWith("/plantuml/svg/") && this.sendDiagram((BufferedOutputStream)out, path, "image/svg+xml", FileFormat.SVG)) {
                    return;
                }
            }
            this.write(out, "HTTP/1.1 302 Found");
            this.write(out, "Location: /plantuml/png/oqbDJyrBuGh8ISmh2VNrKGZ8JCuFJqqAJYqgIotY0aefG5G00000");
            this.write(out, "");
            ((BufferedOutputStream)out).flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
                this.connect.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private boolean sendDiagram(BufferedOutputStream out, String path, String mime, FileFormat format) throws NoPlantumlCompressionException, IOException {
        int x = path.lastIndexOf(47);
        String compressed = path.substring(x + 1);
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoderProtected();
        String source = transcoder.decode(compressed);
        SourceStringReader ssr = new SourceStringReader(source);
        List<BlockUml> blocks = ssr.getBlocks();
        if (blocks.size() > 0) {
            Diagram system = blocks.get(0).getDiagram();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageData imageData = system.exportDiagram(os, 0, new FileFormatOption(format));
            os.close();
            byte[] fileData = os.toByteArray();
            this.write(out, "HTTP/1.1 " + this.httpReturnCode(imageData.getStatus()));
            this.write(out, "Cache-Control: no-cache");
            this.write(out, "Server: PlantUML PicoWebServer " + Version.versionString());
            this.write(out, "Date: " + new Date());
            this.write(out, "Content-type: " + mime);
            this.write(out, "Content-length: " + fileData.length);
            this.write(out, "X-PlantUML-Diagram-Width: " + imageData.getWidth());
            this.write(out, "X-PlantUML-Diagram-Height: " + imageData.getHeight());
            this.write(out, "X-PlantUML-Diagram-Description: " + system.getDescription().getDescription());
            if (system instanceof PSystemError) {
                PSystemError error = (PSystemError)system;
                for (ErrorUml err : error.getErrorsUml()) {
                    this.write(out, "X-PlantUML-Diagram-Error: " + err.getError());
                    this.write(out, "X-PlantUML-Diagram-Error-Line: " + (1 + err.getLineLocation().getPosition()));
                }
            }
            this.write(out, "X-Patreon: Support us on https://plantuml.com/patreon");
            this.write(out, "X-Donate: https://plantuml.com/paypal");
            this.write(out, "X-Quote: " + StringUtils.rot(QuoteUtils.getSomeQuote()));
            this.write(out, "");
            out.flush();
            out.write(fileData);
            out.flush();
            return true;
        }
        return false;
    }

    private String httpReturnCode(int status) {
        if (status == 0 || status == 200) {
            return "200 OK";
        }
        return "" + status + " ERROR";
    }

    private void write(OutputStream os, String s) throws IOException {
        s = s + "\r\n";
        os.write(s.getBytes("UTF-8"));
    }
}

