/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.windowsdot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.plantuml.brotli.BrotliInputStream;

public class WindowsDotArchive {
    public final String readString(InputStream is) throws IOException {
        int len = this.readByte(is);
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)this.readByte(is));
        }
        return sb.toString();
    }

    public final int readNumber(InputStream is) throws IOException {
        int result = this.readByte(is);
        result = result * 256 + this.readByte(is);
        result = result * 256 + this.readByte(is);
        return result;
    }

    private int readByte(InputStream is) throws IOException {
        return is.read();
    }

    private void extract(File dir) throws IOException {
        String name;
        InputStream raw = this.getClass().getResourceAsStream("graphviz.dat");
        BrotliInputStream is = new BrotliInputStream(raw);
        while ((name = this.readString(is)).length() != 0) {
            int size = this.readNumber(is);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(dir, name)));
            for (int i = 0; i < size; ++i) {
                ((OutputStream)fos).write(is.read());
            }
            ((OutputStream)fos).close();
        }
        is.close();
    }

    public File getWindowsExeLite() throws IOException {
        File tmp = new File(System.getProperty("java.io.tmpdir"), "_graphviz");
        tmp.mkdirs();
        this.extract(tmp);
        return new File(tmp, "dot.exe");
    }
}

