/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.codec.video.colorspace.JavaRGBToYUV;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class JavaRGBToYUV
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To YUV";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame = false;

    public JavaRGBToYUV() {
        int NS = -1;
        this.inputFormats = new Format[]{new RGBFormat(null, NS, Format.byteArray, NS, 24, NS, NS, NS, NS, NS, NS, NS), new RGBFormat(null, NS, Format.intArray, NS, 32, 0xFF0000, 65280, 255, 1, NS, NS, NS), new RGBFormat(null, NS, Format.intArray, NS, 32, 255, 65280, 0xFF0000, 1, NS, NS, NS)};
        this.outputFormats = new Format[]{new YUVFormat(2)};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                private final /* synthetic */ JavaRGBToYUV this$0;

                FPC(JavaRGBToYUV this$0) {
                    this.this$0 = this$0;
                }

                public void setFramesBehind(float frames) {
                    if (frames > 0.0f) {
                        JavaRGBToYUV.access$002(this.this$0, true);
                    } else {
                        JavaRGBToYUV.access$002(this.this$0, false);
                    }
                }

                public boolean setMinimalProcessing(boolean minimal) {
                    JavaRGBToYUV.access$002(this.this$0, minimal);
                    return JavaRGBToYUV.access$000(this.this$0);
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }
            }
            this.frameControl = new FPC(this);
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (input instanceof RGBFormat && BasicPlugIn.matches(input, this.inputFormats) != null) {
            RGBFormat rgb = (RGBFormat)input;
            Dimension size = rgb.getSize();
            float frameRate = rgb.getFrameRate();
            int bpp = rgb.getBitsPerPixel();
            int scan = size.width + 1 & 0xFFFFFFFE;
            YUVFormat output = new YUVFormat(size, scan * size.height * 3 / 2, Format.byteArray, frameRate, 2, scan, scan / 2, 0, scan * size.height, scan * size.height * 5 / 4);
            Format[] outputs = new Format[]{output};
            return outputs;
        }
        return new Format[0];
    }

    public Format setInputFormat(Format input) {
        Format ret = super.setInputFormat(input);
        if (this.opened) {
            this.outputFormat = this.getSupportedOutputFormats(ret)[0];
        }
        return ret;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.dropFrame) {
            outBuffer.setFlags(outBuffer.getFlags() | 2);
            return 0;
        }
        Format inF = inBuffer.getFormat();
        if (!(inF instanceof RGBFormat) || inBuffer.getData() == null) {
            return 1;
        }
        Object inData = inBuffer.getData();
        this.validateByteArraySize(outBuffer, ((VideoFormat)this.outputFormat).getMaxDataLength());
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setLength(((VideoFormat)this.outputFormat).getMaxDataLength());
        if (((RGBFormat)inF).getBitsPerPixel() == 24) {
            return this.convert24(inBuffer, outBuffer);
        }
        return this.convertInt(inBuffer, outBuffer);
    }

    protected int convert24(Buffer inBuffer, Buffer outBuffer) {
        RGBFormat rgb = (RGBFormat)inBuffer.getFormat();
        YUVFormat yuv = (YUVFormat)outBuffer.getFormat();
        Dimension size = rgb.getSize();
        byte[] outData = (byte[])outBuffer.getData();
        byte[] inData = (byte[])inBuffer.getData();
        boolean flipped = rgb.getFlipped() == 1;
        int increment = flipped ? -1 : 1;
        int ystride = yuv.getStrideY();
        int uvstride = yuv.getStrideUV();
        int pointerY = yuv.getOffsetY() + ystride * (flipped ? size.height - 1 : 0);
        int pointerU = yuv.getOffsetU() + uvstride * (flipped ? size.height / 2 - 1 : 0);
        int pointerV = yuv.getOffsetV() + uvstride * (flipped ? size.height / 2 - 1 : 0);
        int pRGB = 0;
        int rgbscan = rgb.getLineStride();
        int pixstride = rgb.getPixelStride();
        int rOffset = rgb.getRedMask() - 1;
        int gOffset = rgb.getGreenMask() - 1;
        int bOffset = rgb.getBlueMask() - 1;
        int y = 0;
        while (y < size.height) {
            int x = 0;
            while (x < size.width) {
                int rval = inData[pRGB + rOffset] & 0xFF;
                int gval = inData[pRGB + gOffset] & 0xFF;
                int bval = inData[pRGB + bOffset] & 0xFF;
                int yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                int uval = (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                int vval = (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY] = (byte)(yval & 0xFF);
                rval = inData[pRGB + rOffset + pixstride] & 0xFF;
                gval = inData[pRGB + gOffset + pixstride] & 0xFF;
                bval = inData[pRGB + bOffset + pixstride] & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY + 1] = (byte)(yval & 0xFF);
                rval = inData[pRGB + rOffset + rgbscan] & 0xFF;
                gval = inData[pRGB + gOffset + rgbscan] & 0xFF;
                bval = inData[pRGB + bOffset + rgbscan] & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY + increment * ystride] = (byte)(yval & 0xFF);
                rval = inData[pRGB + rOffset + rgbscan + pixstride] & 0xFF;
                gval = inData[pRGB + gOffset + rgbscan + pixstride] & 0xFF;
                bval = inData[pRGB + bOffset + rgbscan + pixstride] & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                outData[pointerY + increment * ystride + 1] = (byte)(yval & 0xFF);
                outData[pointerU] = (byte)((uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128) >> 2 & 0xFF);
                outData[pointerV] = (byte)((vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128) >> 2 & 0xFF);
                pointerY += 2;
                ++pointerU;
                ++pointerV;
                pRGB += pixstride * 2;
                x += 2;
            }
            pRGB += rgbscan * 2 - size.width * pixstride;
            pointerY += increment * ystride * 2 - size.width;
            pointerU += increment * uvstride - size.width / 2;
            pointerV += increment * uvstride - size.width / 2;
            y += 2;
        }
        return 0;
    }

    protected int convertInt(Buffer inBuffer, Buffer outBuffer) {
        RGBFormat rgb = (RGBFormat)inBuffer.getFormat();
        YUVFormat yuv = (YUVFormat)outBuffer.getFormat();
        Dimension size = rgb.getSize();
        byte[] outData = (byte[])outBuffer.getData();
        int[] inData = (int[])inBuffer.getData();
        boolean flipped = rgb.getFlipped() == 1;
        int increment = flipped ? -1 : 1;
        int ystride = yuv.getStrideY();
        int uvstride = yuv.getStrideUV();
        int pointerY = yuv.getOffsetY() + ystride * (flipped ? size.height - 1 : 0);
        int pointerU = yuv.getOffsetU() + uvstride * (flipped ? size.height / 2 - 1 : 0);
        int pointerV = yuv.getOffsetV() + uvstride * (flipped ? size.height / 2 - 1 : 0);
        int pRGB = 0;
        int rgbscan = rgb.getLineStride();
        int rOffset = 16;
        int gOffset = 8;
        int bOffset = 0;
        if (rgb.getRedMask() == 255) {
            rOffset = 0;
            bOffset = 16;
        }
        int y = 0;
        while (y < size.height) {
            int x = 0;
            while (x < size.width) {
                int rval = inData[pRGB] >> rOffset & 0xFF;
                int gval = inData[pRGB] >> gOffset & 0xFF;
                int bval = inData[pRGB] >> bOffset & 0xFF;
                int yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                int uval = (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                int vval = (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY] = (byte)(yval & 0xFF);
                rval = inData[pRGB + 1] >> rOffset & 0xFF;
                gval = inData[pRGB + 1] >> gOffset & 0xFF;
                bval = inData[pRGB + 1] >> bOffset & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY + 1] = (byte)(yval & 0xFF);
                rval = inData[pRGB + rgbscan] >> rOffset & 0xFF;
                gval = inData[pRGB + rgbscan] >> gOffset & 0xFF;
                bval = inData[pRGB + rgbscan] >> bOffset & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128;
                vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128;
                outData[pointerY + increment * ystride] = (byte)(yval & 0xFF);
                rval = inData[pRGB + rgbscan + 1] >> rOffset & 0xFF;
                gval = inData[pRGB + rgbscan + 1] >> gOffset & 0xFF;
                bval = inData[pRGB + rgbscan + 1] >> bOffset & 0xFF;
                yval = (rval * 257 + gval * 504 + bval * 98) / 1000 + 16;
                outData[pointerY + increment * ystride + 1] = (byte)(yval & 0xFF);
                outData[pointerU] = (byte)((uval += (-rval * 148 - gval * 291 + bval * 439) / 1000 + 128) >> 2 & 0xFF);
                outData[pointerV] = (byte)((vval += (rval * 439 - gval * 368 - bval * 71) / 1000 + 128) >> 2 & 0xFF);
                pointerY += 2;
                ++pointerU;
                ++pointerV;
                pRGB += 2;
                x += 2;
            }
            pRGB += rgbscan * 2 - size.width;
            pointerY += increment * ystride * 2 - size.width;
            pointerU += increment * uvstride - size.width / 2;
            pointerV += increment * uvstride - size.width / 2;
            y += 2;
        }
        return 0;
    }

    public void reset() {
    }

    static /* synthetic */ boolean access$002(JavaRGBToYUV x0, boolean x1) {
        x0.dropFrame = x1;
        return x0.dropFrame;
    }

    static /* synthetic */ boolean access$000(JavaRGBToYUV x0) {
        return x0.dropFrame;
    }
}

