
#ifndef KXMLGUI_EXPORT_H
#define KXMLGUI_EXPORT_H

#ifdef KXMLGUI_STATIC_DEFINE
#  define KXMLGUI_EXPORT
#  define KXMLGUI_NO_EXPORT
#else
#  ifndef KXMLGUI_EXPORT
#    ifdef KF5XmlGui_EXPORTS
        /* We are building this library */
#      define KXMLGUI_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KXMLGUI_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KXMLGUI_NO_EXPORT
#    define KXMLGUI_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KXMLGUI_DECL_DEPRECATED
#  define KXMLGUI_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KXMLGUI_DECL_DEPRECATED_EXPORT
#  define KXMLGUI_DECL_DEPRECATED_EXPORT KXMLGUI_EXPORT KXMLGUI_DECL_DEPRECATED
#endif

#ifndef KXMLGUI_DECL_DEPRECATED_NO_EXPORT
#  define KXMLGUI_DECL_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT KXMLGUI_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KXMLGUI_NO_DEPRECATED
#    define KXMLGUI_NO_DEPRECATED
#  endif
#endif

#define KXMLGUI_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KXMLGUI_NO_DEPRECATED) && !defined(KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KXMLGUI_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KXMLGUI_NO_DEPRECATED_WARNINGS) && !defined(KXMLGUI_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KXMLGUI_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KXMLGUI_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KXMLGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KXMLGUI_NO_DEPRECATED)
#  undef KXMLGUI_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT
#elif defined(KXMLGUI_NO_DEPRECATED_WARNINGS)
#  define KXMLGUI_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT
#else
#  define KXMLGUI_DEPRECATED KXMLGUI_DECL_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_DECL_DEPRECATED_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KXMLGUI_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KXMLGUI_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KXMLGUI_NO_DEPRECATED
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55000
#endif
#ifdef KXMLGUI_NO_DEPRECATED_WARNINGS
#  define KXMLGUI_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KXMLGUI_DEPRECATED_WARNINGS_SINCE
#  ifdef KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE 0x55000
#  endif
#endif

#ifndef KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KXMLGUI_DEPRECATED
#  define KXMLGUI_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KXMLGUI_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KXMLGUI_DEPRECATED_WARNINGS_SINCE >= 0x40000
#  define KXMLGUI_DEPRECATED_VERSION_4_0(text) KXMLGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KXMLGUI_DEPRECATED_VERSION_4_0(text)
#endif

#if KXMLGUI_DEPRECATED_WARNINGS_SINCE >= 0x40100
#  define KXMLGUI_DEPRECATED_VERSION_4_1(text) KXMLGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KXMLGUI_DEPRECATED_VERSION_4_1(text)
#endif

#if KXMLGUI_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KXMLGUI_DEPRECATED_VERSION_5_0(text) KXMLGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KXMLGUI_DEPRECATED_VERSION_5_0(text)
#endif

#if KXMLGUI_DEPRECATED_WARNINGS_SINCE >= 0x54b00
#  define KXMLGUI_DEPRECATED_VERSION_5_75(text) KXMLGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KXMLGUI_DEPRECATED_VERSION_5_75(text)
#endif
#define KXMLGUI_DEPRECATED_VERSION_4(minor, text)      KXMLGUI_DEPRECATED_VERSION_4_##minor(text)
#define KXMLGUI_DEPRECATED_VERSION_5(minor, text)      KXMLGUI_DEPRECATED_VERSION_5_##minor(text)
#define KXMLGUI_DEPRECATED_VERSION(major, minor, text) KXMLGUI_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KXMLGUI_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KXMLGUI_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* KXMLGUI_EXPORT_H */
