/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.jdbc.TablesSelector;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.modules.profiler.api.ActionsSupport;

abstract class SQLFilterPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String QUERIES_CAPTION = messages.getString("SQLFilterPanel_QueriesCaption");
    private static final String FILTER_BUTTON = messages.getString("SQLFilterPanel_FilterButton");
    private static final String COMMANDS_DROPDOWN = messages.getString("SQLFilterPanel_CommandsDropdown");
    private static final String COMMANDS_NOTAVAILABLE = messages.getString("SQLFilterPanel_CommandsNotAvailable");
    private static final String TABLES_DROPDOWN = messages.getString("SQLFilterPanel_TablesDropdown");
    private static final String TABLES_NOTAVAILABLE = messages.getString("SQLFilterPanel_TablesNotAvailable");
    private static final String STATEMENTS_DROPDOWN = messages.getString("SQLFilterPanel_StatementsDropdown");
    private static final String STATEMENT_REGULAR = messages.getString("SQLFilterPanel_StatementRegular");
    private static final String STATEMENT_PREPARED = messages.getString("SQLFilterPanel_StatementPrepared");
    private static final String STATEMENT_CALLABLE = messages.getString("SQLFilterPanel_StatementCallable");
    private static final String FILTER_TOOLTIP = messages.getString("SQLFilterPanel_FilterTooltip");
    private static final String COMMANDS_TOOLTIP = messages.getString("SQLFilterPanel_CommandsTooltip");
    private static final String TABLES_TOOLTIP = messages.getString("SQLFilterPanel_TablesTooltip");
    private static final String STATEMENTS_TOOLTIP = messages.getString("SQLFilterPanel_StatementsTooltip");
    private static final String APPLY_ACTION_KEY = "apply-action-key";
    private boolean initialized = false;
    private JButton applyB;
    private Configuration current = new Configuration();
    private Configuration applied = new Configuration();

    SQLFilterPanel() {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")), BorderFactory.createMatteBorder(6, 3, 6, 3, UIUtils.getProfilerResultsBackground())));
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        InvisibleToolbar invisibleToolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SQLFilterPanel.this.applyB.isEnabled()) {
                            SQLFilterPanel.this.applyB.doClick();
                        }
                    }
                });
            }
        };
        invisibleToolbar.add(Box.createHorizontalStrut(3));
        invisibleToolbar.add(new JLabel(QUERIES_CAPTION));
        invisibleToolbar.add(Box.createHorizontalStrut(3));
        final JTextField jTextField = new JTextField(20){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = super.getPreferredSize().height;
                if (UIUtils.isMetalLookAndFeel()) {
                    dimension.height += 4;
                }
                return dimension;
            }
        };
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.handle();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.handle();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.handle();
            }

            private void handle() {
                ((SQLFilterPanel)SQLFilterPanel.this).current.filter = jTextField.getText().trim().toLowerCase(Locale.ENGLISH);
                SQLFilterPanel.this.changed();
            }
        });
        jTextField.getActionMap().put(APPLY_ACTION_KEY, abstractAction);
        jTextField.getInputMap().put(keyStroke, APPLY_ACTION_KEY);
        invisibleToolbar.add(jTextField);
        invisibleToolbar.add(Box.createHorizontalStrut(10));
        this.applyB = new JButton(FILTER_BUTTON){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SQLFilterPanel.this.apply();
            }
        };
        String string = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke);
        this.applyB.setToolTipText(MessageFormat.format(FILTER_TOOLTIP, string));
        this.applyB.setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        jPanel.add((Component)this.applyB, "Center");
        jPanel.setOpaque(false);
        invisibleToolbar.add(jPanel);
        invisibleToolbar.add(Box.createHorizontalStrut(10));
        ((JToolBar)invisibleToolbar).addSeparator();
        invisibleToolbar.add(Box.createHorizontalStrut(8));
        PopupButton popupButton = new PopupButton(" " + COMMANDS_DROPDOWN + " "){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                ArrayList<String> arrayList = new ArrayList<String>(SQLFilterPanel.this.getCommands());
                if (arrayList.isEmpty()) {
                    JLabel jLabel = new JLabel(COMMANDS_NOTAVAILABLE);
                    jLabel.setBorder(BorderFactory.createEmptyBorder(9, 6, 9, 6));
                    jPopupMenu.add(jLabel);
                } else {
                    Collections.sort(arrayList);
                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.retainAll(arrayList);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, !((SQLFilterPanel)SQLFilterPanel.this).current.commands.contains(string = (String)iterator.next())){

                            @Override
                            protected void fireActionPerformed(ActionEvent actionEvent) {
                                if (!this.isSelected()) {
                                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.add(string);
                                } else {
                                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.remove(string);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SQLFilterPanel.this.apply();
                                    }
                                });
                            }
                        };
                        jPopupMenu.add(jCheckBoxMenuItem);
                    }
                }
            }
        };
        popupButton.setToolTipText(COMMANDS_TOOLTIP);
        popupButton.setPopupAlign(8);
        invisibleToolbar.add(popupButton);
        invisibleToolbar.add(Box.createHorizontalStrut(5));
        PopupButton popupButton2 = new PopupButton(" " + TABLES_DROPDOWN + " "){

            @Override
            protected void displayPopup() {
                HashSet<String> hashSet = new HashSet<String>(SQLFilterPanel.this.getTables());
                if (hashSet.isEmpty()) {
                    super.displayPopup();
                } else {
                    ((SQLFilterPanel)SQLFilterPanel.this).current.tables.retainAll(hashSet);
                    new TablesSelector(hashSet, ((SQLFilterPanel)SQLFilterPanel.this).current.tables){

                        @Override
                        protected void selectionChanged(Collection<String> collection) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.tables.clear();
                            ((SQLFilterPanel)SQLFilterPanel.this).current.tables.addAll(collection);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SQLFilterPanel.this.apply();
                                }
                            });
                        }
                    }.show(this);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                JLabel jLabel = new JLabel(TABLES_NOTAVAILABLE);
                jLabel.setBorder(BorderFactory.createEmptyBorder(9, 6, 9, 6));
                jPopupMenu.add(jLabel);
            }
        };
        popupButton2.setToolTipText(TABLES_TOOLTIP);
        invisibleToolbar.add(popupButton2);
        invisibleToolbar.add(Box.createHorizontalStrut(5));
        PopupButton popupButton3 = new PopupButton(" " + STATEMENTS_DROPDOWN + " "){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(STATEMENT_REGULAR, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(0)){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(0);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(0);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(STATEMENT_PREPARED, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(1)){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(1);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(1);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(STATEMENT_CALLABLE, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(2)){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(2);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(2);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
            }
        };
        popupButton3.setToolTipText(STATEMENTS_TOOLTIP);
        popupButton3.setPopupAlign(2);
        invisibleToolbar.add(popupButton3);
        invisibleToolbar.add(Box.createHorizontalStrut(3));
        this.add((Component)invisibleToolbar, "Center");
        this.initialized = true;
        this.changed();
    }

    private void changed() {
        if (this.initialized) {
            this.applyB.setEnabled(!this.applied.equals(this.current));
        }
    }

    private void apply() {
        this.applyB.setEnabled(false);
        this.applied.set(this.current);
        this.applyFilter();
    }

    abstract Set<String> getCommands();

    abstract Set<String> getTables();

    abstract void applyFilter();

    boolean passes(String string, String string2, String[] stringArray, int n) {
        if (!this.applied.filter.isEmpty() && !string.toLowerCase(Locale.ENGLISH).contains(this.applied.filter)) {
            return false;
        }
        if (!this.applied.commands.isEmpty() && this.applied.commands.contains(string2)) {
            return false;
        }
        if (!this.applied.statements.isEmpty() && this.applied.statements.contains(n)) {
            return false;
        }
        if (this.applied.tables.isEmpty()) {
            return true;
        }
        for (String string3 : stringArray) {
            if (this.applied.tables.contains(string3)) continue;
            return true;
        }
        return false;
    }

    private static class Configuration {
        String filter = "";
        final Set<String> commands = new HashSet<String>();
        final Set<String> tables = new HashSet<String>();
        final Set<Integer> statements = new HashSet<Integer>();

        private Configuration() {
        }

        void set(Configuration configuration) {
            this.filter = configuration.filter;
            this.commands.clear();
            this.commands.addAll(configuration.commands);
            this.tables.clear();
            this.tables.addAll(configuration.tables);
            this.statements.clear();
            this.statements.addAll(configuration.statements);
        }

        public boolean equals(Object object) {
            Configuration configuration = (Configuration)object;
            return this.filter.equals(configuration.filter) && this.commands.equals(configuration.commands) && this.tables.equals(configuration.tables) && this.statements.equals(configuration.statements);
        }
    }
}

