/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TypeMirrorImpl
implements TypeMirror {
    protected final BaseProcessingEnvImpl _env;
    protected final Binding _binding;

    TypeMirrorImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, Binding binding) {
        this._env = baseProcessingEnvImpl;
        this._binding = binding;
    }

    Binding binding() {
        return this._binding;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
        return typeVisitor.visit(this, p);
    }

    @Override
    public TypeKind getKind() {
        switch (this._binding.kind()) {
            case 1: 
            case 2: 
            case 3: 
            case 32: {
                throw new IllegalArgumentException("Invalid binding kind: " + this._binding.kind());
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return new String(this._binding.readableName());
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._binding == null ? 0 : this._binding.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeMirrorImpl)) {
            return false;
        }
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)object;
        return this._binding == typeMirrorImpl._binding;
    }

    public final AnnotationBinding[] getPackedAnnotationBindings() {
        return Factory.getPackedAnnotationBindings(this.getAnnotationBindings());
    }

    protected AnnotationBinding[] getAnnotationBindings() {
        return ((TypeBinding)this._binding).getTypeAnnotations();
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return this._env == null ? Factory.EMPTY_ANNOTATION_MIRRORS : this._env.getFactory().getAnnotationMirrors(this.getPackedAnnotationBindings());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._env == null ? null : (A)this._env.getFactory().getAnnotation(this.getPackedAnnotationBindings(), clazz);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        if (this._env == null) {
            return (Annotation[])Array.newInstance(clazz, 0);
        }
        return this._env.getFactory().getAnnotationsByType(Factory.getUnpackedAnnotationBindings(this.getPackedAnnotationBindings()), clazz);
    }
}

