/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.RubySymbol;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class IRScriptBody
extends IRScope {
    private DynamicScope toplevelScope = null;
    private String fileName;

    public IRScriptBody(IRManager manager, String sourceName, StaticScope staticScope) {
        super(manager, null, null, 0, staticScope);
        this.fileName = sourceName;
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    public DynamicScope getScriptDynamicScope() {
        return this.toplevelScope;
    }

    public void setScriptDynamicScope(DynamicScope tlbScope) {
        this.toplevelScope = tlbScope;
    }

    @Override
    public int getNearestModuleReferencingScopeDepth() {
        return 0;
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.SCRIPT_BODY;
    }

    @Override
    public String toString() {
        return "Script: file: " + this.getFileName() + super.toString();
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFile() {
        return this.fileName;
    }

    @Override
    public String getId() {
        return this.fileName;
    }

    @Override
    public RubySymbol getName() {
        return this.getManager().getRuntime().newSymbol(this.fileName);
    }

    @Override
    public void cleanupAfterExecution() {
        if (this.getClosures().isEmpty()) {
            this.interpreterContext = null;
            this.fullInterpreterContext = null;
            this.localVars = null;
        }
    }
}

