/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.modifiers;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Modifier;
import org.sunflow.core.ParameterList;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.math.OrthoNormalBasis;

public class BumpMappingModifier
implements Modifier {
    private Texture bumpTexture = null;
    private float scale = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String string = parameterList.getString("texture", null);
        if (string != null) {
            this.bumpTexture = sunflowAPI.getTextureCache().getTexture(sunflowAPI.resolveTextureFilename(string), true);
        }
        this.scale = parameterList.getFloat("scale", this.scale);
        return this.bumpTexture != null;
    }

    public void modify(ShadingState shadingState) {
        shadingState.getNormal().set(this.bumpTexture.getBump(shadingState.getUV().x, shadingState.getUV().y, shadingState.getBasis(), this.scale));
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }
}

