/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileUtils {
    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        if (!file.delete()) {
            String string = "Unable to delete directory " + file + ".";
            throw new IOException(string);
        }
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean bl = file.exists();
            if (!file.delete()) {
                if (!bl) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String string = "Unable to delete file: " + file;
                throw new IOException(string);
            }
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectoryOnExit(file);
        }
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                String string = "File " + file + " exists and is not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs() && !file.isDirectory()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static void forceMkdirParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        FileUtils.forceMkdir(file2);
    }

    public static boolean isSymlink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        File file2 = null;
        if (file.getParent() == null) {
            file2 = file;
        } else {
            File file3 = file.getParentFile().getCanonicalFile();
            file2 = new File(file3, file.getName());
        }
        return !file2.getCanonicalFile().equals(file2.getAbsoluteFile());
    }
}

