/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprServletOutputStream
extends AbstractServletOutputStream {
    private static final int SSL_OUTPUT_BUFFER_SIZE = 8192;
    private final AprEndpoint endpoint;
    private final SocketWrapper<Long> wrapper;
    private final long socket;
    private volatile boolean closed = false;
    private final ByteBuffer sslOutputBuffer;

    public AprServletOutputStream(SocketWrapper<Long> socketWrapper, int n, AprEndpoint aprEndpoint) {
        super(n);
        this.endpoint = aprEndpoint;
        this.wrapper = socketWrapper;
        this.socket = socketWrapper.getSocket();
        if (aprEndpoint.isSSLEnabled()) {
            this.sslOutputBuffer = ByteBuffer.allocateDirect(8192);
            this.sslOutputBuffer.position(8192);
        } else {
            this.sslOutputBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWrite(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("apr.closed", new Object[]{this.socket}));
        }
        Lock lock = this.wrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapper.getBlockingStatusWriteLock();
        try {
            lock.lock();
            if (this.wrapper.getBlockingStatus() == bl) {
                int n3 = this.doWriteInternal(byArray, n, n2);
                return n3;
            }
        }
        finally {
            lock.unlock();
        }
        try {
            writeLock.lock();
            this.wrapper.setBlockingStatus(bl);
            if (bl) {
                Socket.timeoutSet(this.socket, this.endpoint.getSoTimeout() * 1000);
            } else {
                Socket.timeoutSet(this.socket, 0L);
            }
            try {
                lock.lock();
                writeLock.unlock();
                int n4 = this.doWriteInternal(byArray, n, n2);
                lock.unlock();
                return n4;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            if (writeLock.isHeldByCurrentThread()) {
                writeLock.unlock();
            }
        }
    }

    private int doWriteInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n2;
        do {
            if (this.endpoint.isSSLEnabled()) {
                if (this.sslOutputBuffer.remaining() == 0) {
                    this.sslOutputBuffer.clear();
                    if (n5 < 8192) {
                        this.sslOutputBuffer.put(byArray, n4, n5);
                    } else {
                        this.sslOutputBuffer.put(byArray, n4, 8192);
                    }
                    this.sslOutputBuffer.flip();
                }
                if ((n3 = Socket.sendb(this.socket, this.sslOutputBuffer, this.sslOutputBuffer.position(), this.sslOutputBuffer.limit())) > 0) {
                    this.sslOutputBuffer.position(this.sslOutputBuffer.position() + n3);
                }
            } else {
                n3 = Socket.send(this.socket, byArray, n4, n5);
            }
            if (Status.APR_STATUS_IS_EAGAIN(-n3)) {
                n3 = 0;
            } else {
                if (-n3 == 70014) {
                    throw new EOFException(sm.getString("apr.clientAbort"));
                }
                if ((OS.IS_WIN32 || OS.IS_WIN64) && -n3 == 730053) {
                    throw new EOFException(sm.getString("apr.clientAbort"));
                }
                if (n3 < 0) {
                    throw new IOException(sm.getString("apr.write.error", new Object[]{-n3, this.socket, this.wrapper}));
                }
            }
            n4 += n3;
        } while (n3 > 0 && (n5 -= n3) > 0);
        if (n5 > 0) {
            this.endpoint.getPoller().add(this.socket, -1, false, true);
        }
        return n2 - n5;
    }

    @Override
    protected void doFlush() throws IOException {
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
    }
}

