/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorHandler
implements ErrorHandler {
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);
    private final List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private final List<SAXParseException> warnings = new ArrayList<SAXParseException>();

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errors.add(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.warnings.add(sAXParseException);
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public void logFindings(Log log, String string) {
        for (SAXParseException sAXParseException : this.getWarnings()) {
            log.warn((Object)sm.getString("xmlErrorHandler.warning", sAXParseException.getMessage(), string));
        }
        for (SAXParseException sAXParseException : this.getErrors()) {
            log.warn((Object)sm.getString("xmlErrorHandler.error", sAXParseException.getMessage(), string));
        }
    }
}

