/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DoubleRange;

public class DownloadOsmFunction
extends GenericFunction
implements Runnable {
    private JDialog _dialog = null;
    private JLabel[] _latLonLabels = null;
    private JProgressBar _progressBar = null;
    private JButton _okButton = null;
    private JFileChooser _fileChooser = null;
    private File _selectedFile = null;
    private boolean _cancelled = false;
    private final NumberFormat FORMAT_TWO_DP = NumberFormat.getNumberInstance();

    public DownloadOsmFunction(App app) {
        super(app);
        this.FORMAT_TWO_DP.setMaximumFractionDigits(2);
        this.FORMAT_TWO_DP.setMinimumFractionDigits(2);
    }

    @Override
    public String getNameKey() {
        return "function.downloadosm";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._fileChooser = new JFileChooser();
            this._fileChooser.setSelectedFile(new File("data.osm"));
        }
        this.initDialog();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.downloadosm.desc")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 3));
        this._latLonLabels = new JLabel[4];
        int n = 0;
        while (n < 4) {
            this._latLonLabels[n] = new JLabel("0");
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < 4) {
            jPanel2.add(new JLabel(" "));
            jPanel2.add(this._latLonLabels[n++]);
            ++n2;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel2);
        this._progressBar = new JProgressBar();
        this._progressBar.setIndeterminate(true);
        jPanel3.add(this._progressBar);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadOsmFunction.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadOsmFunction.this._cancelled = true;
                DownloadOsmFunction.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void initDialog() {
        String[] stringArray = this.expandRange(this._app.getTrackInfo().getTrack().getLatRange());
        String[] stringArray2 = this.expandRange(this._app.getTrackInfo().getTrack().getLonRange());
        this._latLonLabels[0].setText(stringArray[1]);
        this._latLonLabels[1].setText(stringArray2[0]);
        this._latLonLabels[2].setText(stringArray2[1]);
        this._latLonLabels[3].setText(stringArray[0]);
        this._okButton.setEnabled(true);
        this._progressBar.setVisible(false);
        this._cancelled = false;
    }

    private String[] expandRange(DoubleRange doubleRange) {
        double d = (doubleRange.getMaximum() + doubleRange.getMinimum()) / 2.0;
        double d2 = doubleRange.getRange();
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 < 0.02) {
            d4 = d - 0.01;
            d3 = d + 0.01;
        } else {
            d4 = d - d2 * 0.55;
            d3 = d + d2 * 0.55;
        }
        int n = (int)(100.0 * d4);
        int n2 = (int)(100.0 * d3 + 1.0);
        String[] stringArray = new String[]{this.FORMAT_TWO_DP.format((double)n / 100.0), this.FORMAT_TWO_DP.format((double)n2 / 100.0)};
        return stringArray;
    }

    private void finish() {
        if (!this._okButton.isEnabled()) {
            return;
        }
        this._selectedFile = this.selectOsmFile();
        if (this._selectedFile != null) {
            this._okButton.setEnabled(false);
            this._progressBar.setVisible(true);
            new Thread(this).start();
        } else {
            this._dialog.dispose();
        }
    }

    private File selectOsmFile() {
        File file = null;
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._dialog) != 0) continue;
            File file2 = this._fileChooser.getSelectedFile();
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(this._dialog, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    @Override
    public void run() {
        block24: {
            String string = "http://overpass-api.de/api/interpreter?data=(node(" + this._latLonLabels[3].getText() + "," + this._latLonLabels[1].getText() + "," + this._latLonLabels[0].getText() + "," + this._latLonLabels[2].getText() + ");<;);out%20qt;";
            byte[] byArray = new byte[1024];
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            int n = 0;
            try {
                inputStream = new URL(string).openStream();
                fileOutputStream = new FileOutputStream(this._selectedFile);
                while ((n = inputStream.read(byArray)) > -1 && !this._cancelled) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block24;
            }
            catch (IOException iOException) {
                try {
                    this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage());
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._dialog.dispose();
    }
}

