/*
 * Decompiled with CFR 0.152.
 */
package afu.org.checkerframework.checker.formatter;

import afu.org.checkerframework.checker.formatter.qual.ConversionCategory;
import afu.org.checkerframework.checker.formatter.qual.ReturnsFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtil {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @ReturnsFormat
    public static String asFormat(String format2, ConversionCategory ... cc) throws IllegalFormatException {
        ConversionCategory[] fcc = FormatUtil.formatParameterCategories(format2);
        if (fcc.length != cc.length) {
            throw new ExcessiveOrMissingFormatArgumentException(cc.length, fcc.length);
        }
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i] == fcc[i]) continue;
            throw new IllegalFormatConversionCategoryException(cc[i], fcc[i]);
        }
        return format2;
    }

    public static void tryFormatSatisfiability(String format2) throws IllegalFormatException {
        String.format(format2, (Object[])null);
    }

    public static ConversionCategory[] formatParameterCategories(String format2) throws IllegalFormatException {
        FormatUtil.tryFormatSatisfiability(format2);
        int last = -1;
        int lasto = -1;
        int maxindex = -1;
        Conversion[] cs = FormatUtil.parse(format2);
        HashMap<Integer, ConversionCategory> conv = new HashMap<Integer, ConversionCategory>();
        for (Conversion c : cs) {
            int index2 = c.index();
            switch (index2) {
                case -1: {
                    break;
                }
                case 0: {
                    last = ++lasto;
                    break;
                }
                default: {
                    last = index2 - 1;
                }
            }
            maxindex = Math.max(maxindex, last);
            conv.put(last, ConversionCategory.intersect((ConversionCategory)(conv.containsKey(last) ? (ConversionCategory)conv.get(last) : ConversionCategory.UNUSED), (ConversionCategory)c.category()));
        }
        ConversionCategory[] res2 = new ConversionCategory[maxindex + 1];
        for (int i = 0; i <= maxindex; ++i) {
            res2[i] = conv.containsKey(i) ? (ConversionCategory)conv.get(i) : ConversionCategory.UNUSED;
        }
        return res2;
    }

    private static int indexFromFormat(Matcher m) {
        String s = m.group(1);
        int index2 = s != null ? Integer.parseInt(s.substring(0, s.length() - 1)) : (m.group(2) != null && m.group(2).contains(String.valueOf('<')) ? -1 : 0);
        return index2;
    }

    private static char conversionCharFromFormat(Matcher m) {
        String dt2 = m.group(5);
        if (dt2 == null) {
            return m.group(6).charAt(0);
        }
        return dt2.charAt(0);
    }

    private static Conversion[] parse(String format2) {
        ArrayList<Conversion> cs = new ArrayList<Conversion>();
        Matcher m = fsPattern.matcher(format2);
        block3: while (m.find()) {
            char c = FormatUtil.conversionCharFromFormat(m);
            switch (c) {
                case '%': 
                case 'n': {
                    continue block3;
                }
            }
            cs.add(new Conversion(c, FormatUtil.indexFromFormat(m)));
        }
        return cs.toArray(new Conversion[cs.size()]);
    }

    public static class IllegalFormatConversionCategoryException
    extends IllegalFormatConversionException {
        private static final long serialVersionUID = 17000126L;
        private final ConversionCategory expected;
        private final ConversionCategory found;

        public IllegalFormatConversionCategoryException(ConversionCategory expected, ConversionCategory found) {
            super(expected.chars.length() == 0 ? (char)'-' : (char)expected.chars.charAt(0), found.types == null ? Object.class : found.types[0]);
            this.expected = expected;
            this.found = found;
        }

        public ConversionCategory getExpected() {
            return this.expected;
        }

        public ConversionCategory getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected category %s but found %s.", this.expected, this.found);
        }
    }

    public static class ExcessiveOrMissingFormatArgumentException
    extends MissingFormatArgumentException {
        private static final long serialVersionUID = 17000126L;
        private final int expected;
        private final int found;

        public ExcessiveOrMissingFormatArgumentException(int expected, int found) {
            super("-");
            this.expected = expected;
            this.found = found;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected %d arguments but found %d.", this.expected, this.found);
        }
    }

    private static class Conversion {
        private final int index;
        private final ConversionCategory cath;

        public Conversion(char c, int index2) {
            this.index = index2;
            this.cath = ConversionCategory.fromConversionChar((char)c);
        }

        int index() {
            return this.index;
        }

        ConversionCategory category() {
            return this.cath;
        }
    }
}

