/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.jdbc.JDBCJavaNameRenderer;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.jdbc.SQLFilterPanel;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class JDBCTreeTableView
extends JDBCView {
    private Set<String> commands;
    private Set<String> tables;
    private JDBCTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private JPanel bottomPanel;
    private SQLFilterPanel sqlFilter;
    private JdbcResultsSnapshot currentData;
    private boolean searchQueries = true;
    private boolean searchCallerMethods = false;
    private HideableBarRenderer[] renderers;

    public JDBCTreeTableView(Set<ClientUtils.SourceCodeSelection> set, boolean bl) {
        this.initUI();
    }

    void setData(final JdbcResultsSnapshot jdbcResultsSnapshot, Map<Integer, ClientUtils.SourceCodeSelection> map, int n, Collection<Integer> collection, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = jdbcResultsSnapshot.getSelectNames();
        long[] lArray = jdbcResultsSnapshot.getInvocationsPerSelectId();
        long[] lArray2 = jdbcResultsSnapshot.getTimePerSelectId();
        ArrayList<1> arrayList = new ArrayList<1>();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.commands == null) {
            this.commands = new HashSet<String>();
        }
        this.commands.clear();
        if (this.tables == null) {
            this.tables = new HashSet<String>();
        }
        this.tables.clear();
        for (int i = 1; i < stringArray.length; ++i) {
            if (bl3) {
                l = Math.max(l, lArray[i]);
                l2 = Math.min(l2, lArray[i]);
                l3 = Math.max(l3, lArray2[i]);
                l4 = Math.min(l4, lArray2[i]);
            } else {
                l += lArray[i];
                l3 += lArray2[i];
            }
            int n2 = jdbcResultsSnapshot.getTypeForSelectId()[i];
            int n3 = jdbcResultsSnapshot.getCommandTypeForSelectId()[i];
            String string = JDBCTreeTableView.commandString(n3);
            String[] stringArray2 = jdbcResultsSnapshot.getTablesForSelectId()[i];
            this.commands.add(string.toUpperCase(Locale.ENGLISH));
            this.tables.addAll(Arrays.asList(stringArray2));
            if (!this.sqlFilter.passes(stringArray[i], string, stringArray2, n2)) continue;
            final int n4 = i;
            arrayList.add(new SQLQueryNode(stringArray[i], lArray[i], lArray2[i], n2, n3, stringArray2){

                @Override
                PresoObjAllocCCTNode computeChildren() {
                    return jdbcResultsSnapshot.createPresentationCCT(n4, false);
                }
            });
        }
        long l5 = !bl3 ? l3 : Math.max(Math.abs(l3), Math.abs(l4));
        long l6 = !bl3 ? l : Math.max(Math.abs(l), Math.abs(l2));
        this.renderers[0].setMaxValue(l5);
        this.renderers[1].setMaxValue(l6);
        this.renderers[0].setDiffMode(bl3);
        this.renderers[1].setDiffMode(bl3);
        this.treeTableModel.setRoot((TreeNode)PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])arrayList.toArray(new PresoObjAllocCCTNode[0])));
        this.currentData = jdbcResultsSnapshot;
    }

    public void resetData() {
        this.renderers[0].setMaxValue(0L);
        this.renderers[1].setMaxValue(0L);
        this.renderers[0].setDiffMode(false);
        this.renderers[1].setDiffMode(false);
        this.treeTableModel.setRoot((TreeNode)PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])new PresoObjAllocCCTNode[0]));
        if (this.commands != null) {
            this.commands.clear();
        }
        if (this.tables != null) {
            this.tables.clear();
        }
        this.currentData = null;
    }

    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        String string = EXPORT_QUERIES;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, string);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, string);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    HideableBarRenderer.BarDiffMode barDiffMode() {
        return HideableBarRenderer.BarDiffMode.MODE_BAR_DIFF;
    }

    private void initUI() {
        this.treeTableModel = new JDBCTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{0}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return JDBCTreeTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                JDBCTreeTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                JDBCTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                JDBCTreeTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.treeTable.providePopupMenu(true);
        this.installDefaultAction();
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(0);
        this.treeTable.setFitWidthColumn(0);
        this.treeTable.setSortColumn(1);
        this.treeTable.setDefaultSortOrder(1, SortOrder.DESCENDING);
        this.renderers = new HideableBarRenderer[2];
        HideableBarRenderer.BarDiffMode barDiffMode = this.barDiffMode();
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[0].setBarDiffMode(barDiffMode);
        this.renderers[1] = new HideableBarRenderer(new NumberRenderer());
        this.renderers[1].setBarDiffMode(barDiffMode);
        long l = 123456L;
        this.renderers[0].setMaxValue(l);
        this.renderers[1].setMaxValue(l);
        this.treeTable.setTreeCellRenderer(new JDBCJavaNameRenderer());
        this.treeTable.setColumnRenderer(1, this.renderers[0]);
        this.treeTable.setColumnRenderer(2, this.renderers[1]);
        this.treeTable.setDefaultColumnWidth(1, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(2, this.renderers[1].getMaxNoBarWidth());
        LabelRenderer labelRenderer = new LabelRenderer();
        labelRenderer.setHorizontalAlignment(11);
        labelRenderer.setValue("XStatement TypeX", -1);
        this.treeTable.setColumnRenderer(3, labelRenderer);
        this.treeTable.setDefaultSortOrder(3, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(3, labelRenderer.getPreferredSize().width);
        this.treeTable.setColumnVisibility(3, false);
        this.treeTable.setColumnRenderer(4, labelRenderer);
        this.treeTable.setDefaultSortOrder(4, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(4, labelRenderer.getPreferredSize().width);
        this.treeTable.setColumnVisibility(4, false);
        this.treeTable.setColumnRenderer(5, labelRenderer);
        this.treeTable.setDefaultSortOrder(5, SortOrder.ASCENDING);
        this.treeTable.setDefaultColumnWidth(5, labelRenderer.getPreferredSize().width);
        this.treeTable.setColumnVisibility(5, false);
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
        this.sqlFilter = new SQLFilterPanel(){

            @Override
            Set<String> getCommands() {
                if (JDBCTreeTableView.this.commands == null) {
                    JDBCTreeTableView.this.commands = new HashSet();
                }
                return JDBCTreeTableView.this.commands;
            }

            @Override
            Set<String> getTables() {
                if (JDBCTreeTableView.this.tables == null) {
                    JDBCTreeTableView.this.tables = new HashSet();
                }
                return JDBCTreeTableView.this.tables;
            }

            @Override
            void applyFilter() {
                if (JDBCTreeTableView.this.currentData != null) {
                    JDBCTreeTableView.this.setData(JDBCTreeTableView.this.currentData, null, -1, null, false, false, false);
                }
            }
        };
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.add((Component)this.sqlFilter, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    @Override
    protected void addFilterFindPanel(JComponent jComponent) {
        this.bottomPanel.add((Component)jComponent, "South");
    }

    private void setToolTips() {
        this.treeTable.setColumnToolTips(new String[]{NAME_COLUMN_TOOLTIP, TOTAL_TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP, COMMANDS_COLUMN_TOOLTIP, TABLES_COLUMN_TOOLTIP, STATEMENTS_COLUMN_TOOLTIP});
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)entry.getIdentifier();
                return JDBCTreeTableView.isSQL(presoObjAllocCCTNode);
            }
        };
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treeNode;
                CCTNode cCTNode = presoObjAllocCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
                    if (JDBCTreeTableView.this.searchQueries) {
                        return JDBCTreeTableView.this.searchCallerMethods ? 10 : 11;
                    }
                    return JDBCTreeTableView.this.searchCallerMethods ? 100 : 101;
                }
                return JDBCTreeTableView.this.searchCallerMethods ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(JDBCView.SEARCH_QUERIES_SCOPE, JDBCTreeTableView.this.searchQueries){
                    {
                        if (!JDBCTreeTableView.this.searchCallerMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        JDBCTreeTableView.this.searchQueries = !JDBCTreeTableView.this.searchQueries;
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(JDBCView.SEARCH_CALLERS_SCOPE, JDBCTreeTableView.this.searchCallerMethods){
                    {
                        if (!JDBCTreeTableView.this.searchQueries) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        JDBCTreeTableView.this.searchCallerMethods = !JDBCTreeTableView.this.searchCallerMethods;
                    }
                });
            }
        };
        popupButton.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)this.treeTable.getValueForRow(n);
        if (presoObjAllocCCTNode == null || JDBCTreeTableView.isSQL(presoObjAllocCCTNode) || presoObjAllocCCTNode.isFiltered()) {
            return null;
        }
        String[] stringArray = presoObjAllocCCTNode.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(stringArray[0], stringArray[1], stringArray[2]);
    }

    static boolean isSQL(PresoObjAllocCCTNode presoObjAllocCCTNode) {
        return presoObjAllocCCTNode instanceof SQLQueryNode;
    }

    static boolean isSelectable(PresoObjAllocCCTNode presoObjAllocCCTNode) {
        if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
            return false;
        }
        String string = presoObjAllocCCTNode.getMethodClassNameAndSig()[1];
        return string != null && !string.endsWith("[native]");
    }

    abstract class SQLQueryNode
    extends PresoObjAllocCCTNode {
        String htmlName;
        private final int statementType;
        private final int commandType;
        private final String[] tables;

        SQLQueryNode(String string, long l, long l2, int n, int n2, String[] stringArray) {
            super(string, l, l2);
            this.statementType = n;
            this.commandType = n2;
            this.tables = stringArray;
        }

        public CCTNode[] getChildren() {
            if (this.children == null) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = this.computeChildren();
                this.setChildren(presoObjAllocCCTNode == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])presoObjAllocCCTNode.getChildren());
            }
            return this.children;
        }

        public boolean isLeaf() {
            if (this.children == null) {
                return false;
            }
            return super.isLeaf();
        }

        public int getChildCount() {
            if (this.children == null) {
                this.getChildren();
            }
            return super.getChildCount();
        }

        abstract PresoObjAllocCCTNode computeChildren();

        int getStatementType() {
            return this.statementType;
        }

        int getCommandType() {
            return this.commandType;
        }

        String[] getTables() {
            return this.tables;
        }
    }

    private class JDBCTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        JDBCTreeTableModel(TreeNode treeNode) {
            super(treeNode);
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return JDBCView.COLUMN_NAME;
            }
            if (n == 1) {
                return JDBCView.COLUMN_TOTALTIME;
            }
            if (n == 2) {
                return JDBCView.COLUMN_INVOCATIONS;
            }
            if (n == 3) {
                return JDBCView.COLUMN_COMMANDS;
            }
            if (n == 4) {
                return JDBCView.COLUMN_TABLES;
            }
            if (n == 5) {
                return JDBCView.COLUMN_STATEMENTS;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return JTree.class;
            }
            if (n == 1) {
                return Long.class;
            }
            if (n == 2) {
                return Integer.class;
            }
            if (n == 3) {
                return String.class;
            }
            if (n == 4) {
                return String.class;
            }
            if (n == 5) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(TreeNode treeNode, int n) {
            PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treeNode;
            if (n == 0) {
                return presoObjAllocCCTNode;
            }
            if (n == 1) {
                return presoObjAllocCCTNode.totalObjSize;
            }
            if (n == 2) {
                return presoObjAllocCCTNode.nCalls;
            }
            if (n == 3) {
                if (presoObjAllocCCTNode instanceof SQLQueryNode) {
                    return JDBCView.commandString(((SQLQueryNode)presoObjAllocCCTNode).getCommandType());
                }
                return "-";
            }
            if (n == 4) {
                if (presoObjAllocCCTNode instanceof SQLQueryNode) {
                    return this.formatTables(((SQLQueryNode)presoObjAllocCCTNode).getTables());
                }
                return "-";
            }
            if (n == 5) {
                if (presoObjAllocCCTNode instanceof SQLQueryNode) {
                    switch (((SQLQueryNode)presoObjAllocCCTNode).getStatementType()) {
                        case 1: {
                            return JDBCView.STATEMENT_PREPARED;
                        }
                        case 2: {
                            return JDBCView.STATEMENT_CALLABLE;
                        }
                    }
                    return JDBCView.STATEMENT_REGULAR;
                }
                return "-";
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, TreeNode treeNode, int n) {
        }

        @Override
        public boolean isCellEditable(TreeNode treeNode, int n) {
            return false;
        }

        private String formatTables(String[] stringArray) {
            int n = stringArray.length - 1;
            if (n == -1) {
                return "-";
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (true) {
                stringBuilder.append(stringArray[n2]);
                if (n2 == n) {
                    return stringBuilder.toString();
                }
                stringBuilder.append(", ");
                ++n2;
            }
        }
    }
}

