/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.gui.messages.ReplaceListChangedEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.ReplaceList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000eH\u0082\u0002\u00a2\u0006\u0002\u0010\u0010J8\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter;", "", "()V", "daten", "Lmediathek/config/Daten;", "inFactory", "Ljavax/xml/stream/XMLInputFactory;", "get", "", "parser", "Ljavax/xml/stream/XMLStreamReader;", "xmlElem", "", "xmlNames", "", "strRet", "(Ljavax/xml/stream/XMLStreamReader;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Z", "importAboBlacklist", "Lorg/apache/commons/lang3/tuple/ImmutableTriple;", "", "datei", "importAbo", "importBlacklist", "importReplaceList", "importAboEntry", "importBlacklistEntry", "Companion", "MediathekView"})
public final class OldConfigFileImporter {
    private final Daten daten;
    private final XMLInputFactory inFactory;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ImmutableTriple<Integer, Integer, Integer> importAboBlacklist(@NotNull String datei, boolean importAbo, boolean importBlacklist, boolean importReplaceList) throws IOException, XMLStreamException {
        Intrinsics.checkNotNullParameter(datei, "datei");
        int foundAbos = 0;
        int foundBlacklistEntries = 0;
        int foundReplaceListEntries = 0;
        XMLStreamReader parser = null;
        try {
            Closeable closeable = new FileInputStream(datei);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl3 = false;
                Closeable closeable2 = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    InputStreamReader isr = (InputStreamReader)closeable2;
                    boolean bl6 = false;
                    parser = this.inFactory.createXMLStreamReader(isr);
                    while (true) {
                        int n;
                        XMLStreamReader xMLStreamReader = parser;
                        Intrinsics.checkNotNull(xMLStreamReader);
                        if (!xMLStreamReader.hasNext()) break;
                        XMLStreamReader xMLStreamReader2 = parser;
                        Intrinsics.checkNotNull(xMLStreamReader2);
                        int event = xMLStreamReader2.next();
                        if (event != 1) continue;
                        if (importAbo) {
                            XMLStreamReader xMLStreamReader3 = parser;
                            Intrinsics.checkNotNull(xMLStreamReader3);
                            if (Intrinsics.areEqual(xMLStreamReader3.getLocalName(), "Abonnement")) {
                                XMLStreamReader xMLStreamReader4 = parser;
                                Intrinsics.checkNotNull(xMLStreamReader4);
                                if (!this.importAboEntry(xMLStreamReader4)) continue;
                                n = foundAbos;
                                foundAbos = n + 1;
                                continue;
                            }
                        }
                        if (importBlacklist) {
                            XMLStreamReader xMLStreamReader5 = parser;
                            Intrinsics.checkNotNull(xMLStreamReader5);
                            if (Intrinsics.areEqual(xMLStreamReader5.getLocalName(), "Blacklist")) {
                                XMLStreamReader xMLStreamReader6 = parser;
                                Intrinsics.checkNotNull(xMLStreamReader6);
                                if (!this.importBlacklistEntry(xMLStreamReader6)) continue;
                                n = foundBlacklistEntries;
                                foundBlacklistEntries = n + 1;
                                continue;
                            }
                        }
                        if (!importReplaceList) continue;
                        XMLStreamReader xMLStreamReader7 = parser;
                        Intrinsics.checkNotNull(xMLStreamReader7);
                        if (!Intrinsics.areEqual(xMLStreamReader7.getLocalName(), "Ersetzungstabelle")) continue;
                        XMLStreamReader xMLStreamReader8 = parser;
                        Intrinsics.checkNotNull(xMLStreamReader8);
                        if (!this.importReplaceList(xMLStreamReader8)) continue;
                        n = foundReplaceListEntries;
                        foundReplaceListEntries = n + 1;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        finally {
            if (parser != null) {
                try {
                    XMLStreamReader xMLStreamReader = parser;
                    Intrinsics.checkNotNull(xMLStreamReader);
                    xMLStreamReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        if (foundAbos > 0) {
            this.daten.getListeAbo().aenderungMelden();
        }
        if (foundBlacklistEntries > 0) {
            this.daten.getListeBlacklist().filterListAndNotifyListeners();
        }
        if (foundReplaceListEntries > 0) {
            MessageBus.getMessageBus().publishAsync(new ReplaceListChangedEvent());
        }
        return new ImmutableTriple<Integer, Integer, Integer>(foundAbos, foundBlacklistEntries, foundReplaceListEntries);
    }

    private final boolean importAboEntry(XMLStreamReader parser) {
        boolean bl;
        try {
            DatenAbo datenAbo = new DatenAbo();
            datenAbo.readFromConfig(parser);
            this.daten.getListeAbo().addAbo(datenAbo);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Error importing abo entry");
            bl = false;
        }
        return bl;
    }

    private final boolean importBlacklistEntry(XMLStreamReader parser) {
        boolean bl;
        ListeBlacklist blacklist = this.daten.getListeBlacklist();
        BlacklistRule blacklistRule = new BlacklistRule();
        Intrinsics.checkNotNullExpressionValue(BlacklistRule.XML_NAMES, "BlacklistRule.XML_NAMES");
        Intrinsics.checkNotNullExpressionValue(blacklistRule.arr, "blacklistRule.arr");
        boolean success = this.get(parser, "Blacklist", BlacklistRule.XML_NAMES, blacklistRule.arr);
        if (success) {
            blacklist.addWithoutNotification(blacklistRule);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean importReplaceList(XMLStreamReader parser) {
        boolean bl;
        String[] sa = new String[2];
        Intrinsics.checkNotNullExpressionValue(ReplaceList.COLUMN_NAMES, "ReplaceList.COLUMN_NAMES");
        boolean success = this.get(parser, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa);
        if (success) {
            ReplaceList.list.add(sa);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean maxElem = strRet.length;
        boolean bl = false;
        boolean bl2 = maxElem;
        while (bl < bl2) {
            void i;
            if (strRet[i] == null) {
                strRet[i] = "";
            }
            ++i;
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !Intrinsics.areEqual(parser.getLocalName(), xmlElem))) {
                if (event != 1) continue;
                bl2 = false;
                boolean bl3 = maxElem;
                while (bl2 < bl3) {
                    void i;
                    if (Intrinsics.areEqual(parser.getLocalName(), xmlNames[i])) {
                        strRet[i] = parser.getElementText();
                        continue block3;
                    }
                    ++i;
                }
            }
            bl = true;
        }
        catch (Exception ex) {
            logger.error("get", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    public OldConfigFileImporter() {
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
        this.daten = daten;
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue(xMLInputFactory, "XMLInputFactory.newInstance()");
        this.inFactory = xMLInputFactory;
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

