"use strict";

var SINGLE_QUOTE = '\''.charCodeAt(0);
var DOUBLE_QUOTE = '"'.charCodeAt(0);
var BACKSLASH = '\\'.charCodeAt(0);
var SLASH = '/'.charCodeAt(0);
var NEWLINE = '\n'.charCodeAt(0);
var SPACE = ' '.charCodeAt(0);
var FEED = '\f'.charCodeAt(0);
var TAB = '\t'.charCodeAt(0);
var CR = '\r'.charCodeAt(0);
var OPEN_SQUARE = '['.charCodeAt(0);
var CLOSE_SQUARE = ']'.charCodeAt(0);
var OPEN_PARENTHESES = '('.charCodeAt(0);
var CLOSE_PARENTHESES = ')'.charCodeAt(0);
var OPEN_CURLY = '{'.charCodeAt(0);
var CLOSE_CURLY = '}'.charCodeAt(0);
var SEMICOLON = ';'.charCodeAt(0);
var ASTERISK = '*'.charCodeAt(0);
var COLON = ':'.charCodeAt(0);
var AT = '@'.charCodeAt(0); // SCSS PATCH {

var COMMA = ','.charCodeAt(0);
var HASH = '#'.charCodeAt(0); // } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f{}()'"\\;/[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f(){}:;@!'"\\\][#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\/("'\n]/;
var RE_HEX_ESCAPE = /[a-f0-9]/i;
var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH
// SCSS PATCH function name was changed

module.exports = function scssTokenize(input, options) {
  if (options === void 0) {
    options = {};
  }

  var css = input.css.valueOf();
  var ignore = options.ignoreErrors;
  var code, next, quote, lines, last, content, escape, nextLine, nextOffset, escaped, prev, n, currentToken;
  var brackets; // SCSS PATCH

  var length = css.length;
  var offset = -1;
  var line = 1;
  var pos = 0;
  var buffer = [];
  var returned = [];

  function unclosed(what) {
    throw input.error('Unclosed ' + what, line, pos - offset);
  }

  function endOfFile() {
    return returned.length === 0 && pos >= length;
  } // SCSS PATCH {


  function interpolation() {
    var deep = 1;
    var stringQuote = false;
    var stringEscaped = false;

    while (deep > 0) {
      next += 1;
      if (css.length <= next) unclosed('interpolation');
      code = css.charCodeAt(next);
      n = css.charCodeAt(next + 1);

      if (stringQuote) {
        if (!stringEscaped && code === stringQuote) {
          stringQuote = false;
          stringEscaped = false;
        } else if (code === BACKSLASH) {
          stringEscaped = !escaped;
        } else if (stringEscaped) {
          stringEscaped = false;
        }
      } else if (code === SINGLE_QUOTE || code === DOUBLE_QUOTE) {
        stringQuote = code;
      } else if (code === CLOSE_CURLY) {
        deep -= 1;
      } else if (code === HASH && n === OPEN_CURLY) {
        deep += 1;
      }
    }
  } // } SCSS PATCH


  function nextToken() {
    if (returned.length) return returned.pop();
    if (pos >= length) return;
    code = css.charCodeAt(pos);

    if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
      offset = pos;
      line += 1;
    }

    switch (code) {
      case NEWLINE:
      case SPACE:
      case TAB:
      case CR:
      case FEED:
        next = pos;

        do {
          next += 1;
          code = css.charCodeAt(next);

          if (code === NEWLINE) {
            offset = next;
            line += 1;
          }
        } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

        currentToken = ['space', css.slice(pos, next)];
        pos = next - 1;
        break;

      case OPEN_SQUARE:
        currentToken = ['[', '[', line, pos - offset];
        break;

      case CLOSE_SQUARE:
        currentToken = [']', ']', line, pos - offset];
        break;

      case OPEN_CURLY:
        currentToken = ['{', '{', line, pos - offset];
        break;

      case CLOSE_CURLY:
        currentToken = ['}', '}', line, pos - offset];
        break;
      // SCSS PATCH {

      case COMMA:
        currentToken = ['word', ',', line, pos - offset, line, pos - offset + 1];
        break;
      // } SCSS PATCH

      case COLON:
        currentToken = [':', ':', line, pos - offset];
        break;

      case SEMICOLON:
        currentToken = [';', ';', line, pos - offset];
        break;

      case OPEN_PARENTHESES:
        prev = buffer.length ? buffer.pop()[1] : '';
        n = css.charCodeAt(pos + 1); // SCSS PATCH {

        if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE) {
          brackets = 1;
          escaped = false;
          next = pos + 1;

          while (next <= css.length - 1) {
            n = css.charCodeAt(next);

            if (n === BACKSLASH) {
              escaped = !escaped;
            } else if (n === OPEN_PARENTHESES) {
              brackets += 1;
            } else if (n === CLOSE_PARENTHESES) {
              brackets -= 1;
              if (brackets === 0) break;
            }

            next += 1;
          }

          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['brackets', content, line, pos - offset, nextLine, next - nextOffset];
          offset = nextOffset;
          line = nextLine;
          pos = next; // } SCSS PATCH
        } else {
          next = css.indexOf(')', pos + 1);
          content = css.slice(pos, next + 1);

          if (next === -1 || RE_BAD_BRACKET.test(content)) {
            currentToken = ['(', '(', line, pos - offset];
          } else {
            currentToken = ['brackets', content, line, pos - offset, line, next - offset];
            pos = next;
          }
        }

        break;

      case CLOSE_PARENTHESES:
        currentToken = [')', ')', line, pos - offset];
        break;

      case SINGLE_QUOTE:
      case DOUBLE_QUOTE:
        // SCSS PATCH {
        quote = code;
        next = pos;
        escaped = false;

        while (next < length) {
          next++;
          if (next === length) unclosed('string');
          code = css.charCodeAt(next);
          n = css.charCodeAt(next + 1);

          if (!escaped && code === quote) {
            break;
          } else if (code === BACKSLASH) {
            escaped = !escaped;
          } else if (escaped) {
            escaped = false;
          } else if (code === HASH && n === OPEN_CURLY) {
            interpolation();
          }
        } // } SCSS PATCH


        content = css.slice(pos, next + 1);
        lines = content.split('\n');
        last = lines.length - 1;

        if (last > 0) {
          nextLine = line + last;
          nextOffset = next - lines[last].length;
        } else {
          nextLine = line;
          nextOffset = offset;
        }

        currentToken = ['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset];
        offset = nextOffset;
        line = nextLine;
        pos = next;
        break;

      case AT:
        RE_AT_END.lastIndex = pos + 1;
        RE_AT_END.test(css);

        if (RE_AT_END.lastIndex === 0) {
          next = css.length - 1;
        } else {
          next = RE_AT_END.lastIndex - 2;
        }

        currentToken = ['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];
        pos = next;
        break;

      case BACKSLASH:
        next = pos;
        escape = true;

        while (css.charCodeAt(next + 1) === BACKSLASH) {
          next += 1;
          escape = !escape;
        }

        code = css.charCodeAt(next + 1);

        if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
          next += 1;

          if (RE_HEX_ESCAPE.test(css.charAt(next))) {
            while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
              next += 1;
            }

            if (css.charCodeAt(next + 1) === SPACE) {
              next += 1;
            }
          }
        }

        currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];
        pos = next;
        break;

      default:
        // SCSS PATCH {
        n = css.charCodeAt(pos + 1);

        if (code === HASH && n === OPEN_CURLY) {
          next = pos;
          interpolation();
          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['word', content, line, pos - offset, nextLine, next - nextOffset];
          offset = nextOffset;
          line = nextLine;
          pos = next;
        } else if (code === SLASH && n === ASTERISK) {
          // } SCSS PATCH
          next = css.indexOf('*/', pos + 2) + 1;

          if (next === 0) {
            if (ignore) {
              next = css.length;
            } else {
              unclosed('comment');
            }
          }

          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['comment', content, line, pos - offset, nextLine, next - nextOffset];
          offset = nextOffset;
          line = nextLine;
          pos = next; // SCSS PATCH {
        } else if (code === SLASH && n === SLASH) {
          RE_NEW_LINE.lastIndex = pos + 1;
          RE_NEW_LINE.test(css);

          if (RE_NEW_LINE.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_NEW_LINE.lastIndex - 2;
          }

          content = css.slice(pos, next + 1);
          currentToken = ['comment', content, line, pos - offset, line, next - offset, 'inline'];
          pos = next; // } SCSS PATCH
        } else {
          RE_WORD_END.lastIndex = pos + 1;
          RE_WORD_END.test(css);

          if (RE_WORD_END.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_WORD_END.lastIndex - 2;
          }

          currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];
          buffer.push(currentToken);
          pos = next;
        }

        break;
    }

    pos++;
    return currentToken;
  }

  function back(token) {
    returned.push(token);
  }

  return {
    back: back,
    nextToken: nextToken,
    endOfFile: endOfFile
  };
};
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNjc3MtdG9rZW5pemUuZXM2Il0sIm5hbWVzIjpbIlNJTkdMRV9RVU9URSIsImNoYXJDb2RlQXQiLCJET1VCTEVfUVVPVEUiLCJCQUNLU0xBU0giLCJTTEFTSCIsIk5FV0xJTkUiLCJTUEFDRSIsIkZFRUQiLCJUQUIiLCJDUiIsIk9QRU5fU1FVQVJFIiwiQ0xPU0VfU1FVQVJFIiwiT1BFTl9QQVJFTlRIRVNFUyIsIkNMT1NFX1BBUkVOVEhFU0VTIiwiT1BFTl9DVVJMWSIsIkNMT1NFX0NVUkxZIiwiU0VNSUNPTE9OIiwiQVNURVJJU0siLCJDT0xPTiIsIkFUIiwiQ09NTUEiLCJIQVNIIiwiUkVfQVRfRU5EIiwiUkVfV09SRF9FTkQiLCJSRV9CQURfQlJBQ0tFVCIsIlJFX0hFWF9FU0NBUEUiLCJSRV9ORVdfTElORSIsIm1vZHVsZSIsImV4cG9ydHMiLCJzY3NzVG9rZW5pemUiLCJpbnB1dCIsIm9wdGlvbnMiLCJjc3MiLCJ2YWx1ZU9mIiwiaWdub3JlIiwiaWdub3JlRXJyb3JzIiwiY29kZSIsIm5leHQiLCJxdW90ZSIsImxpbmVzIiwibGFzdCIsImNvbnRlbnQiLCJlc2NhcGUiLCJuZXh0TGluZSIsIm5leHRPZmZzZXQiLCJlc2NhcGVkIiwicHJldiIsIm4iLCJjdXJyZW50VG9rZW4iLCJicmFja2V0cyIsImxlbmd0aCIsIm9mZnNldCIsImxpbmUiLCJwb3MiLCJidWZmZXIiLCJyZXR1cm5lZCIsInVuY2xvc2VkIiwid2hhdCIsImVycm9yIiwiZW5kT2ZGaWxlIiwiaW50ZXJwb2xhdGlvbiIsImRlZXAiLCJzdHJpbmdRdW90ZSIsInN0cmluZ0VzY2FwZWQiLCJuZXh0VG9rZW4iLCJwb3AiLCJzbGljZSIsInNwbGl0IiwiaW5kZXhPZiIsInRlc3QiLCJsYXN0SW5kZXgiLCJjaGFyQXQiLCJwdXNoIiwiYmFjayIsInRva2VuIl0sIm1hcHBpbmdzIjoiOztBQUFBLElBQU1BLFlBQVksR0FBRyxLQUFLQyxVQUFMLENBQWdCLENBQWhCLENBQXJCO0FBQ0EsSUFBTUMsWUFBWSxHQUFHLElBQUlELFVBQUosQ0FBZSxDQUFmLENBQXJCO0FBQ0EsSUFBTUUsU0FBUyxHQUFHLEtBQUtGLFVBQUwsQ0FBZ0IsQ0FBaEIsQ0FBbEI7QUFDQSxJQUFNRyxLQUFLLEdBQUcsSUFBSUgsVUFBSixDQUFlLENBQWYsQ0FBZDtBQUNBLElBQU1JLE9BQU8sR0FBRyxLQUFLSixVQUFMLENBQWdCLENBQWhCLENBQWhCO0FBQ0EsSUFBTUssS0FBSyxHQUFHLElBQUlMLFVBQUosQ0FBZSxDQUFmLENBQWQ7QUFDQSxJQUFNTSxJQUFJLEdBQUcsS0FBS04sVUFBTCxDQUFnQixDQUFoQixDQUFiO0FBQ0EsSUFBTU8sR0FBRyxHQUFHLEtBQUtQLFVBQUwsQ0FBZ0IsQ0FBaEIsQ0FBWjtBQUNBLElBQU1RLEVBQUUsR0FBRyxLQUFLUixVQUFMLENBQWdCLENBQWhCLENBQVg7QUFDQSxJQUFNUyxXQUFXLEdBQUcsSUFBSVQsVUFBSixDQUFlLENBQWYsQ0FBcEI7QUFDQSxJQUFNVSxZQUFZLEdBQUcsSUFBSVYsVUFBSixDQUFlLENBQWYsQ0FBckI7QUFDQSxJQUFNVyxnQkFBZ0IsR0FBRyxJQUFJWCxVQUFKLENBQWUsQ0FBZixDQUF6QjtBQUNBLElBQU1ZLGlCQUFpQixHQUFHLElBQUlaLFVBQUosQ0FBZSxDQUFmLENBQTFCO0FBQ0EsSUFBTWEsVUFBVSxHQUFHLElBQUliLFVBQUosQ0FBZSxDQUFmLENBQW5CO0FBQ0EsSUFBTWMsV0FBVyxHQUFHLElBQUlkLFVBQUosQ0FBZSxDQUFmLENBQXBCO0FBQ0EsSUFBTWUsU0FBUyxHQUFHLElBQUlmLFVBQUosQ0FBZSxDQUFmLENBQWxCO0FBQ0EsSUFBTWdCLFFBQVEsR0FBRyxJQUFJaEIsVUFBSixDQUFlLENBQWYsQ0FBakI7QUFDQSxJQUFNaUIsS0FBSyxHQUFHLElBQUlqQixVQUFKLENBQWUsQ0FBZixDQUFkO0FBQ0EsSUFBTWtCLEVBQUUsR0FBRyxJQUFJbEIsVUFBSixDQUFlLENBQWYsQ0FBWCxDLENBRUE7O0FBQ0EsSUFBTW1CLEtBQUssR0FBRyxJQUFJbkIsVUFBSixDQUFlLENBQWYsQ0FBZDtBQUNBLElBQU1vQixJQUFJLEdBQUcsSUFBSXBCLFVBQUosQ0FBZSxDQUFmLENBQWIsQyxDQUNBOztBQUVBLElBQU1xQixTQUFTLEdBQUcsNEJBQWxCO0FBQ0EsSUFBTUMsV0FBVyxHQUFHLHVDQUFwQjtBQUNBLElBQU1DLGNBQWMsR0FBRyxhQUF2QjtBQUNBLElBQU1DLGFBQWEsR0FBRyxXQUF0QjtBQUVBLElBQU1DLFdBQVcsR0FBRyxXQUFwQixDLENBQWdDO0FBRWhDOztBQUNBQyxNQUFNLENBQUNDLE9BQVAsR0FBaUIsU0FBU0MsWUFBVCxDQUF1QkMsS0FBdkIsRUFBOEJDLE9BQTlCLEVBQTRDO0FBQUEsTUFBZEEsT0FBYztBQUFkQSxJQUFBQSxPQUFjLEdBQUosRUFBSTtBQUFBOztBQUMzRCxNQUFJQyxHQUFHLEdBQUdGLEtBQUssQ0FBQ0UsR0FBTixDQUFVQyxPQUFWLEVBQVY7QUFDQSxNQUFJQyxNQUFNLEdBQUdILE9BQU8sQ0FBQ0ksWUFBckI7QUFFQSxNQUFJQyxJQUFKLEVBQVVDLElBQVYsRUFBZ0JDLEtBQWhCLEVBQXVCQyxLQUF2QixFQUE4QkMsSUFBOUIsRUFBb0NDLE9BQXBDLEVBQTZDQyxNQUE3QyxFQUNFQyxRQURGLEVBQ1lDLFVBRFosRUFDd0JDLE9BRHhCLEVBQ2lDQyxJQURqQyxFQUN1Q0MsQ0FEdkMsRUFDMENDLFlBRDFDO0FBR0EsTUFBSUMsUUFBSixDQVAyRCxDQU85Qzs7QUFFYixNQUFJQyxNQUFNLEdBQUdsQixHQUFHLENBQUNrQixNQUFqQjtBQUNBLE1BQUlDLE1BQU0sR0FBRyxDQUFDLENBQWQ7QUFDQSxNQUFJQyxJQUFJLEdBQUcsQ0FBWDtBQUNBLE1BQUlDLEdBQUcsR0FBRyxDQUFWO0FBQ0EsTUFBSUMsTUFBTSxHQUFHLEVBQWI7QUFDQSxNQUFJQyxRQUFRLEdBQUcsRUFBZjs7QUFFQSxXQUFTQyxRQUFULENBQW1CQyxJQUFuQixFQUF5QjtBQUN2QixVQUFNM0IsS0FBSyxDQUFDNEIsS0FBTixDQUFZLGNBQWNELElBQTFCLEVBQWdDTCxJQUFoQyxFQUFzQ0MsR0FBRyxHQUFHRixNQUE1QyxDQUFOO0FBQ0Q7O0FBRUQsV0FBU1EsU0FBVCxHQUFzQjtBQUNwQixXQUFPSixRQUFRLENBQUNMLE1BQVQsS0FBb0IsQ0FBcEIsSUFBeUJHLEdBQUcsSUFBSUgsTUFBdkM7QUFDRCxHQXRCMEQsQ0F3QjNEOzs7QUFDQSxXQUFTVSxhQUFULEdBQTBCO0FBQ3hCLFFBQUlDLElBQUksR0FBRyxDQUFYO0FBQ0EsUUFBSUMsV0FBVyxHQUFHLEtBQWxCO0FBQ0EsUUFBSUMsYUFBYSxHQUFHLEtBQXBCOztBQUNBLFdBQU9GLElBQUksR0FBRyxDQUFkLEVBQWlCO0FBQ2Z4QixNQUFBQSxJQUFJLElBQUksQ0FBUjtBQUNBLFVBQUlMLEdBQUcsQ0FBQ2tCLE1BQUosSUFBY2IsSUFBbEIsRUFBd0JtQixRQUFRLENBQUMsZUFBRCxDQUFSO0FBRXhCcEIsTUFBQUEsSUFBSSxHQUFHSixHQUFHLENBQUMvQixVQUFKLENBQWVvQyxJQUFmLENBQVA7QUFDQVUsTUFBQUEsQ0FBQyxHQUFHZixHQUFHLENBQUMvQixVQUFKLENBQWVvQyxJQUFJLEdBQUcsQ0FBdEIsQ0FBSjs7QUFFQSxVQUFJeUIsV0FBSixFQUFpQjtBQUNmLFlBQUksQ0FBQ0MsYUFBRCxJQUFrQjNCLElBQUksS0FBSzBCLFdBQS9CLEVBQTRDO0FBQzFDQSxVQUFBQSxXQUFXLEdBQUcsS0FBZDtBQUNBQyxVQUFBQSxhQUFhLEdBQUcsS0FBaEI7QUFDRCxTQUhELE1BR08sSUFBSTNCLElBQUksS0FBS2pDLFNBQWIsRUFBd0I7QUFDN0I0RCxVQUFBQSxhQUFhLEdBQUcsQ0FBQ2xCLE9BQWpCO0FBQ0QsU0FGTSxNQUVBLElBQUlrQixhQUFKLEVBQW1CO0FBQ3hCQSxVQUFBQSxhQUFhLEdBQUcsS0FBaEI7QUFDRDtBQUNGLE9BVEQsTUFTTyxJQUNMM0IsSUFBSSxLQUFLcEMsWUFBVCxJQUF5Qm9DLElBQUksS0FBS2xDLFlBRDdCLEVBRUw7QUFDQTRELFFBQUFBLFdBQVcsR0FBRzFCLElBQWQ7QUFDRCxPQUpNLE1BSUEsSUFBSUEsSUFBSSxLQUFLckIsV0FBYixFQUEwQjtBQUMvQjhDLFFBQUFBLElBQUksSUFBSSxDQUFSO0FBQ0QsT0FGTSxNQUVBLElBQUl6QixJQUFJLEtBQUtmLElBQVQsSUFBaUIwQixDQUFDLEtBQUtqQyxVQUEzQixFQUF1QztBQUM1QytDLFFBQUFBLElBQUksSUFBSSxDQUFSO0FBQ0Q7QUFDRjtBQUNGLEdBdkQwRCxDQXdEM0Q7OztBQUVBLFdBQVNHLFNBQVQsR0FBc0I7QUFDcEIsUUFBSVQsUUFBUSxDQUFDTCxNQUFiLEVBQXFCLE9BQU9LLFFBQVEsQ0FBQ1UsR0FBVCxFQUFQO0FBQ3JCLFFBQUlaLEdBQUcsSUFBSUgsTUFBWCxFQUFtQjtBQUVuQmQsSUFBQUEsSUFBSSxHQUFHSixHQUFHLENBQUMvQixVQUFKLENBQWVvRCxHQUFmLENBQVA7O0FBQ0EsUUFDRWpCLElBQUksS0FBSy9CLE9BQVQsSUFBb0IrQixJQUFJLEtBQUs3QixJQUE3QixJQUNDNkIsSUFBSSxLQUFLM0IsRUFBVCxJQUFldUIsR0FBRyxDQUFDL0IsVUFBSixDQUFlb0QsR0FBRyxHQUFHLENBQXJCLE1BQTRCaEQsT0FGOUMsRUFHRTtBQUNBOEMsTUFBQUEsTUFBTSxHQUFHRSxHQUFUO0FBQ0FELE1BQUFBLElBQUksSUFBSSxDQUFSO0FBQ0Q7O0FBRUQsWUFBUWhCLElBQVI7QUFDRSxXQUFLL0IsT0FBTDtBQUNBLFdBQUtDLEtBQUw7QUFDQSxXQUFLRSxHQUFMO0FBQ0EsV0FBS0MsRUFBTDtBQUNBLFdBQUtGLElBQUw7QUFDRThCLFFBQUFBLElBQUksR0FBR2dCLEdBQVA7O0FBQ0EsV0FBRztBQUNEaEIsVUFBQUEsSUFBSSxJQUFJLENBQVI7QUFDQUQsVUFBQUEsSUFBSSxHQUFHSixHQUFHLENBQUMvQixVQUFKLENBQWVvQyxJQUFmLENBQVA7O0FBQ0EsY0FBSUQsSUFBSSxLQUFLL0IsT0FBYixFQUFzQjtBQUNwQjhDLFlBQUFBLE1BQU0sR0FBR2QsSUFBVDtBQUNBZSxZQUFBQSxJQUFJLElBQUksQ0FBUjtBQUNEO0FBQ0YsU0FQRCxRQU9TaEIsSUFBSSxLQUFLOUIsS0FBVCxJQUNLOEIsSUFBSSxLQUFLL0IsT0FEZCxJQUVLK0IsSUFBSSxLQUFLNUIsR0FGZCxJQUdLNEIsSUFBSSxLQUFLM0IsRUFIZCxJQUlLMkIsSUFBSSxLQUFLN0IsSUFYdkI7O0FBYUF5QyxRQUFBQSxZQUFZLEdBQUcsQ0FBQyxPQUFELEVBQVVoQixHQUFHLENBQUNrQyxLQUFKLENBQVViLEdBQVYsRUFBZWhCLElBQWYsQ0FBVixDQUFmO0FBQ0FnQixRQUFBQSxHQUFHLEdBQUdoQixJQUFJLEdBQUcsQ0FBYjtBQUNBOztBQUVGLFdBQUszQixXQUFMO0FBQ0VzQyxRQUFBQSxZQUFZLEdBQUcsQ0FBQyxHQUFELEVBQU0sR0FBTixFQUFXSSxJQUFYLEVBQWlCQyxHQUFHLEdBQUdGLE1BQXZCLENBQWY7QUFDQTs7QUFFRixXQUFLeEMsWUFBTDtBQUNFcUMsUUFBQUEsWUFBWSxHQUFHLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsR0FBRyxHQUFHRixNQUF2QixDQUFmO0FBQ0E7O0FBRUYsV0FBS3JDLFVBQUw7QUFDRWtDLFFBQUFBLFlBQVksR0FBRyxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVdJLElBQVgsRUFBaUJDLEdBQUcsR0FBR0YsTUFBdkIsQ0FBZjtBQUNBOztBQUVGLFdBQUtwQyxXQUFMO0FBQ0VpQyxRQUFBQSxZQUFZLEdBQUcsQ0FBQyxHQUFELEVBQU0sR0FBTixFQUFXSSxJQUFYLEVBQWlCQyxHQUFHLEdBQUdGLE1BQXZCLENBQWY7QUFDQTtBQUVBOztBQUNGLFdBQUsvQixLQUFMO0FBQ0U0QixRQUFBQSxZQUFZLEdBQUcsQ0FDYixNQURhLEVBRWIsR0FGYSxFQUdiSSxJQUhhLEVBR1BDLEdBQUcsR0FBR0YsTUFIQyxFQUliQyxJQUphLEVBSVBDLEdBQUcsR0FBR0YsTUFBTixHQUFlLENBSlIsQ0FBZjtBQU1BO0FBQ0E7O0FBRUYsV0FBS2pDLEtBQUw7QUFDRThCLFFBQUFBLFlBQVksR0FBRyxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVdJLElBQVgsRUFBaUJDLEdBQUcsR0FBR0YsTUFBdkIsQ0FBZjtBQUNBOztBQUVGLFdBQUtuQyxTQUFMO0FBQ0VnQyxRQUFBQSxZQUFZLEdBQUcsQ0FBQyxHQUFELEVBQU0sR0FBTixFQUFXSSxJQUFYLEVBQWlCQyxHQUFHLEdBQUdGLE1BQXZCLENBQWY7QUFDQTs7QUFFRixXQUFLdkMsZ0JBQUw7QUFDRWtDLFFBQUFBLElBQUksR0FBR1EsTUFBTSxDQUFDSixNQUFQLEdBQWdCSSxNQUFNLENBQUNXLEdBQVAsR0FBYSxDQUFiLENBQWhCLEdBQWtDLEVBQXpDO0FBQ0FsQixRQUFBQSxDQUFDLEdBQUdmLEdBQUcsQ0FBQy9CLFVBQUosQ0FBZW9ELEdBQUcsR0FBRyxDQUFyQixDQUFKLENBRkYsQ0FJRTs7QUFDQSxZQUFJUCxJQUFJLEtBQUssS0FBVCxJQUFrQkMsQ0FBQyxLQUFLL0MsWUFBeEIsSUFBd0MrQyxDQUFDLEtBQUs3QyxZQUFsRCxFQUFnRTtBQUM5RCtDLFVBQUFBLFFBQVEsR0FBRyxDQUFYO0FBQ0FKLFVBQUFBLE9BQU8sR0FBRyxLQUFWO0FBQ0FSLFVBQUFBLElBQUksR0FBR2dCLEdBQUcsR0FBRyxDQUFiOztBQUNBLGlCQUFPaEIsSUFBSSxJQUFJTCxHQUFHLENBQUNrQixNQUFKLEdBQWEsQ0FBNUIsRUFBK0I7QUFDN0JILFlBQUFBLENBQUMsR0FBR2YsR0FBRyxDQUFDL0IsVUFBSixDQUFlb0MsSUFBZixDQUFKOztBQUNBLGdCQUFJVSxDQUFDLEtBQUs1QyxTQUFWLEVBQXFCO0FBQ25CMEMsY0FBQUEsT0FBTyxHQUFHLENBQUNBLE9BQVg7QUFDRCxhQUZELE1BRU8sSUFBSUUsQ0FBQyxLQUFLbkMsZ0JBQVYsRUFBNEI7QUFDakNxQyxjQUFBQSxRQUFRLElBQUksQ0FBWjtBQUNELGFBRk0sTUFFQSxJQUFJRixDQUFDLEtBQUtsQyxpQkFBVixFQUE2QjtBQUNsQ29DLGNBQUFBLFFBQVEsSUFBSSxDQUFaO0FBQ0Esa0JBQUlBLFFBQVEsS0FBSyxDQUFqQixFQUFvQjtBQUNyQjs7QUFDRFosWUFBQUEsSUFBSSxJQUFJLENBQVI7QUFDRDs7QUFFREksVUFBQUEsT0FBTyxHQUFHVCxHQUFHLENBQUNrQyxLQUFKLENBQVViLEdBQVYsRUFBZWhCLElBQUksR0FBRyxDQUF0QixDQUFWO0FBQ0FFLFVBQUFBLEtBQUssR0FBR0UsT0FBTyxDQUFDMEIsS0FBUixDQUFjLElBQWQsQ0FBUjtBQUNBM0IsVUFBQUEsSUFBSSxHQUFHRCxLQUFLLENBQUNXLE1BQU4sR0FBZSxDQUF0Qjs7QUFFQSxjQUFJVixJQUFJLEdBQUcsQ0FBWCxFQUFjO0FBQ1pHLFlBQUFBLFFBQVEsR0FBR1MsSUFBSSxHQUFHWixJQUFsQjtBQUNBSSxZQUFBQSxVQUFVLEdBQUdQLElBQUksR0FBR0UsS0FBSyxDQUFDQyxJQUFELENBQUwsQ0FBWVUsTUFBaEM7QUFDRCxXQUhELE1BR087QUFDTFAsWUFBQUEsUUFBUSxHQUFHUyxJQUFYO0FBQ0FSLFlBQUFBLFVBQVUsR0FBR08sTUFBYjtBQUNEOztBQUVESCxVQUFBQSxZQUFZLEdBQUcsQ0FBQyxVQUFELEVBQWFQLE9BQWIsRUFDYlcsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYlIsUUFGYSxFQUVITixJQUFJLEdBQUdPLFVBRkosQ0FBZjtBQUtBTyxVQUFBQSxNQUFNLEdBQUdQLFVBQVQ7QUFDQVEsVUFBQUEsSUFBSSxHQUFHVCxRQUFQO0FBQ0FVLFVBQUFBLEdBQUcsR0FBR2hCLElBQU4sQ0FwQzhELENBcUM5RDtBQUNELFNBdENELE1Bc0NPO0FBQ0xBLFVBQUFBLElBQUksR0FBR0wsR0FBRyxDQUFDb0MsT0FBSixDQUFZLEdBQVosRUFBaUJmLEdBQUcsR0FBRyxDQUF2QixDQUFQO0FBQ0FaLFVBQUFBLE9BQU8sR0FBR1QsR0FBRyxDQUFDa0MsS0FBSixDQUFVYixHQUFWLEVBQWVoQixJQUFJLEdBQUcsQ0FBdEIsQ0FBVjs7QUFFQSxjQUFJQSxJQUFJLEtBQUssQ0FBQyxDQUFWLElBQWViLGNBQWMsQ0FBQzZDLElBQWYsQ0FBb0I1QixPQUFwQixDQUFuQixFQUFpRDtBQUMvQ08sWUFBQUEsWUFBWSxHQUFHLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsR0FBRyxHQUFHRixNQUF2QixDQUFmO0FBQ0QsV0FGRCxNQUVPO0FBQ0xILFlBQUFBLFlBQVksR0FBRyxDQUFDLFVBQUQsRUFBYVAsT0FBYixFQUNiVyxJQURhLEVBQ1BDLEdBQUcsR0FBR0YsTUFEQyxFQUViQyxJQUZhLEVBRVBmLElBQUksR0FBR2MsTUFGQSxDQUFmO0FBSUFFLFlBQUFBLEdBQUcsR0FBR2hCLElBQU47QUFDRDtBQUNGOztBQUVEOztBQUVGLFdBQUt4QixpQkFBTDtBQUNFbUMsUUFBQUEsWUFBWSxHQUFHLENBQUMsR0FBRCxFQUFNLEdBQU4sRUFBV0ksSUFBWCxFQUFpQkMsR0FBRyxHQUFHRixNQUF2QixDQUFmO0FBQ0E7O0FBRUYsV0FBS25ELFlBQUw7QUFDQSxXQUFLRSxZQUFMO0FBQ0U7QUFDQW9DLFFBQUFBLEtBQUssR0FBR0YsSUFBUjtBQUNBQyxRQUFBQSxJQUFJLEdBQUdnQixHQUFQO0FBRUFSLFFBQUFBLE9BQU8sR0FBRyxLQUFWOztBQUNBLGVBQU9SLElBQUksR0FBR2EsTUFBZCxFQUFzQjtBQUNwQmIsVUFBQUEsSUFBSTtBQUNKLGNBQUlBLElBQUksS0FBS2EsTUFBYixFQUFxQk0sUUFBUSxDQUFDLFFBQUQsQ0FBUjtBQUVyQnBCLFVBQUFBLElBQUksR0FBR0osR0FBRyxDQUFDL0IsVUFBSixDQUFlb0MsSUFBZixDQUFQO0FBQ0FVLFVBQUFBLENBQUMsR0FBR2YsR0FBRyxDQUFDL0IsVUFBSixDQUFlb0MsSUFBSSxHQUFHLENBQXRCLENBQUo7O0FBRUEsY0FBSSxDQUFDUSxPQUFELElBQVlULElBQUksS0FBS0UsS0FBekIsRUFBZ0M7QUFDOUI7QUFDRCxXQUZELE1BRU8sSUFBSUYsSUFBSSxLQUFLakMsU0FBYixFQUF3QjtBQUM3QjBDLFlBQUFBLE9BQU8sR0FBRyxDQUFDQSxPQUFYO0FBQ0QsV0FGTSxNQUVBLElBQUlBLE9BQUosRUFBYTtBQUNsQkEsWUFBQUEsT0FBTyxHQUFHLEtBQVY7QUFDRCxXQUZNLE1BRUEsSUFBSVQsSUFBSSxLQUFLZixJQUFULElBQWlCMEIsQ0FBQyxLQUFLakMsVUFBM0IsRUFBdUM7QUFDNUM4QyxZQUFBQSxhQUFhO0FBQ2Q7QUFDRixTQXRCSCxDQXVCRTs7O0FBRUFuQixRQUFBQSxPQUFPLEdBQUdULEdBQUcsQ0FBQ2tDLEtBQUosQ0FBVWIsR0FBVixFQUFlaEIsSUFBSSxHQUFHLENBQXRCLENBQVY7QUFDQUUsUUFBQUEsS0FBSyxHQUFHRSxPQUFPLENBQUMwQixLQUFSLENBQWMsSUFBZCxDQUFSO0FBQ0EzQixRQUFBQSxJQUFJLEdBQUdELEtBQUssQ0FBQ1csTUFBTixHQUFlLENBQXRCOztBQUVBLFlBQUlWLElBQUksR0FBRyxDQUFYLEVBQWM7QUFDWkcsVUFBQUEsUUFBUSxHQUFHUyxJQUFJLEdBQUdaLElBQWxCO0FBQ0FJLFVBQUFBLFVBQVUsR0FBR1AsSUFBSSxHQUFHRSxLQUFLLENBQUNDLElBQUQsQ0FBTCxDQUFZVSxNQUFoQztBQUNELFNBSEQsTUFHTztBQUNMUCxVQUFBQSxRQUFRLEdBQUdTLElBQVg7QUFDQVIsVUFBQUEsVUFBVSxHQUFHTyxNQUFiO0FBQ0Q7O0FBRURILFFBQUFBLFlBQVksR0FBRyxDQUFDLFFBQUQsRUFBV2hCLEdBQUcsQ0FBQ2tDLEtBQUosQ0FBVWIsR0FBVixFQUFlaEIsSUFBSSxHQUFHLENBQXRCLENBQVgsRUFDYmUsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYlIsUUFGYSxFQUVITixJQUFJLEdBQUdPLFVBRkosQ0FBZjtBQUtBTyxRQUFBQSxNQUFNLEdBQUdQLFVBQVQ7QUFDQVEsUUFBQUEsSUFBSSxHQUFHVCxRQUFQO0FBQ0FVLFFBQUFBLEdBQUcsR0FBR2hCLElBQU47QUFDQTs7QUFFRixXQUFLbEIsRUFBTDtBQUNFRyxRQUFBQSxTQUFTLENBQUNnRCxTQUFWLEdBQXNCakIsR0FBRyxHQUFHLENBQTVCO0FBQ0EvQixRQUFBQSxTQUFTLENBQUMrQyxJQUFWLENBQWVyQyxHQUFmOztBQUNBLFlBQUlWLFNBQVMsQ0FBQ2dELFNBQVYsS0FBd0IsQ0FBNUIsRUFBK0I7QUFDN0JqQyxVQUFBQSxJQUFJLEdBQUdMLEdBQUcsQ0FBQ2tCLE1BQUosR0FBYSxDQUFwQjtBQUNELFNBRkQsTUFFTztBQUNMYixVQUFBQSxJQUFJLEdBQUdmLFNBQVMsQ0FBQ2dELFNBQVYsR0FBc0IsQ0FBN0I7QUFDRDs7QUFFRHRCLFFBQUFBLFlBQVksR0FBRyxDQUFDLFNBQUQsRUFBWWhCLEdBQUcsQ0FBQ2tDLEtBQUosQ0FBVWIsR0FBVixFQUFlaEIsSUFBSSxHQUFHLENBQXRCLENBQVosRUFDYmUsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYkMsSUFGYSxFQUVQZixJQUFJLEdBQUdjLE1BRkEsQ0FBZjtBQUtBRSxRQUFBQSxHQUFHLEdBQUdoQixJQUFOO0FBQ0E7O0FBRUYsV0FBS2xDLFNBQUw7QUFDRWtDLFFBQUFBLElBQUksR0FBR2dCLEdBQVA7QUFDQVgsUUFBQUEsTUFBTSxHQUFHLElBQVQ7O0FBQ0EsZUFBT1YsR0FBRyxDQUFDL0IsVUFBSixDQUFlb0MsSUFBSSxHQUFHLENBQXRCLE1BQTZCbEMsU0FBcEMsRUFBK0M7QUFDN0NrQyxVQUFBQSxJQUFJLElBQUksQ0FBUjtBQUNBSyxVQUFBQSxNQUFNLEdBQUcsQ0FBQ0EsTUFBVjtBQUNEOztBQUNETixRQUFBQSxJQUFJLEdBQUdKLEdBQUcsQ0FBQy9CLFVBQUosQ0FBZW9DLElBQUksR0FBRyxDQUF0QixDQUFQOztBQUNBLFlBQUlLLE1BQU0sSUFBS04sSUFBSSxLQUFLaEMsS0FBVCxJQUNLZ0MsSUFBSSxLQUFLOUIsS0FEZCxJQUVLOEIsSUFBSSxLQUFLL0IsT0FGZCxJQUdLK0IsSUFBSSxLQUFLNUIsR0FIZCxJQUlLNEIsSUFBSSxLQUFLM0IsRUFKZCxJQUtLMkIsSUFBSSxLQUFLN0IsSUFMN0IsRUFLb0M7QUFDbEM4QixVQUFBQSxJQUFJLElBQUksQ0FBUjs7QUFDQSxjQUFJWixhQUFhLENBQUM0QyxJQUFkLENBQW1CckMsR0FBRyxDQUFDdUMsTUFBSixDQUFXbEMsSUFBWCxDQUFuQixDQUFKLEVBQTBDO0FBQ3hDLG1CQUFPWixhQUFhLENBQUM0QyxJQUFkLENBQW1CckMsR0FBRyxDQUFDdUMsTUFBSixDQUFXbEMsSUFBSSxHQUFHLENBQWxCLENBQW5CLENBQVAsRUFBaUQ7QUFDL0NBLGNBQUFBLElBQUksSUFBSSxDQUFSO0FBQ0Q7O0FBQ0QsZ0JBQUlMLEdBQUcsQ0FBQy9CLFVBQUosQ0FBZW9DLElBQUksR0FBRyxDQUF0QixNQUE2Qi9CLEtBQWpDLEVBQXdDO0FBQ3RDK0IsY0FBQUEsSUFBSSxJQUFJLENBQVI7QUFDRDtBQUNGO0FBQ0Y7O0FBRURXLFFBQUFBLFlBQVksR0FBRyxDQUFDLE1BQUQsRUFBU2hCLEdBQUcsQ0FBQ2tDLEtBQUosQ0FBVWIsR0FBVixFQUFlaEIsSUFBSSxHQUFHLENBQXRCLENBQVQsRUFDYmUsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYkMsSUFGYSxFQUVQZixJQUFJLEdBQUdjLE1BRkEsQ0FBZjtBQUtBRSxRQUFBQSxHQUFHLEdBQUdoQixJQUFOO0FBQ0E7O0FBRUY7QUFDRTtBQUNBVSxRQUFBQSxDQUFDLEdBQUdmLEdBQUcsQ0FBQy9CLFVBQUosQ0FBZW9ELEdBQUcsR0FBRyxDQUFyQixDQUFKOztBQUVBLFlBQUlqQixJQUFJLEtBQUtmLElBQVQsSUFBaUIwQixDQUFDLEtBQUtqQyxVQUEzQixFQUF1QztBQUNyQ3VCLFVBQUFBLElBQUksR0FBR2dCLEdBQVA7QUFDQU8sVUFBQUEsYUFBYTtBQUVibkIsVUFBQUEsT0FBTyxHQUFHVCxHQUFHLENBQUNrQyxLQUFKLENBQVViLEdBQVYsRUFBZWhCLElBQUksR0FBRyxDQUF0QixDQUFWO0FBQ0FFLFVBQUFBLEtBQUssR0FBR0UsT0FBTyxDQUFDMEIsS0FBUixDQUFjLElBQWQsQ0FBUjtBQUNBM0IsVUFBQUEsSUFBSSxHQUFHRCxLQUFLLENBQUNXLE1BQU4sR0FBZSxDQUF0Qjs7QUFFQSxjQUFJVixJQUFJLEdBQUcsQ0FBWCxFQUFjO0FBQ1pHLFlBQUFBLFFBQVEsR0FBR1MsSUFBSSxHQUFHWixJQUFsQjtBQUNBSSxZQUFBQSxVQUFVLEdBQUdQLElBQUksR0FBR0UsS0FBSyxDQUFDQyxJQUFELENBQUwsQ0FBWVUsTUFBaEM7QUFDRCxXQUhELE1BR087QUFDTFAsWUFBQUEsUUFBUSxHQUFHUyxJQUFYO0FBQ0FSLFlBQUFBLFVBQVUsR0FBR08sTUFBYjtBQUNEOztBQUVESCxVQUFBQSxZQUFZLEdBQUcsQ0FBQyxNQUFELEVBQVNQLE9BQVQsRUFDYlcsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYlIsUUFGYSxFQUVITixJQUFJLEdBQUdPLFVBRkosQ0FBZjtBQUtBTyxVQUFBQSxNQUFNLEdBQUdQLFVBQVQ7QUFDQVEsVUFBQUEsSUFBSSxHQUFHVCxRQUFQO0FBQ0FVLFVBQUFBLEdBQUcsR0FBR2hCLElBQU47QUFDRCxTQXhCRCxNQXdCTyxJQUFJRCxJQUFJLEtBQUtoQyxLQUFULElBQWtCMkMsQ0FBQyxLQUFLOUIsUUFBNUIsRUFBc0M7QUFDM0M7QUFDQW9CLFVBQUFBLElBQUksR0FBR0wsR0FBRyxDQUFDb0MsT0FBSixDQUFZLElBQVosRUFBa0JmLEdBQUcsR0FBRyxDQUF4QixJQUE2QixDQUFwQzs7QUFDQSxjQUFJaEIsSUFBSSxLQUFLLENBQWIsRUFBZ0I7QUFDZCxnQkFBSUgsTUFBSixFQUFZO0FBQ1ZHLGNBQUFBLElBQUksR0FBR0wsR0FBRyxDQUFDa0IsTUFBWDtBQUNELGFBRkQsTUFFTztBQUNMTSxjQUFBQSxRQUFRLENBQUMsU0FBRCxDQUFSO0FBQ0Q7QUFDRjs7QUFFRGYsVUFBQUEsT0FBTyxHQUFHVCxHQUFHLENBQUNrQyxLQUFKLENBQVViLEdBQVYsRUFBZWhCLElBQUksR0FBRyxDQUF0QixDQUFWO0FBQ0FFLFVBQUFBLEtBQUssR0FBR0UsT0FBTyxDQUFDMEIsS0FBUixDQUFjLElBQWQsQ0FBUjtBQUNBM0IsVUFBQUEsSUFBSSxHQUFHRCxLQUFLLENBQUNXLE1BQU4sR0FBZSxDQUF0Qjs7QUFFQSxjQUFJVixJQUFJLEdBQUcsQ0FBWCxFQUFjO0FBQ1pHLFlBQUFBLFFBQVEsR0FBR1MsSUFBSSxHQUFHWixJQUFsQjtBQUNBSSxZQUFBQSxVQUFVLEdBQUdQLElBQUksR0FBR0UsS0FBSyxDQUFDQyxJQUFELENBQUwsQ0FBWVUsTUFBaEM7QUFDRCxXQUhELE1BR087QUFDTFAsWUFBQUEsUUFBUSxHQUFHUyxJQUFYO0FBQ0FSLFlBQUFBLFVBQVUsR0FBR08sTUFBYjtBQUNEOztBQUVESCxVQUFBQSxZQUFZLEdBQUcsQ0FBQyxTQUFELEVBQVlQLE9BQVosRUFDYlcsSUFEYSxFQUNQQyxHQUFHLEdBQUdGLE1BREMsRUFFYlIsUUFGYSxFQUVITixJQUFJLEdBQUdPLFVBRkosQ0FBZjtBQUtBTyxVQUFBQSxNQUFNLEdBQUdQLFVBQVQ7QUFDQVEsVUFBQUEsSUFBSSxHQUFHVCxRQUFQO0FBQ0FVLFVBQUFBLEdBQUcsR0FBR2hCLElBQU4sQ0E5QjJDLENBZ0MzQztBQUNELFNBakNNLE1BaUNBLElBQUlELElBQUksS0FBS2hDLEtBQVQsSUFBa0IyQyxDQUFDLEtBQUszQyxLQUE1QixFQUFtQztBQUN4Q3NCLFVBQUFBLFdBQVcsQ0FBQzRDLFNBQVosR0FBd0JqQixHQUFHLEdBQUcsQ0FBOUI7QUFDQTNCLFVBQUFBLFdBQVcsQ0FBQzJDLElBQVosQ0FBaUJyQyxHQUFqQjs7QUFDQSxjQUFJTixXQUFXLENBQUM0QyxTQUFaLEtBQTBCLENBQTlCLEVBQWlDO0FBQy9CakMsWUFBQUEsSUFBSSxHQUFHTCxHQUFHLENBQUNrQixNQUFKLEdBQWEsQ0FBcEI7QUFDRCxXQUZELE1BRU87QUFDTGIsWUFBQUEsSUFBSSxHQUFHWCxXQUFXLENBQUM0QyxTQUFaLEdBQXdCLENBQS9CO0FBQ0Q7O0FBRUQ3QixVQUFBQSxPQUFPLEdBQUdULEdBQUcsQ0FBQ2tDLEtBQUosQ0FBVWIsR0FBVixFQUFlaEIsSUFBSSxHQUFHLENBQXRCLENBQVY7QUFFQVcsVUFBQUEsWUFBWSxHQUFHLENBQUMsU0FBRCxFQUFZUCxPQUFaLEVBQ2JXLElBRGEsRUFDUEMsR0FBRyxHQUFHRixNQURDLEVBRWJDLElBRmEsRUFFUGYsSUFBSSxHQUFHYyxNQUZBLEVBR2IsUUFIYSxDQUFmO0FBTUFFLFVBQUFBLEdBQUcsR0FBR2hCLElBQU4sQ0FqQndDLENBa0J4QztBQUNELFNBbkJNLE1BbUJBO0FBQ0xkLFVBQUFBLFdBQVcsQ0FBQytDLFNBQVosR0FBd0JqQixHQUFHLEdBQUcsQ0FBOUI7QUFDQTlCLFVBQUFBLFdBQVcsQ0FBQzhDLElBQVosQ0FBaUJyQyxHQUFqQjs7QUFDQSxjQUFJVCxXQUFXLENBQUMrQyxTQUFaLEtBQTBCLENBQTlCLEVBQWlDO0FBQy9CakMsWUFBQUEsSUFBSSxHQUFHTCxHQUFHLENBQUNrQixNQUFKLEdBQWEsQ0FBcEI7QUFDRCxXQUZELE1BRU87QUFDTGIsWUFBQUEsSUFBSSxHQUFHZCxXQUFXLENBQUMrQyxTQUFaLEdBQXdCLENBQS9CO0FBQ0Q7O0FBRUR0QixVQUFBQSxZQUFZLEdBQUcsQ0FBQyxNQUFELEVBQVNoQixHQUFHLENBQUNrQyxLQUFKLENBQVViLEdBQVYsRUFBZWhCLElBQUksR0FBRyxDQUF0QixDQUFULEVBQ2JlLElBRGEsRUFDUEMsR0FBRyxHQUFHRixNQURDLEVBRWJDLElBRmEsRUFFUGYsSUFBSSxHQUFHYyxNQUZBLENBQWY7QUFLQUcsVUFBQUEsTUFBTSxDQUFDa0IsSUFBUCxDQUFZeEIsWUFBWjtBQUVBSyxVQUFBQSxHQUFHLEdBQUdoQixJQUFOO0FBQ0Q7O0FBRUQ7QUFoVUo7O0FBbVVBZ0IsSUFBQUEsR0FBRztBQUNILFdBQU9MLFlBQVA7QUFDRDs7QUFFRCxXQUFTeUIsSUFBVCxDQUFlQyxLQUFmLEVBQXNCO0FBQ3BCbkIsSUFBQUEsUUFBUSxDQUFDaUIsSUFBVCxDQUFjRSxLQUFkO0FBQ0Q7O0FBRUQsU0FBTztBQUNMRCxJQUFBQSxJQUFJLEVBQUpBLElBREs7QUFFTFQsSUFBQUEsU0FBUyxFQUFUQSxTQUZLO0FBR0xMLElBQUFBLFNBQVMsRUFBVEE7QUFISyxHQUFQO0FBS0QsQ0F2WkQiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBTSU5HTEVfUVVPVEUgPSAnXFwnJy5jaGFyQ29kZUF0KDApXG5jb25zdCBET1VCTEVfUVVPVEUgPSAnXCInLmNoYXJDb2RlQXQoMClcbmNvbnN0IEJBQ0tTTEFTSCA9ICdcXFxcJy5jaGFyQ29kZUF0KDApXG5jb25zdCBTTEFTSCA9ICcvJy5jaGFyQ29kZUF0KDApXG5jb25zdCBORVdMSU5FID0gJ1xcbicuY2hhckNvZGVBdCgwKVxuY29uc3QgU1BBQ0UgPSAnICcuY2hhckNvZGVBdCgwKVxuY29uc3QgRkVFRCA9ICdcXGYnLmNoYXJDb2RlQXQoMClcbmNvbnN0IFRBQiA9ICdcXHQnLmNoYXJDb2RlQXQoMClcbmNvbnN0IENSID0gJ1xccicuY2hhckNvZGVBdCgwKVxuY29uc3QgT1BFTl9TUVVBUkUgPSAnWycuY2hhckNvZGVBdCgwKVxuY29uc3QgQ0xPU0VfU1FVQVJFID0gJ10nLmNoYXJDb2RlQXQoMClcbmNvbnN0IE9QRU5fUEFSRU5USEVTRVMgPSAnKCcuY2hhckNvZGVBdCgwKVxuY29uc3QgQ0xPU0VfUEFSRU5USEVTRVMgPSAnKScuY2hhckNvZGVBdCgwKVxuY29uc3QgT1BFTl9DVVJMWSA9ICd7Jy5jaGFyQ29kZUF0KDApXG5jb25zdCBDTE9TRV9DVVJMWSA9ICd9Jy5jaGFyQ29kZUF0KDApXG5jb25zdCBTRU1JQ09MT04gPSAnOycuY2hhckNvZGVBdCgwKVxuY29uc3QgQVNURVJJU0sgPSAnKicuY2hhckNvZGVBdCgwKVxuY29uc3QgQ09MT04gPSAnOicuY2hhckNvZGVBdCgwKVxuY29uc3QgQVQgPSAnQCcuY2hhckNvZGVBdCgwKVxuXG4vLyBTQ1NTIFBBVENIIHtcbmNvbnN0IENPTU1BID0gJywnLmNoYXJDb2RlQXQoMClcbmNvbnN0IEhBU0ggPSAnIycuY2hhckNvZGVBdCgwKVxuLy8gfSBTQ1NTIFBBVENIXG5cbmNvbnN0IFJFX0FUX0VORCA9IC9bIFxcblxcdFxcclxcZnt9KCknXCJcXFxcOy9bXFxdI10vZ1xuY29uc3QgUkVfV09SRF9FTkQgPSAvWyBcXG5cXHRcXHJcXGYoKXt9OjtAISdcIlxcXFxcXF1bI118XFwvKD89XFwqKS9nXG5jb25zdCBSRV9CQURfQlJBQ0tFVCA9IC8uW1xcXFwvKFwiJ1xcbl0vXG5jb25zdCBSRV9IRVhfRVNDQVBFID0gL1thLWYwLTldL2lcblxuY29uc3QgUkVfTkVXX0xJTkUgPSAvW1xcclxcZlxcbl0vZyAvLyBTQ1NTIFBBVENIXG5cbi8vIFNDU1MgUEFUQ0ggZnVuY3Rpb24gbmFtZSB3YXMgY2hhbmdlZFxubW9kdWxlLmV4cG9ydHMgPSBmdW5jdGlvbiBzY3NzVG9rZW5pemUgKGlucHV0LCBvcHRpb25zID0ge30pIHtcbiAgbGV0IGNzcyA9IGlucHV0LmNzcy52YWx1ZU9mKClcbiAgbGV0IGlnbm9yZSA9IG9wdGlvbnMuaWdub3JlRXJyb3JzXG5cbiAgbGV0IGNvZGUsIG5leHQsIHF1b3RlLCBsaW5lcywgbGFzdCwgY29udGVudCwgZXNjYXBlLFxuICAgIG5leHRMaW5lLCBuZXh0T2Zmc2V0LCBlc2NhcGVkLCBwcmV2LCBuLCBjdXJyZW50VG9rZW5cblxuICBsZXQgYnJhY2tldHMgLy8gU0NTUyBQQVRDSFxuXG4gIGxldCBsZW5ndGggPSBjc3MubGVuZ3RoXG4gIGxldCBvZmZzZXQgPSAtMVxuICBsZXQgbGluZSA9IDFcbiAgbGV0IHBvcyA9IDBcbiAgbGV0IGJ1ZmZlciA9IFtdXG4gIGxldCByZXR1cm5lZCA9IFtdXG5cbiAgZnVuY3Rpb24gdW5jbG9zZWQgKHdoYXQpIHtcbiAgICB0aHJvdyBpbnB1dC5lcnJvcignVW5jbG9zZWQgJyArIHdoYXQsIGxpbmUsIHBvcyAtIG9mZnNldClcbiAgfVxuXG4gIGZ1bmN0aW9uIGVuZE9mRmlsZSAoKSB7XG4gICAgcmV0dXJuIHJldHVybmVkLmxlbmd0aCA9PT0gMCAmJiBwb3MgPj0gbGVuZ3RoXG4gIH1cblxuICAvLyBTQ1NTIFBBVENIIHtcbiAgZnVuY3Rpb24gaW50ZXJwb2xhdGlvbiAoKSB7XG4gICAgbGV0IGRlZXAgPSAxXG4gICAgbGV0IHN0cmluZ1F1b3RlID0gZmFsc2VcbiAgICBsZXQgc3RyaW5nRXNjYXBlZCA9IGZhbHNlXG4gICAgd2hpbGUgKGRlZXAgPiAwKSB7XG4gICAgICBuZXh0ICs9IDFcbiAgICAgIGlmIChjc3MubGVuZ3RoIDw9IG5leHQpIHVuY2xvc2VkKCdpbnRlcnBvbGF0aW9uJylcblxuICAgICAgY29kZSA9IGNzcy5jaGFyQ29kZUF0KG5leHQpXG4gICAgICBuID0gY3NzLmNoYXJDb2RlQXQobmV4dCArIDEpXG5cbiAgICAgIGlmIChzdHJpbmdRdW90ZSkge1xuICAgICAgICBpZiAoIXN0cmluZ0VzY2FwZWQgJiYgY29kZSA9PT0gc3RyaW5nUXVvdGUpIHtcbiAgICAgICAgICBzdHJpbmdRdW90ZSA9IGZhbHNlXG4gICAgICAgICAgc3RyaW5nRXNjYXBlZCA9IGZhbHNlXG4gICAgICAgIH0gZWxzZSBpZiAoY29kZSA9PT0gQkFDS1NMQVNIKSB7XG4gICAgICAgICAgc3RyaW5nRXNjYXBlZCA9ICFlc2NhcGVkXG4gICAgICAgIH0gZWxzZSBpZiAoc3RyaW5nRXNjYXBlZCkge1xuICAgICAgICAgIHN0cmluZ0VzY2FwZWQgPSBmYWxzZVxuICAgICAgICB9XG4gICAgICB9IGVsc2UgaWYgKFxuICAgICAgICBjb2RlID09PSBTSU5HTEVfUVVPVEUgfHwgY29kZSA9PT0gRE9VQkxFX1FVT1RFXG4gICAgICApIHtcbiAgICAgICAgc3RyaW5nUXVvdGUgPSBjb2RlXG4gICAgICB9IGVsc2UgaWYgKGNvZGUgPT09IENMT1NFX0NVUkxZKSB7XG4gICAgICAgIGRlZXAgLT0gMVxuICAgICAgfSBlbHNlIGlmIChjb2RlID09PSBIQVNIICYmIG4gPT09IE9QRU5fQ1VSTFkpIHtcbiAgICAgICAgZGVlcCArPSAxXG4gICAgICB9XG4gICAgfVxuICB9XG4gIC8vIH0gU0NTUyBQQVRDSFxuXG4gIGZ1bmN0aW9uIG5leHRUb2tlbiAoKSB7XG4gICAgaWYgKHJldHVybmVkLmxlbmd0aCkgcmV0dXJuIHJldHVybmVkLnBvcCgpXG4gICAgaWYgKHBvcyA+PSBsZW5ndGgpIHJldHVyblxuXG4gICAgY29kZSA9IGNzcy5jaGFyQ29kZUF0KHBvcylcbiAgICBpZiAoXG4gICAgICBjb2RlID09PSBORVdMSU5FIHx8IGNvZGUgPT09IEZFRUQgfHxcbiAgICAgIChjb2RlID09PSBDUiAmJiBjc3MuY2hhckNvZGVBdChwb3MgKyAxKSAhPT0gTkVXTElORSlcbiAgICApIHtcbiAgICAgIG9mZnNldCA9IHBvc1xuICAgICAgbGluZSArPSAxXG4gICAgfVxuXG4gICAgc3dpdGNoIChjb2RlKSB7XG4gICAgICBjYXNlIE5FV0xJTkU6XG4gICAgICBjYXNlIFNQQUNFOlxuICAgICAgY2FzZSBUQUI6XG4gICAgICBjYXNlIENSOlxuICAgICAgY2FzZSBGRUVEOlxuICAgICAgICBuZXh0ID0gcG9zXG4gICAgICAgIGRvIHtcbiAgICAgICAgICBuZXh0ICs9IDFcbiAgICAgICAgICBjb2RlID0gY3NzLmNoYXJDb2RlQXQobmV4dClcbiAgICAgICAgICBpZiAoY29kZSA9PT0gTkVXTElORSkge1xuICAgICAgICAgICAgb2Zmc2V0ID0gbmV4dFxuICAgICAgICAgICAgbGluZSArPSAxXG4gICAgICAgICAgfVxuICAgICAgICB9IHdoaWxlIChjb2RlID09PSBTUEFDRSB8fFxuICAgICAgICAgICAgICAgICAgICAgIGNvZGUgPT09IE5FV0xJTkUgfHxcbiAgICAgICAgICAgICAgICAgICAgICBjb2RlID09PSBUQUIgfHxcbiAgICAgICAgICAgICAgICAgICAgICBjb2RlID09PSBDUiB8fFxuICAgICAgICAgICAgICAgICAgICAgIGNvZGUgPT09IEZFRUQpXG5cbiAgICAgICAgY3VycmVudFRva2VuID0gWydzcGFjZScsIGNzcy5zbGljZShwb3MsIG5leHQpXVxuICAgICAgICBwb3MgPSBuZXh0IC0gMVxuICAgICAgICBicmVha1xuXG4gICAgICBjYXNlIE9QRU5fU1FVQVJFOlxuICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ1snLCAnWycsIGxpbmUsIHBvcyAtIG9mZnNldF1cbiAgICAgICAgYnJlYWtcblxuICAgICAgY2FzZSBDTE9TRV9TUVVBUkU6XG4gICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnXScsICddJywgbGluZSwgcG9zIC0gb2Zmc2V0XVxuICAgICAgICBicmVha1xuXG4gICAgICBjYXNlIE9QRU5fQ1VSTFk6XG4gICAgICAgIGN1cnJlbnRUb2tlbiA9IFsneycsICd7JywgbGluZSwgcG9zIC0gb2Zmc2V0XVxuICAgICAgICBicmVha1xuXG4gICAgICBjYXNlIENMT1NFX0NVUkxZOlxuICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ30nLCAnfScsIGxpbmUsIHBvcyAtIG9mZnNldF1cbiAgICAgICAgYnJlYWtcblxuICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgIGNhc2UgQ09NTUE6XG4gICAgICAgIGN1cnJlbnRUb2tlbiA9IFtcbiAgICAgICAgICAnd29yZCcsXG4gICAgICAgICAgJywnLFxuICAgICAgICAgIGxpbmUsIHBvcyAtIG9mZnNldCxcbiAgICAgICAgICBsaW5lLCBwb3MgLSBvZmZzZXQgKyAxXG4gICAgICAgIF1cbiAgICAgICAgYnJlYWtcbiAgICAgICAgLy8gfSBTQ1NTIFBBVENIXG5cbiAgICAgIGNhc2UgQ09MT046XG4gICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnOicsICc6JywgbGluZSwgcG9zIC0gb2Zmc2V0XVxuICAgICAgICBicmVha1xuXG4gICAgICBjYXNlIFNFTUlDT0xPTjpcbiAgICAgICAgY3VycmVudFRva2VuID0gWyc7JywgJzsnLCBsaW5lLCBwb3MgLSBvZmZzZXRdXG4gICAgICAgIGJyZWFrXG5cbiAgICAgIGNhc2UgT1BFTl9QQVJFTlRIRVNFUzpcbiAgICAgICAgcHJldiA9IGJ1ZmZlci5sZW5ndGggPyBidWZmZXIucG9wKClbMV0gOiAnJ1xuICAgICAgICBuID0gY3NzLmNoYXJDb2RlQXQocG9zICsgMSlcblxuICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgICAgaWYgKHByZXYgPT09ICd1cmwnICYmIG4gIT09IFNJTkdMRV9RVU9URSAmJiBuICE9PSBET1VCTEVfUVVPVEUpIHtcbiAgICAgICAgICBicmFja2V0cyA9IDFcbiAgICAgICAgICBlc2NhcGVkID0gZmFsc2VcbiAgICAgICAgICBuZXh0ID0gcG9zICsgMVxuICAgICAgICAgIHdoaWxlIChuZXh0IDw9IGNzcy5sZW5ndGggLSAxKSB7XG4gICAgICAgICAgICBuID0gY3NzLmNoYXJDb2RlQXQobmV4dClcbiAgICAgICAgICAgIGlmIChuID09PSBCQUNLU0xBU0gpIHtcbiAgICAgICAgICAgICAgZXNjYXBlZCA9ICFlc2NhcGVkXG4gICAgICAgICAgICB9IGVsc2UgaWYgKG4gPT09IE9QRU5fUEFSRU5USEVTRVMpIHtcbiAgICAgICAgICAgICAgYnJhY2tldHMgKz0gMVxuICAgICAgICAgICAgfSBlbHNlIGlmIChuID09PSBDTE9TRV9QQVJFTlRIRVNFUykge1xuICAgICAgICAgICAgICBicmFja2V0cyAtPSAxXG4gICAgICAgICAgICAgIGlmIChicmFja2V0cyA9PT0gMCkgYnJlYWtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIG5leHQgKz0gMVxuICAgICAgICAgIH1cblxuICAgICAgICAgIGNvbnRlbnQgPSBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSlcbiAgICAgICAgICBsaW5lcyA9IGNvbnRlbnQuc3BsaXQoJ1xcbicpXG4gICAgICAgICAgbGFzdCA9IGxpbmVzLmxlbmd0aCAtIDFcblxuICAgICAgICAgIGlmIChsYXN0ID4gMCkge1xuICAgICAgICAgICAgbmV4dExpbmUgPSBsaW5lICsgbGFzdFxuICAgICAgICAgICAgbmV4dE9mZnNldCA9IG5leHQgLSBsaW5lc1tsYXN0XS5sZW5ndGhcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgbmV4dExpbmUgPSBsaW5lXG4gICAgICAgICAgICBuZXh0T2Zmc2V0ID0gb2Zmc2V0XG4gICAgICAgICAgfVxuXG4gICAgICAgICAgY3VycmVudFRva2VuID0gWydicmFja2V0cycsIGNvbnRlbnQsXG4gICAgICAgICAgICBsaW5lLCBwb3MgLSBvZmZzZXQsXG4gICAgICAgICAgICBuZXh0TGluZSwgbmV4dCAtIG5leHRPZmZzZXRcbiAgICAgICAgICBdXG5cbiAgICAgICAgICBvZmZzZXQgPSBuZXh0T2Zmc2V0XG4gICAgICAgICAgbGluZSA9IG5leHRMaW5lXG4gICAgICAgICAgcG9zID0gbmV4dFxuICAgICAgICAgIC8vIH0gU0NTUyBQQVRDSFxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIG5leHQgPSBjc3MuaW5kZXhPZignKScsIHBvcyArIDEpXG4gICAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKVxuXG4gICAgICAgICAgaWYgKG5leHQgPT09IC0xIHx8IFJFX0JBRF9CUkFDS0VULnRlc3QoY29udGVudCkpIHtcbiAgICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnKCcsICcoJywgbGluZSwgcG9zIC0gb2Zmc2V0XVxuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ2JyYWNrZXRzJywgY29udGVudCxcbiAgICAgICAgICAgICAgbGluZSwgcG9zIC0gb2Zmc2V0LFxuICAgICAgICAgICAgICBsaW5lLCBuZXh0IC0gb2Zmc2V0XG4gICAgICAgICAgICBdXG4gICAgICAgICAgICBwb3MgPSBuZXh0XG4gICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgYnJlYWtcblxuICAgICAgY2FzZSBDTE9TRV9QQVJFTlRIRVNFUzpcbiAgICAgICAgY3VycmVudFRva2VuID0gWycpJywgJyknLCBsaW5lLCBwb3MgLSBvZmZzZXRdXG4gICAgICAgIGJyZWFrXG5cbiAgICAgIGNhc2UgU0lOR0xFX1FVT1RFOlxuICAgICAgY2FzZSBET1VCTEVfUVVPVEU6XG4gICAgICAgIC8vIFNDU1MgUEFUQ0gge1xuICAgICAgICBxdW90ZSA9IGNvZGVcbiAgICAgICAgbmV4dCA9IHBvc1xuXG4gICAgICAgIGVzY2FwZWQgPSBmYWxzZVxuICAgICAgICB3aGlsZSAobmV4dCA8IGxlbmd0aCkge1xuICAgICAgICAgIG5leHQrK1xuICAgICAgICAgIGlmIChuZXh0ID09PSBsZW5ndGgpIHVuY2xvc2VkKCdzdHJpbmcnKVxuXG4gICAgICAgICAgY29kZSA9IGNzcy5jaGFyQ29kZUF0KG5leHQpXG4gICAgICAgICAgbiA9IGNzcy5jaGFyQ29kZUF0KG5leHQgKyAxKVxuXG4gICAgICAgICAgaWYgKCFlc2NhcGVkICYmIGNvZGUgPT09IHF1b3RlKSB7XG4gICAgICAgICAgICBicmVha1xuICAgICAgICAgIH0gZWxzZSBpZiAoY29kZSA9PT0gQkFDS1NMQVNIKSB7XG4gICAgICAgICAgICBlc2NhcGVkID0gIWVzY2FwZWRcbiAgICAgICAgICB9IGVsc2UgaWYgKGVzY2FwZWQpIHtcbiAgICAgICAgICAgIGVzY2FwZWQgPSBmYWxzZVxuICAgICAgICAgIH0gZWxzZSBpZiAoY29kZSA9PT0gSEFTSCAmJiBuID09PSBPUEVOX0NVUkxZKSB7XG4gICAgICAgICAgICBpbnRlcnBvbGF0aW9uKClcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgLy8gfSBTQ1NTIFBBVENIXG5cbiAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKVxuICAgICAgICBsaW5lcyA9IGNvbnRlbnQuc3BsaXQoJ1xcbicpXG4gICAgICAgIGxhc3QgPSBsaW5lcy5sZW5ndGggLSAxXG5cbiAgICAgICAgaWYgKGxhc3QgPiAwKSB7XG4gICAgICAgICAgbmV4dExpbmUgPSBsaW5lICsgbGFzdFxuICAgICAgICAgIG5leHRPZmZzZXQgPSBuZXh0IC0gbGluZXNbbGFzdF0ubGVuZ3RoXG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgbmV4dExpbmUgPSBsaW5lXG4gICAgICAgICAgbmV4dE9mZnNldCA9IG9mZnNldFxuICAgICAgICB9XG5cbiAgICAgICAgY3VycmVudFRva2VuID0gWydzdHJpbmcnLCBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSksXG4gICAgICAgICAgbGluZSwgcG9zIC0gb2Zmc2V0LFxuICAgICAgICAgIG5leHRMaW5lLCBuZXh0IC0gbmV4dE9mZnNldFxuICAgICAgICBdXG5cbiAgICAgICAgb2Zmc2V0ID0gbmV4dE9mZnNldFxuICAgICAgICBsaW5lID0gbmV4dExpbmVcbiAgICAgICAgcG9zID0gbmV4dFxuICAgICAgICBicmVha1xuXG4gICAgICBjYXNlIEFUOlxuICAgICAgICBSRV9BVF9FTkQubGFzdEluZGV4ID0gcG9zICsgMVxuICAgICAgICBSRV9BVF9FTkQudGVzdChjc3MpXG4gICAgICAgIGlmIChSRV9BVF9FTkQubGFzdEluZGV4ID09PSAwKSB7XG4gICAgICAgICAgbmV4dCA9IGNzcy5sZW5ndGggLSAxXG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgbmV4dCA9IFJFX0FUX0VORC5sYXN0SW5kZXggLSAyXG4gICAgICAgIH1cblxuICAgICAgICBjdXJyZW50VG9rZW4gPSBbJ2F0LXdvcmQnLCBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSksXG4gICAgICAgICAgbGluZSwgcG9zIC0gb2Zmc2V0LFxuICAgICAgICAgIGxpbmUsIG5leHQgLSBvZmZzZXRcbiAgICAgICAgXVxuXG4gICAgICAgIHBvcyA9IG5leHRcbiAgICAgICAgYnJlYWtcblxuICAgICAgY2FzZSBCQUNLU0xBU0g6XG4gICAgICAgIG5leHQgPSBwb3NcbiAgICAgICAgZXNjYXBlID0gdHJ1ZVxuICAgICAgICB3aGlsZSAoY3NzLmNoYXJDb2RlQXQobmV4dCArIDEpID09PSBCQUNLU0xBU0gpIHtcbiAgICAgICAgICBuZXh0ICs9IDFcbiAgICAgICAgICBlc2NhcGUgPSAhZXNjYXBlXG4gICAgICAgIH1cbiAgICAgICAgY29kZSA9IGNzcy5jaGFyQ29kZUF0KG5leHQgKyAxKVxuICAgICAgICBpZiAoZXNjYXBlICYmIChjb2RlICE9PSBTTEFTSCAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGUgIT09IFNQQUNFICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZSAhPT0gTkVXTElORSAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGUgIT09IFRBQiAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGUgIT09IENSICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZSAhPT0gRkVFRCkpIHtcbiAgICAgICAgICBuZXh0ICs9IDFcbiAgICAgICAgICBpZiAoUkVfSEVYX0VTQ0FQRS50ZXN0KGNzcy5jaGFyQXQobmV4dCkpKSB7XG4gICAgICAgICAgICB3aGlsZSAoUkVfSEVYX0VTQ0FQRS50ZXN0KGNzcy5jaGFyQXQobmV4dCArIDEpKSkge1xuICAgICAgICAgICAgICBuZXh0ICs9IDFcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChjc3MuY2hhckNvZGVBdChuZXh0ICsgMSkgPT09IFNQQUNFKSB7XG4gICAgICAgICAgICAgIG5leHQgKz0gMVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnd29yZCcsIGNzcy5zbGljZShwb3MsIG5leHQgKyAxKSxcbiAgICAgICAgICBsaW5lLCBwb3MgLSBvZmZzZXQsXG4gICAgICAgICAgbGluZSwgbmV4dCAtIG9mZnNldFxuICAgICAgICBdXG5cbiAgICAgICAgcG9zID0gbmV4dFxuICAgICAgICBicmVha1xuXG4gICAgICBkZWZhdWx0OlxuICAgICAgICAvLyBTQ1NTIFBBVENIIHtcbiAgICAgICAgbiA9IGNzcy5jaGFyQ29kZUF0KHBvcyArIDEpXG5cbiAgICAgICAgaWYgKGNvZGUgPT09IEhBU0ggJiYgbiA9PT0gT1BFTl9DVVJMWSkge1xuICAgICAgICAgIG5leHQgPSBwb3NcbiAgICAgICAgICBpbnRlcnBvbGF0aW9uKClcblxuICAgICAgICAgIGNvbnRlbnQgPSBjc3Muc2xpY2UocG9zLCBuZXh0ICsgMSlcbiAgICAgICAgICBsaW5lcyA9IGNvbnRlbnQuc3BsaXQoJ1xcbicpXG4gICAgICAgICAgbGFzdCA9IGxpbmVzLmxlbmd0aCAtIDFcblxuICAgICAgICAgIGlmIChsYXN0ID4gMCkge1xuICAgICAgICAgICAgbmV4dExpbmUgPSBsaW5lICsgbGFzdFxuICAgICAgICAgICAgbmV4dE9mZnNldCA9IG5leHQgLSBsaW5lc1tsYXN0XS5sZW5ndGhcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgbmV4dExpbmUgPSBsaW5lXG4gICAgICAgICAgICBuZXh0T2Zmc2V0ID0gb2Zmc2V0XG4gICAgICAgICAgfVxuXG4gICAgICAgICAgY3VycmVudFRva2VuID0gWyd3b3JkJywgY29udGVudCxcbiAgICAgICAgICAgIGxpbmUsIHBvcyAtIG9mZnNldCxcbiAgICAgICAgICAgIG5leHRMaW5lLCBuZXh0IC0gbmV4dE9mZnNldFxuICAgICAgICAgIF1cblxuICAgICAgICAgIG9mZnNldCA9IG5leHRPZmZzZXRcbiAgICAgICAgICBsaW5lID0gbmV4dExpbmVcbiAgICAgICAgICBwb3MgPSBuZXh0XG4gICAgICAgIH0gZWxzZSBpZiAoY29kZSA9PT0gU0xBU0ggJiYgbiA9PT0gQVNURVJJU0spIHtcbiAgICAgICAgICAvLyB9IFNDU1MgUEFUQ0hcbiAgICAgICAgICBuZXh0ID0gY3NzLmluZGV4T2YoJyovJywgcG9zICsgMikgKyAxXG4gICAgICAgICAgaWYgKG5leHQgPT09IDApIHtcbiAgICAgICAgICAgIGlmIChpZ25vcmUpIHtcbiAgICAgICAgICAgICAgbmV4dCA9IGNzcy5sZW5ndGhcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgIHVuY2xvc2VkKCdjb21tZW50JylcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG5cbiAgICAgICAgICBjb250ZW50ID0gY3NzLnNsaWNlKHBvcywgbmV4dCArIDEpXG4gICAgICAgICAgbGluZXMgPSBjb250ZW50LnNwbGl0KCdcXG4nKVxuICAgICAgICAgIGxhc3QgPSBsaW5lcy5sZW5ndGggLSAxXG5cbiAgICAgICAgICBpZiAobGFzdCA+IDApIHtcbiAgICAgICAgICAgIG5leHRMaW5lID0gbGluZSArIGxhc3RcbiAgICAgICAgICAgIG5leHRPZmZzZXQgPSBuZXh0IC0gbGluZXNbbGFzdF0ubGVuZ3RoXG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIG5leHRMaW5lID0gbGluZVxuICAgICAgICAgICAgbmV4dE9mZnNldCA9IG9mZnNldFxuICAgICAgICAgIH1cblxuICAgICAgICAgIGN1cnJlbnRUb2tlbiA9IFsnY29tbWVudCcsIGNvbnRlbnQsXG4gICAgICAgICAgICBsaW5lLCBwb3MgLSBvZmZzZXQsXG4gICAgICAgICAgICBuZXh0TGluZSwgbmV4dCAtIG5leHRPZmZzZXRcbiAgICAgICAgICBdXG5cbiAgICAgICAgICBvZmZzZXQgPSBuZXh0T2Zmc2V0XG4gICAgICAgICAgbGluZSA9IG5leHRMaW5lXG4gICAgICAgICAgcG9zID0gbmV4dFxuXG4gICAgICAgICAgLy8gU0NTUyBQQVRDSCB7XG4gICAgICAgIH0gZWxzZSBpZiAoY29kZSA9PT0gU0xBU0ggJiYgbiA9PT0gU0xBU0gpIHtcbiAgICAgICAgICBSRV9ORVdfTElORS5sYXN0SW5kZXggPSBwb3MgKyAxXG4gICAgICAgICAgUkVfTkVXX0xJTkUudGVzdChjc3MpXG4gICAgICAgICAgaWYgKFJFX05FV19MSU5FLmxhc3RJbmRleCA9PT0gMCkge1xuICAgICAgICAgICAgbmV4dCA9IGNzcy5sZW5ndGggLSAxXG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIG5leHQgPSBSRV9ORVdfTElORS5sYXN0SW5kZXggLSAyXG4gICAgICAgICAgfVxuXG4gICAgICAgICAgY29udGVudCA9IGNzcy5zbGljZShwb3MsIG5leHQgKyAxKVxuXG4gICAgICAgICAgY3VycmVudFRva2VuID0gWydjb21tZW50JywgY29udGVudCxcbiAgICAgICAgICAgIGxpbmUsIHBvcyAtIG9mZnNldCxcbiAgICAgICAgICAgIGxpbmUsIG5leHQgLSBvZmZzZXQsXG4gICAgICAgICAgICAnaW5saW5lJ1xuICAgICAgICAgIF1cblxuICAgICAgICAgIHBvcyA9IG5leHRcbiAgICAgICAgICAvLyB9IFNDU1MgUEFUQ0hcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBSRV9XT1JEX0VORC5sYXN0SW5kZXggPSBwb3MgKyAxXG4gICAgICAgICAgUkVfV09SRF9FTkQudGVzdChjc3MpXG4gICAgICAgICAgaWYgKFJFX1dPUkRfRU5ELmxhc3RJbmRleCA9PT0gMCkge1xuICAgICAgICAgICAgbmV4dCA9IGNzcy5sZW5ndGggLSAxXG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIG5leHQgPSBSRV9XT1JEX0VORC5sYXN0SW5kZXggLSAyXG4gICAgICAgICAgfVxuXG4gICAgICAgICAgY3VycmVudFRva2VuID0gWyd3b3JkJywgY3NzLnNsaWNlKHBvcywgbmV4dCArIDEpLFxuICAgICAgICAgICAgbGluZSwgcG9zIC0gb2Zmc2V0LFxuICAgICAgICAgICAgbGluZSwgbmV4dCAtIG9mZnNldFxuICAgICAgICAgIF1cblxuICAgICAgICAgIGJ1ZmZlci5wdXNoKGN1cnJlbnRUb2tlbilcblxuICAgICAgICAgIHBvcyA9IG5leHRcbiAgICAgICAgfVxuXG4gICAgICAgIGJyZWFrXG4gICAgfVxuXG4gICAgcG9zKytcbiAgICByZXR1cm4gY3VycmVudFRva2VuXG4gIH1cblxuICBmdW5jdGlvbiBiYWNrICh0b2tlbikge1xuICAgIHJldHVybmVkLnB1c2godG9rZW4pXG4gIH1cblxuICByZXR1cm4ge1xuICAgIGJhY2ssXG4gICAgbmV4dFRva2VuLFxuICAgIGVuZE9mRmlsZVxuICB9XG59XG4iXSwiZmlsZSI6InNjc3MtdG9rZW5pemUuanMifQ==
