/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.function.IntPredicate;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.res.StringManager;

enum FrameType {
    DATA(0, false, true, null, false),
    HEADERS(1, false, true, null, true),
    PRIORITY(2, false, true, n -> n == 5, false),
    RST(3, false, true, n -> n == 4, false),
    SETTINGS(4, true, false, n -> n % 6 == 0, true),
    PUSH_PROMISE(5, false, true, n -> n >= 4, true),
    PING(6, true, false, n -> n == 8, false),
    GOAWAY(7, true, false, n -> n >= 8, false),
    WINDOW_UPDATE(8, true, true, n -> n == 4, true),
    CONTINUATION(9, false, true, null, true),
    UNKNOWN(256, true, true, null, false);

    private static final StringManager sm;
    private final int id;
    private final boolean streamZero;
    private final boolean streamNonZero;
    private final IntPredicate payloadSizeValidator;
    private final boolean payloadErrorFatal;

    private FrameType(int n2, boolean bl, boolean bl2, IntPredicate intPredicate, boolean bl3) {
        this.id = n2;
        this.streamZero = bl;
        this.streamNonZero = bl2;
        this.payloadSizeValidator = intPredicate;
        this.payloadErrorFatal = bl3;
    }

    byte getIdByte() {
        return (byte)this.id;
    }

    void check(int n, int n2) throws Http2Exception {
        if (n == 0 && !this.streamZero || n != 0 && !this.streamNonZero) {
            throw new ConnectionException(sm.getString("frameType.checkStream", new Object[]{this}), Http2Error.PROTOCOL_ERROR);
        }
        if (this.payloadSizeValidator != null && !this.payloadSizeValidator.test(n2)) {
            if (this.payloadErrorFatal || n == 0) {
                throw new ConnectionException(sm.getString("frameType.checkPayloadSize", new Object[]{Integer.toString(n2), this}), Http2Error.FRAME_SIZE_ERROR);
            }
            throw new StreamException(sm.getString("frameType.checkPayloadSize", new Object[]{Integer.toString(n2), this}), Http2Error.FRAME_SIZE_ERROR, n);
        }
    }

    static FrameType valueOf(int n) {
        switch (n) {
            case 0: {
                return DATA;
            }
            case 1: {
                return HEADERS;
            }
            case 2: {
                return PRIORITY;
            }
            case 3: {
                return RST;
            }
            case 4: {
                return SETTINGS;
            }
            case 5: {
                return PUSH_PROMISE;
            }
            case 6: {
                return PING;
            }
            case 7: {
                return GOAWAY;
            }
            case 8: {
                return WINDOW_UPDATE;
            }
            case 9: {
                return CONTINUATION;
            }
        }
        return UNKNOWN;
    }

    static {
        sm = StringManager.getManager(FrameType.class);
    }
}

