/*
 * Decompiled with CFR 0.152.
 */
package com.connectina.swing.fontchooser;

import com.connectina.swing.fontchooser.FontSelectionModel;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFontSelectionModel
implements FontSelectionModel {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Font selectedFont;
    private List<String> availableFontNames = new ArrayList<String>();

    public DefaultFontSelectionModel() {
        this(new Font("SansSerif", 0, 12));
    }

    public DefaultFontSelectionModel(Font font) {
        this.selectedFont = font;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Collections.addAll(this.availableFontNames, ge.getAvailableFontFamilyNames());
    }

    @Override
    public Font getSelectedFont() {
        return this.selectedFont;
    }

    @Override
    public void setSelectedFont(Font font) {
        if (font != null && !this.selectedFont.equals(font)) {
            this.selectedFont = font;
            this.fireStateChanged();
        }
    }

    @Override
    public List<String> getAvailableFontNames() {
        return this.availableFontNames;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

