/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ro extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Ora standard a Moscovei",
               "",
               "Ora de var\u0103 a Moscovei",
               "",
               "Ora Moscovei",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora standard a Pakistanului",
               "",
               "Ora de var\u0103 a Pakistanului",
               "",
               "Ora Pakistanului",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora standard din Magadan",
               "",
               "Ora de var\u0103 din Magadan",
               "",
               "Ora din Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard a Europei Centrale",
               "CET",
               "Ora de var\u0103 a Europei Centrale",
               "CEST",
               "Ora Europei Centrale",
               "CET",
            };
        final String[] Acre = new String[] {
               "Ora standard Acre",
               "",
               "Ora de var\u0103 Acre",
               "",
               "Ora Acre",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard oriental\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 oriental\u0103 nord-american\u0103",
               "",
               "Ora oriental\u0103 nord-american\u0103",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard din Lord Howe",
               "",
               "Ora de var\u0103 din Lord Howe",
               "",
               "Ora din Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora standard a Noii Zeelande",
               "",
               "Ora de var\u0103 a Noii Zeelande",
               "",
               "Ora Noii Zeelande",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora Oceanului Indian",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard din Iaku\u021bk",
               "",
               "Ora de var\u0103 din Iaku\u021bk",
               "",
               "Ora din Iaku\u021bk",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora Timorului de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Ora din Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard a Europei de Est",
               "EET",
               "Ora de var\u0103 a Europei de Est",
               "EEST",
               "Ora Europei de Est",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Ora standard a Argentinei Occidentale",
               "",
               "Ora de var\u0103 a Argentinei Occidentale",
               "",
               "Ora Argentinei Occidentale",
               "",
            };
        final String[] Ponape = new String[] {
               "Ora din Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora Boliviei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard din Saint-Pierre \u0219i Miquelon",
               "",
               "Ora de var\u0103 din Saint-Pierre \u0219i Miquelon",
               "",
               "Ora din Saint-Pierre \u0219i Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Ora Indochinei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard din Ekaterinburg",
               "",
               "Ora de var\u0103 din Ekaterinburg",
               "",
               "Ora din Ekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora din Maldive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora din Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora din Wallis \u0219i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Ora Africii Meridionale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Ora din Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora din Insulele Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standard din Uzbekistan",
               "",
               "Ora de var\u0103 din Uzbekistan",
               "",
               "Ora din Uzbekistan",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora standard din Ulan Bator",
               "",
               "Ora de var\u0103 din Ulan Bator",
               "",
               "Ora din Ulan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Ora standard central\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 central\u0103 nord-american\u0103",
               "",
               "Ora central\u0103 nord-american\u0103",
               "",
            };
        final String[] Niue = new String[] {
               "Ora din Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora Insulei Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora standard din Insulele Falkland",
               "",
               "Ora de var\u0103 din Insulele Falkland",
               "",
               "Ora din Insulele Falkland",
               "",
            };
        final String[] Apia = new String[] {
               "Ora standard din Apia",
               "",
               "Ora de var\u0103 din Apia",
               "",
               "Ora din Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora Bhutanului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Ora din Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora din Kazahstanul de Vest",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora din Insula Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora din Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Ora Insulelor Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora standard din Chatham",
               "",
               "Ora de var\u0103 din Chatham",
               "",
               "Ora din Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora din Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora standard a Argentinei",
               "",
               "Ora de var\u0103 a Argentinei",
               "",
               "Ora Argentinei",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora din Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora din Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora Venezuelei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora Insulelor Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standard din Capul Verde",
               "",
               "Ora de var\u0103 din Capul Verde",
               "",
               "Ora din Capul Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora Insulelor Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora standard din Samoa",
               "",
               "Ora de var\u0103 din Samoa",
               "",
               "Ora din Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "Ora din Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora standard a Cubei",
               "",
               "Ora de var\u0103 a Cubei",
               "",
               "Ora Cubei",
               "",
            };
        final String[] GMT = new String[] {
               "Ora de Greenwhich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora standard din Filipine",
               "",
               "Ora de var\u0103 din Filipine",
               "",
               "Ora din Filipine",
               "",
            };
        final String[] French_Southern = new String[] {
               "Ora din Teritoriile Australe \u0219i Antarctice Franceze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standard a Noii Caledonii",
               "",
               "Ora de var\u0103 a Noii Caledonii",
               "",
               "Ora Noii Caledonii",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora din Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Ora standard a Iranului",
               "",
               "Ora de var\u0103 a Iranului",
               "",
               "Ora Iranului",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora din Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora standard din Tonga",
               "",
               "Ora de var\u0103 din Tonga",
               "",
               "Ora din Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard din Bangladesh",
               "",
               "Ora de var\u0103 din Bangladesh",
               "",
               "Ora din Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "Ora standard din Peru",
               "",
               "Ora de var\u0103 din Peru",
               "",
               "Ora din Peru",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard a Groenlandei orientale",
               "",
               "Ora de var\u0103 a Groenlandei orientale",
               "",
               "Ora Groenlandei orientale",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora Indoneziei de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora din K\u00e2rg\u00e2zstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard a Australiei Orientale",
               "",
               "Ora de var\u0103 a Australiei Orientale",
               "",
               "Ora Australiei Orientale",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora din Guyana Francez\u0103",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Ora standard a Columbiei",
               "",
               "Ora de var\u0103 a Columbiei",
               "",
               "Ora Columbiei",
               "",
            };
        final String[] Chile = new String[] {
               "Ora standard din Chile",
               "",
               "Ora de var\u0103 din Chile",
               "",
               "Ora din Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora Insulelor Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard din Irku\u021bk",
               "",
               "Ora de var\u0103 din Irku\u021bk",
               "",
               "Ora din Irku\u021bk",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora standard a Georgiei",
               "",
               "Ora de var\u0103 a Georgiei",
               "",
               "Ora Georgiei",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard din Choibalsan",
               "",
               "Ora de var\u0103 din Choibalsan",
               "",
               "Ora din Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Ora standard a Chinei",
               "",
               "Ora de var\u0103 a Chinei",
               "",
               "Ora Chinei",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora standard a Armeniei",
               "",
               "Ora de var\u0103 a Armeniei",
               "",
               "Ora Armeniei",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora Africii Centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Ora standard a Japoniei",
               "",
               "Ora de var\u0103 a Japoniei",
               "",
               "Ora Japoniei",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora standard din Taipei",
               "",
               "Ora de var\u0103 din Taipei",
               "",
               "Ora din Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora standard din Hovd",
               "",
               "Ora de var\u0103 din Hovd",
               "",
               "Ora din Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard a Australiei Central Occidentale",
               "",
               "Ora de var\u0103 a Australiei Central Occidentale",
               "",
               "Ora Australiei Central Occidentale",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard din Sahalin",
               "",
               "Ora de var\u0103 din Sahalin",
               "",
               "Ora din Sahalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Ora standard din Paraguay",
               "",
               "Ora de var\u0103 din Paraguay",
               "",
               "Ora din Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora din Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Timpul universal coordonat",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora standard din Mauritius",
               "",
               "Ora de var\u0103 din Mauritius",
               "",
               "Ora din Mauritius",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora Africii Orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora Insulelor Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora Insulelor Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard din Newfoundland",
               "",
               "Ora de var\u0103 din Newfoundland",
               "",
               "Ora din Newfoundland",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora Afganistanului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standard din Hong Kong",
               "",
               "Ora de var\u0103 din Hong Kong",
               "",
               "Ora din Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora standard \u00een zona Atlantic nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona Atlantic nord-american\u0103",
               "",
               "Ora zonei Atlantic nord-americane",
               "",
            };
        final String[] Israel = new String[] {
               "Ora standard a Israelului",
               "",
               "Ora de var\u0103 a Israelului",
               "",
               "Ora Israelului",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora Indoneziei Centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora standard din Omsk",
               "",
               "Ora de var\u0103 din Omsk",
               "",
               "Ora din Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora din Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora standard a Uruguayului",
               "",
               "Ora de var\u0103 a Uruguayului",
               "",
               "Ora Uruguayului",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora Nepalului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Ora din Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora standard din Vanuatu",
               "",
               "Ora de var\u0103 din Vanuatu",
               "",
               "Ora din Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard din Novosibirsk",
               "",
               "Ora de var\u0103 din Novosibirsk",
               "",
               "Ora din Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora din Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Ora standard din Azore",
               "",
               "Ora de var\u0103 din Azore",
               "",
               "Ora din Azore",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora Surinamului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard din Krasnoiarsk",
               "",
               "Ora de var\u0103 din Krasnoiarsk",
               "",
               "Ora din Krasnoiarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora Myanmarului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Ora standard a Amazonului",
               "",
               "Ora de var\u0103 a Amazonului",
               "",
               "Ora Amazonului",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora din Kazahstanul de Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Ora standard din Fiji",
               "",
               "Ora de var\u0103 din Fiji",
               "",
               "Ora din Fiji",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Ora standard din Petropavlovsk-Kamcia\u021bki",
               "",
               "Ora de var\u0103 din Petropavlovsk-Kamcia\u021bki",
               "",
               "Ora din Petropavlovsk-Kamcia\u021bki",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Ora din Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Ora din Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard din Hawaii-Aleutine",
               "",
               "Ora de var\u0103 din Hawaii-Aleutine",
               "",
               "Ora din Hawaii-Aleutine",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard a Australiei Centrale",
               "",
               "Ora de var\u0103 a Australiei Centrale",
               "",
               "Ora Australiei Centrale",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard \u00een zona Pacific nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona Pacific nord-american\u0103",
               "",
               "Ora zonei Pacific nord-americane",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standard din Turkmenistan",
               "",
               "Ora de var\u0103 din Turkmenistan",
               "",
               "Ora din Turkmenistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard a Europei de Vest",
               "WET",
               "Ora de var\u0103 a Europei de Vest",
               "WEST",
               "Ora Europei de Vest",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Ora din Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora din Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora din Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora din Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard a Azerbaidjanului",
               "",
               "Ora de var\u0103 a Azerbaidjanului",
               "",
               "Ora Azerbaidjanului",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora din Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standard a zonei Pacific mexicane",
               "",
               "Ora de var\u0103 a zonei Pacific mexicane",
               "",
               "Ora zonei Pacific mexicane",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard a Africii Occidentale",
               "",
               "Ora de var\u0103 a Africii Occidentale",
               "",
               "Ora Africii Occidentale",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora Georgiei de Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora standard din Insula Pa\u0219telui",
               "",
               "Ora de var\u0103 din Insula Pa\u0219telui",
               "",
               "Ora din Insula Pa\u0219telui",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora standard a Mexicului de nord-vest",
               "",
               "Ora de var\u0103 a Mexicului de nord-vest",
               "",
               "Ora Mexicului de nord-vest",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Ora din Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard a Groenlandei occidentale",
               "",
               "Ora de var\u0103 a Groenlandei occidentale",
               "",
               "Ora Groenlandei occidentale",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora Ecuadorului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora standard a Golfului",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Ora standard a Coreei",
               "",
               "Ora de var\u0103 a Coreei",
               "",
               "Ora Coreei",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard a Australiei Occidentale",
               "",
               "Ora de var\u0103 a Australiei Occidentale",
               "",
               "Ora Australiei Occidentale",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora Indoneziei de Vest",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard \u00een zona montan\u0103 nord-american\u0103",
               "",
               "Ora de var\u0103 \u00een zona montan\u0103 nord-american\u0103",
               "",
               "Ora zonei montane nord-americane",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora Insulelor Marchize",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora standard arab\u0103",
               "",
               "Ora de var\u0103 arab\u0103",
               "",
               "Ora arab\u0103",
               "",
            };
        final String[] Alaska = new String[] {
               "Ora standard din Alaska",
               "",
               "Ora de var\u0103 din Alaska",
               "",
               "Ora din Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard din Vladivostok",
               "",
               "Ora de var\u0103 din Vladivostok",
               "",
               "Ora din Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora din Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora din Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora din Papua Noua Guinee",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora standard din Fernando de Noronha",
               "",
               "Ora de var\u0103 din Fernando de Noronha",
               "",
               "Ora din Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Ora standard a Brasiliei",
               "",
               "Ora de var\u0103 a Brasiliei",
               "",
               "Ora Brasiliei",
               "",
            };
        final String[] Anadyr = new String[] {
               "Ora standard din Anadyr",
               "",
               "Ora de var\u0103 din Anadyr",
               "",
               "Ora din Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Ora standard din Samara",
               "",
               "Ora de var\u0103 din Samara",
               "",
               "Ora din Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Ora din Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora Indiei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Ora standard a Insulelor Cook",
               "",
               "Ora de var\u0103 a Insulelor Cook",
               "",
               "Ora Insulelor Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marchize" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 britanic\u0103",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota de Nord" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0219anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londra" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Insula Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoiarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzne\u021bk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota de Nord" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia de Sud" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota de Nord" },
            { "timezone.excity.Asia/Atyrau", "At\u00eerau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0219kek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Ora\u0219 necunoscut" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Ujhorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 a Irlandei",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sf. Elena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Insula Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapesta" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Cita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuweit" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscova" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 britanic\u0103",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Capul Verde" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azore" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irku\u021bk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamciatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Iaku\u021bk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0219kent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Insula Pa\u0219telui" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Canare" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Var\u0219ovia" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadelupa" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.Asia/Almaty", "Almat\u00ee" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Phenian" },
            { "timezone.excity.Europe/Bucharest", "Bucure\u0219ti" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atena" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhaga" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Ierusalim" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damasc" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho \u0218i Min" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Ciudad de Mexico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporoje" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0219gabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comore" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldive" },
        };
        return data;
    }
}
