/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.IRFlags;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;

public class OptimizeDelegationPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Delegated Variable Removal";
    }

    @Override
    public String getShortLabel() {
        return "Opt Delegation";
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        EnumSet<IRFlags> flags2 = fic.getFlags();
        if (flags2.contains((Object)IRFlags.BINDING_HAS_ESCAPED)) {
            return null;
        }
        if (!fic.getScope().receivesClosureArg()) {
            return null;
        }
        OptimizeDelegationPass.optimizeDelegatedVars(fic);
        return true;
    }

    @Override
    public boolean invalidate(FullInterpreterContext fic) {
        return false;
    }

    private static void optimizeDelegatedVars(FullInterpreterContext fic) {
        ReifyClosureInstr ri;
        HashMap<Variable, Variable> unusedExplicitBlocks = new HashMap<Variable, Variable>();
        for (BasicBlock bb : fic.getCFG().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                if (i2 instanceof ReifyClosureInstr) {
                    ri = (ReifyClosureInstr)i2;
                    if (ri.getResult() instanceof LocalVariable) continue;
                    unusedExplicitBlocks.put(ri.getResult(), ri.getSource());
                    continue;
                }
                Iterator it = unusedExplicitBlocks.keySet().iterator();
                while (it.hasNext()) {
                    Variable explicitBlock = (Variable)it.next();
                    if (!OptimizeDelegationPass.usesVariableAsNonClosureArg(i2, explicitBlock)) continue;
                    it.remove();
                }
            }
        }
        for (BasicBlock bb : fic.getCFG().getBasicBlocks()) {
            ListIterator<Instr> instrs = bb.getInstrs().listIterator();
            while (instrs.hasNext()) {
                Variable procVar;
                Operand blockVar;
                Instr i2;
                i2 = instrs.next();
                if (!(i2 instanceof ReifyClosureInstr) || (blockVar = (Operand)unusedExplicitBlocks.get(procVar = (ri = (ReifyClosureInstr)i2).getResult())) == null) continue;
                ri.markDead();
                instrs.set(new CopyInstr(procVar, blockVar));
            }
        }
    }

    private static boolean usesVariableAsNonClosureArg(Instr i2, Variable v) {
        List<Variable> usedVariables = i2.getUsedVariables();
        return usedVariables.contains(v) && (!(i2 instanceof ClosureAcceptingInstr) || usedVariables.indexOf(v) != usedVariables.lastIndexOf(v) || v != ((ClosureAcceptingInstr)((Object)i2)).getClosureArg());
    }
}

