/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.ConstInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

class NameAndTypeInfo
extends ConstInfo {
    static final int tag = 12;
    int memberName;
    int typeDescriptor;

    public NameAndTypeInfo(int name, int type2, int index) {
        super(index);
        this.memberName = name;
        this.typeDescriptor = type2;
    }

    public NameAndTypeInfo(DataInputStream in, int index) throws IOException {
        super(index);
        this.memberName = in.readUnsignedShort();
        this.typeDescriptor = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.memberName << 16 ^ this.typeDescriptor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NameAndTypeInfo) {
            NameAndTypeInfo nti = (NameAndTypeInfo)obj;
            return nti.memberName == this.memberName && nti.typeDescriptor == this.typeDescriptor;
        }
        return false;
    }

    @Override
    public int getTag() {
        return 12;
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName, HashMap cache) {
        String type2;
        String type3 = cp.getUtf8Info(this.typeDescriptor);
        if (type3 != (type2 = Descriptor.rename(type3, oldName, newName))) {
            if (cache == null) {
                this.typeDescriptor = cp.addUtf8Info(type2);
            } else {
                cache.remove(this);
                this.typeDescriptor = cp.addUtf8Info(type2);
                cache.put(this, this);
            }
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map map2, HashMap cache) {
        String type2;
        String type3 = cp.getUtf8Info(this.typeDescriptor);
        if (type3 != (type2 = Descriptor.rename(type3, map2))) {
            if (cache == null) {
                this.typeDescriptor = cp.addUtf8Info(type2);
            } else {
                cache.remove(this);
                this.typeDescriptor = cp.addUtf8Info(type2);
                cache.put(this, this);
            }
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map map2) {
        String mname = src.getUtf8Info(this.memberName);
        String tdesc = src.getUtf8Info(this.typeDescriptor);
        tdesc = Descriptor.rename(tdesc, map2);
        return dest.addNameAndTypeInfo(dest.addUtf8Info(mname), dest.addUtf8Info(tdesc));
    }

    @Override
    public void write(DataOutputStream out2) throws IOException {
        out2.writeByte(12);
        out2.writeShort(this.memberName);
        out2.writeShort(this.typeDescriptor);
    }

    @Override
    public void print(PrintWriter out2) {
        out2.print("NameAndType #");
        out2.print(this.memberName);
        out2.print(", type #");
        out2.println(this.typeDescriptor);
    }
}

