/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindClassInModuleKt {
    @Nullable
    public static final ClassifierDescriptor findClassifierAcrossModuleDependencies(@NotNull ModuleDescriptor $this$findClassifierAcrossModuleDependencies, @NotNull ClassId classId) {
        ClassifierDescriptor topLevelClass;
        Intrinsics.checkParameterIsNotNull($this$findClassifierAcrossModuleDependencies, "$this$findClassifierAcrossModuleDependencies");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageViewDescriptor packageViewDescriptor = $this$findClassifierAcrossModuleDependencies.getPackage(fqName2);
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "classId.relativeClassName.pathSegments()");
        List<Name> segments = list2;
        MemberScope memberScope2 = packageViewDescriptor.getMemberScope();
        Name name = CollectionsKt.first(segments);
        Intrinsics.checkExpressionValueIsNotNull(name, "segments.first()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (classifierDescriptor == null) {
            return null;
        }
        ClassifierDescriptor result2 = topLevelClass = classifierDescriptor;
        for (Name name2 : segments.subList(1, segments.size())) {
            if (!(result2 instanceof ClassDescriptor)) {
                return null;
            }
            MemberScope memberScope3 = ((ClassDescriptor)result2).getUnsubstitutedInnerClassesScope();
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
            ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name3, NoLookupLocation.FROM_DESERIALIZATION);
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor2;
            if (classDescriptor == null) {
                return null;
            }
            result2 = classDescriptor;
        }
        return result2;
    }

    @Nullable
    public static final ClassDescriptor findClassAcrossModuleDependencies(@NotNull ModuleDescriptor $this$findClassAcrossModuleDependencies, @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull($this$findClassAcrossModuleDependencies, "$this$findClassAcrossModuleDependencies");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        ClassifierDescriptor classifierDescriptor = FindClassInModuleKt.findClassifierAcrossModuleDependencies($this$findClassAcrossModuleDependencies, classId);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassDescriptor findNonGenericClassAcrossDependencies(@NotNull ModuleDescriptor $this$findNonGenericClassAcrossDependencies, @NotNull ClassId classId, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull($this$findNonGenericClassAcrossDependencies, "$this$findNonGenericClassAcrossDependencies");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        ClassDescriptor existingClass = FindClassInModuleKt.findClassAcrossModuleDependencies($this$findNonGenericClassAcrossDependencies, classId);
        if (existingClass != null) {
            return existingClass;
        }
        List<Integer> typeParametersCount2 = SequencesKt.toList(SequencesKt.map(SequencesKt.generateSequence(classId, (Function1)findNonGenericClassAcrossDependencies.typeParametersCount.1.INSTANCE), findNonGenericClassAcrossDependencies.typeParametersCount.2.INSTANCE));
        return notFoundClasses.getClass(classId, typeParametersCount2);
    }

    @Nullable
    public static final TypeAliasDescriptor findTypeAliasAcrossModuleDependencies(@NotNull ModuleDescriptor $this$findTypeAliasAcrossModuleDependencies, @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull($this$findTypeAliasAcrossModuleDependencies, "$this$findTypeAliasAcrossModuleDependencies");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        ClassifierDescriptor classifierDescriptor = FindClassInModuleKt.findClassifierAcrossModuleDependencies($this$findTypeAliasAcrossModuleDependencies, classId);
        if (!(classifierDescriptor instanceof TypeAliasDescriptor)) {
            classifierDescriptor = null;
        }
        return (TypeAliasDescriptor)classifierDescriptor;
    }
}

