/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Array;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class ArrayAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private int index;

    public ArrayAccessor() {
    }

    public ArrayAccessor(int index) {
        this.index = index;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(Array.get(ctx, this.index), elCtx, vars);
        }
        try {
            return Array.get(ctx, this.index);
        }
        catch (IllegalArgumentException e) {
            throw new ClassCastException("Argument of type '" + ctx.getClass() + "' is not an Array");
        }
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(Array.get(ctx, this.index), elCtx, variableFactory, value2);
        }
        Array.set(ctx, this.index, value2);
        return value2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Class getKnownEgressType() {
        return Object[].class;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }
}

