/* fwupdplugin.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Fwupd", gir_namespace = "Fwupd", gir_version = "2.0", lower_case_cprefix = "fwupd_")]
namespace Fwupd {
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_client_get_type ()")]
	public class Client : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.7.0")]
		public Client ();
		[Version (since = "1.2.6")]
		public bool activate (GLib.Cancellable? cancellable, string device_id) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool activate_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.7.0")]
		public bool clear_results (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool clear_results_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.7.1")]
		public bool connect (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool connect_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.5")]
		public GLib.Bytes download_bytes (string url, Fwupd.ClientDownloadFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.Bytes download_bytes_async (string url, Fwupd.ClientDownloadFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.5.2")]
		public bool download_file (string url, GLib.File file, Fwupd.ClientDownloadFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool ensure_networking () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.2.6")]
		public string[] get_approved_firmware (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak string> get_approved_firmware_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.4.6")]
		public string[] get_blocked_firmware (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak string> get_blocked_firmware_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.3.4")]
		public bool get_daemon_interactive ();
		[Version (since = "0.9.6")]
		public unowned string get_daemon_version ();
		[Version (since = "1.0.0")]
		public GLib.GenericArray<weak Fwupd.Device> get_details (string filename, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public GLib.GenericArray<weak Fwupd.Device> get_details_bytes (GLib.Bytes bytes, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Device> get_details_bytes_async (GLib.Bytes bytes, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.3")]
		public Fwupd.Device get_device_by_id (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async Fwupd.Device get_device_by_id_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.2")]
		public GLib.GenericArray<weak Fwupd.Device> get_devices (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Device> get_devices_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.1")]
		public GLib.GenericArray<weak Fwupd.Device> get_devices_by_guid (string guid, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Release> get_devices_by_guid_async (string guid, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.8")]
		public GLib.GenericArray<weak Fwupd.Release> get_downgrades (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Release> get_downgrades_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.0.4")]
		public GLib.GenericArray<weak Fwupd.Device> get_history (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Device> get_history_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.3.2")]
		public unowned string get_host_machine_id ();
		[Version (since = "1.3.1")]
		public unowned string get_host_product ();
		[Version (since = "1.5.0")]
		public GLib.GenericArray<weak Fwupd.SecurityAttr> get_host_security_attrs (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.SecurityAttr> get_host_security_attrs_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.5.0")]
		public unowned string get_host_security_id ();
		[Version (since = "1.5.3")]
		public GLib.MainContext get_main_context ();
		[Version (since = "0.7.3")]
		public uint get_percentage ();
		[Version (since = "1.5.0")]
		public GLib.GenericArray<weak Fwupd.Plugin> get_plugins (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Device> get_plugins_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.3")]
		public GLib.GenericArray<weak Fwupd.Release> get_releases (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Release> get_releases_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.3")]
		public Fwupd.Remote get_remote_by_id (string remote_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async Fwupd.Remote get_remote_by_id_async (string remote_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.3")]
		public GLib.GenericArray<weak Fwupd.Remote> get_remotes (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Remote> get_remotes_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.5.0")]
		public GLib.HashTable<void*,void*> get_report_metadata (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.HashTable<void*,void*> get_report_metadata_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.7.0")]
		public Fwupd.Device get_results (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async Fwupd.Device get_results_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.7.3")]
		public Fwupd.Status get_status ();
		[Version (since = "1.2.4")]
		public bool get_tainted ();
		[Version (since = "0.9.8")]
		public GLib.GenericArray<weak Fwupd.Release> get_upgrades (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.GenericArray<weak Fwupd.Release> get_upgrades_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.5.2")]
		public unowned string get_user_agent ();
		[Version (since = "0.7.0")]
		public bool install (string device_id, string filename, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool install_async (string device_id, string filename, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool install_bytes (string device_id, GLib.Bytes bytes, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool install_bytes_async (string device_id, GLib.Bytes bytes, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.5.6", since = "1.4.5")]
		public bool install_release (Fwupd.Device device, Fwupd.Release release, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.6")]
		public bool install_release2 (Fwupd.Device device, Fwupd.Release release, Fwupd.InstallFlags install_flags, Fwupd.ClientDownloadFlags download_flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.6")]
		public async void install_release2_async (Fwupd.Device device, Fwupd.Release release, Fwupd.InstallFlags install_flags, Fwupd.ClientDownloadFlags download_flags, GLib.Cancellable? cancellable);
		[Version (deprecated = true, deprecated_since = "1.5.6", since = "1.5.0")]
		public async bool install_release_async (Fwupd.Device device, Fwupd.Release release, Fwupd.InstallFlags install_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.2.8")]
		public bool modify_config (string key, string value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool modify_config_async (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.0.4")]
		public bool modify_device (string device_id, string key, string value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool modify_device_async (string device_id, string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.8")]
		public bool modify_remote (string remote_id, string key, string value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool modify_remote_async (string remote_id, string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool refresh_remote (Fwupd.Remote remote, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool refresh_remote_async (Fwupd.Remote remote, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.2.6")]
		public string self_sign (string value, Fwupd.SelfSignFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async string self_sign_async (string value, Fwupd.SelfSignFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.2.6")]
		public bool set_approved_firmware (string checksums, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool set_approved_firmware_async (GLib.GenericArray<string> checksums, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.6")]
		public bool set_blocked_firmware (string checksums, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool set_blocked_firmware_async (GLib.GenericArray<string> checksums, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool set_feature_flags (Fwupd.FeatureFlags feature_flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool set_feature_flags_async (Fwupd.FeatureFlags feature_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.5.3")]
		public void set_main_context (GLib.MainContext? main_ctx);
		[Version (since = "1.4.5")]
		public void set_user_agent (string user_agent);
		[Version (since = "1.4.5")]
		public void set_user_agent_for_package (string package_name, string package_version);
		[Version (since = "0.7.0")]
		public bool @unlock (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool unlock_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.0.0")]
		public bool update_metadata (string remote_id, string metadata_fn, string signature_fn, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool update_metadata_bytes (string remote_id, GLib.Bytes metadata, GLib.Bytes signature, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool update_metadata_bytes_async (string remote_id, GLib.Bytes metadata, GLib.Bytes signature, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.4.5")]
		public GLib.Bytes upload_bytes (string url, string payload, string? signature, Fwupd.ClientUploadFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async GLib.Bytes upload_bytes_async (string url, string payload, string? signature, Fwupd.ClientUploadFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.7.0")]
		public bool verify (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool verify_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.8.0")]
		public bool verify_update (string device_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.5.0")]
		public async bool verify_update_async (string device_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.6")]
		public string daemon_version { get; }
		[Version (since = "1.3.2")]
		public string host_machine_id { get; }
		[Version (since = "1.3.1")]
		public string host_product { get; }
		[Version (since = "1.5.0")]
		public string host_security_id { get; }
		[NoAccessorMethod]
		[Version (since = "1.3.4")]
		public bool interactive { get; }
		[NoAccessorMethod]
		[Version (since = "0.7.3")]
		public uint percentage { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.4.5")]
		public GLib.Object soup_session { owned get; }
		[NoAccessorMethod]
		[Version (since = "0.7.0")]
		public uint status { get; set; }
		[Version (since = "1.2.4")]
		public bool tainted { get; }
		[Version (since = "0.7.0")]
		public virtual signal void changed ();
		[Version (since = "0.7.1")]
		public virtual signal void device_added (Fwupd.Device result);
		[Version (since = "0.7.1")]
		public virtual signal void device_changed (Fwupd.Device result);
		[Version (since = "0.7.1")]
		public virtual signal void device_removed (Fwupd.Device result);
		public virtual signal void status_changed (uint status);
	}
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_device_get_type ()")]
	public class Device : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.9.3")]
		public Device ();
		[Version (since = "0.9.3")]
		public void add_checksum (string checksum);
		[Version (since = "1.5.1")]
		public void add_child (Fwupd.Device child);
		[Version (since = "0.9.3")]
		public void add_flag (Fwupd.DeviceFlags flag);
		[Version (since = "0.9.3")]
		public void add_guid (string guid);
		[Version (since = "0.9.8")]
		public void add_icon (string icon);
		[Version (since = "1.2.5")]
		public void add_instance_id (string instance_id);
		[Version (since = "1.5.8")]
		public void add_protocol (string protocol);
		[Version (since = "0.9.8")]
		public void add_release (Fwupd.Release release);
		[Version (since = "1.5.5")]
		public void add_vendor_id (string vendor_id);
		[Version (since = "1.3.7")]
		public static void array_ensure_parents (GLib.GenericArray<Fwupd.Device> devices);
		[Version (since = "1.2.10")]
		public static GLib.GenericArray<weak Fwupd.Device> array_from_variant (GLib.Variant value);
		[Version (since = "1.1.1")]
		public int compare (Fwupd.Device device2);
		[Version (since = "0.7.0")]
		public static Fwupd.DeviceFlags flag_from_string (string device_flag);
		[Version (since = "0.7.0")]
		public static unowned string flag_to_string (Fwupd.DeviceFlags device_flag);
		[Version (since = "1.0.0")]
		public static Fwupd.Device from_variant (GLib.Variant value);
		[Version (since = "1.5.0")]
		public unowned string get_branch ();
		[Version (since = "0.9.3")]
		public unowned GLib.GenericArray<string> get_checksums ();
		[Version (since = "1.3.7")]
		public unowned GLib.GenericArray<Fwupd.Device> get_children ();
		[Version (since = "0.9.3")]
		public uint64 get_created ();
		[Version (since = "0.9.3")]
		public unowned string get_description ();
		[Version (since = "0.9.3")]
		public uint64 get_flags ();
		[Version (since = "0.9.3")]
		public uint32 get_flashes_left ();
		[Version (since = "0.9.3")]
		public unowned string get_guid_default ();
		[Version (since = "0.9.3")]
		public unowned GLib.GenericArray<string> get_guids ();
		[Version (since = "0.9.8")]
		public unowned GLib.GenericArray<string> get_icons ();
		[Version (since = "0.9.3")]
		public unowned string get_id ();
		[Version (since = "1.1.3")]
		public uint32 get_install_duration ();
		[Version (since = "1.2.5")]
		public unowned GLib.GenericArray<string> get_instance_ids ();
		[Version (since = "0.9.3")]
		public uint64 get_modified ();
		[Version (since = "0.9.3")]
		public unowned string get_name ();
		[Version (since = "1.0.8")]
		public unowned Fwupd.Device get_parent ();
		[Version (since = "1.0.8")]
		public unowned string get_parent_id ();
		[Version (since = "1.0.0")]
		public unowned string get_plugin ();
		[Version (deprecated = true, deprecated_since = "1.5.8", since = "1.3.6")]
		public unowned string get_protocol ();
		[Version (since = "1.5.8")]
		public unowned GLib.GenericArray<string> get_protocols ();
		[Version (since = "0.9.8")]
		public unowned Fwupd.Release get_release_default ();
		[Version (since = "0.9.8")]
		public unowned GLib.GenericArray<Fwupd.Release> get_releases ();
		[Version (since = "1.1.2")]
		public unowned string get_serial ();
		[Version (since = "1.4.0")]
		public Fwupd.Status get_status ();
		[Version (since = "0.9.3")]
		public unowned string get_summary ();
		[Version (since = "0.9.8")]
		public unowned string get_update_error ();
		[Version (since = "1.4.5")]
		public unowned string get_update_image ();
		[Version (since = "1.2.4")]
		public unowned string get_update_message ();
		[Version (since = "0.9.8")]
		public Fwupd.UpdateState get_update_state ();
		[Version (since = "0.9.3")]
		public unowned string get_vendor ();
		[Version (deprecated = true, deprecated_since = "1.5.5", since = "0.9.4")]
		public unowned string get_vendor_id ();
		[Version (since = "1.5.5")]
		public unowned GLib.GenericArray<string> get_vendor_ids ();
		[Version (since = "0.9.3")]
		public unowned string get_version ();
		[Version (since = "0.9.3")]
		public unowned string get_version_bootloader ();
		[Version (since = "1.4.0")]
		public uint64 get_version_bootloader_raw ();
		[Version (since = "1.2.9")]
		public Fwupd.VersionFormat get_version_format ();
		[Version (since = "0.9.3")]
		public unowned string get_version_lowest ();
		[Version (since = "1.4.0")]
		public uint64 get_version_lowest_raw ();
		[Version (since = "1.3.6")]
		public uint64 get_version_raw ();
		[Version (since = "0.9.3")]
		public bool has_flag (Fwupd.DeviceFlags flag);
		[Version (since = "0.9.3")]
		public bool has_guid (string guid);
		[Version (since = "1.2.5")]
		public bool has_instance_id (string instance_id);
		[Version (since = "1.5.8")]
		public bool has_protocol (string protocol);
		[Version (since = "1.5.5")]
		public bool has_vendor_id (string vendor_id);
		[Version (since = "1.4.1")]
		public static bool id_is_valid (string device_id);
		[Version (since = "1.1.0")]
		public void incorporate (Fwupd.Device donor);
		[Version (since = "0.9.3")]
		public void remove_flag (Fwupd.DeviceFlags flag);
		[Version (since = "1.5.0")]
		public void set_branch (string branch);
		[Version (since = "0.9.3")]
		public void set_created (uint64 created);
		[Version (since = "0.9.3")]
		public void set_description (string description);
		[Version (since = "0.9.3")]
		public void set_flags (uint64 flags);
		[Version (since = "0.9.3")]
		public void set_flashes_left (uint32 flashes_left);
		[Version (since = "0.9.3")]
		public void set_id (string id);
		[Version (since = "1.1.3")]
		public void set_install_duration (uint32 duration);
		[Version (since = "0.9.3")]
		public void set_modified (uint64 modified);
		[Version (since = "0.9.3")]
		public void set_name (string name);
		[Version (since = "1.0.8")]
		public void set_parent (Fwupd.Device parent);
		[Version (since = "1.0.8")]
		public void set_parent_id (string parent_id);
		[Version (since = "1.0.0")]
		public void set_plugin (string plugin);
		[Version (deprecated = true, deprecated_since = "1.5.8", since = "1.3.6")]
		public void set_protocol (string protocol);
		[Version (since = "1.1.2")]
		public void set_serial (string serial);
		[Version (since = "1.4.0")]
		public void set_status (Fwupd.Status status);
		[Version (since = "0.9.3")]
		public void set_summary (string summary);
		[Version (since = "0.9.8")]
		public void set_update_error (string update_error);
		[Version (since = "1.4.5")]
		public void set_update_image (string update_image);
		[Version (since = "1.2.4")]
		public void set_update_message (string update_message);
		[Version (since = "0.9.8")]
		public void set_update_state (Fwupd.UpdateState update_state);
		[Version (since = "0.9.3")]
		public void set_vendor (string vendor);
		[Version (deprecated = true, deprecated_since = "1.5.5", since = "0.9.4")]
		public void set_vendor_id (string vendor_id);
		[Version (since = "0.9.3")]
		public void set_version (string version);
		[Version (since = "0.9.3")]
		public void set_version_bootloader (string version_bootloader);
		[Version (since = "1.4.0")]
		public void set_version_bootloader_raw (uint64 version_bootloader_raw);
		[Version (since = "1.2.9")]
		public void set_version_format (Fwupd.VersionFormat version_format);
		[Version (since = "0.9.3")]
		public void set_version_lowest (string version_lowest);
		[Version (since = "1.4.0")]
		public void set_version_lowest_raw (uint64 version_lowest_raw);
		[Version (since = "1.3.6")]
		public void set_version_raw (uint64 version_raw);
		[Version (since = "0.9.3")]
		public string to_string ();
		[Version (since = "1.0.0")]
		public GLib.Variant to_variant ();
		[Version (since = "1.1.2")]
		public GLib.Variant to_variant_full (Fwupd.DeviceFlags flags);
		public uint64 flags { get; set; }
		public Fwupd.Device parent { get; set construct; }
		public string protocol { get; set; }
		public uint status { get; set; }
		public uint update_state { get; set; }
		public uint version_format { get; set; }
	}
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_plugin_get_type ()")]
	public class Plugin : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "1.5.0")]
		public Plugin ();
		[Version (since = "1.5.0")]
		public void add_flag (Fwupd.PluginFlags flag);
		[Version (since = "1.5.0")]
		public static GLib.GenericArray<weak Fwupd.Plugin> array_from_variant (GLib.Variant value);
		[Version (since = "1.5.0")]
		public static Fwupd.PluginFlags flag_from_string (string plugin_flag);
		[Version (since = "1.5.0")]
		public static unowned string flag_to_string (Fwupd.PluginFlags plugin_flag);
		[Version (since = "1.5.0")]
		public static Fwupd.Plugin from_variant (GLib.Variant value);
		[Version (since = "1.5.0")]
		public uint64 get_flags ();
		[Version (since = "1.5.0")]
		public unowned string get_name ();
		[Version (since = "1.5.0")]
		public bool has_flag (Fwupd.PluginFlags flag);
		[Version (since = "1.5.0")]
		public void remove_flag (Fwupd.PluginFlags flag);
		[Version (since = "1.5.0")]
		public void set_flags (uint64 flags);
		[Version (since = "1.5.0")]
		public void set_name (string name);
		[Version (since = "1.5.0")]
		public string to_string ();
		[Version (since = "1.5.0")]
		public GLib.Variant to_variant ();
		public uint64 flags { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_release_get_type ()")]
	public class Release : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.9.3")]
		public Release ();
		[Version (since = "1.2.7")]
		public void add_category (string category);
		[Version (since = "0.9.3")]
		public void add_checksum (string checksum);
		[Version (since = "1.2.6")]
		public void add_flag (Fwupd.ReleaseFlags flag);
		[Version (since = "1.3.2")]
		public void add_issue (string issue);
		[Version (since = "1.5.6")]
		public void add_location (string location);
		[Version (since = "1.0.4")]
		public void add_metadata (GLib.HashTable<void*,void*> hash);
		[Version (since = "1.0.4")]
		public void add_metadata_item (string key, string value);
		[Version (since = "1.2.10")]
		public static GLib.GenericArray<weak Fwupd.Release> array_from_variant (GLib.Variant value);
		[Version (since = "1.2.6")]
		public static Fwupd.ReleaseFlags flag_from_string (string release_flag);
		[Version (since = "1.2.6")]
		public static unowned string flag_to_string (Fwupd.ReleaseFlags release_flag);
		[Version (since = "1.0.0")]
		public static Fwupd.Release from_variant (GLib.Variant value);
		[Version (since = "0.9.3")]
		public unowned string get_appstream_id ();
		[Version (since = "1.5.0")]
		public unowned string get_branch ();
		[Version (since = "1.2.7")]
		public unowned GLib.GenericArray<string> get_categories ();
		[Version (since = "0.9.3")]
		public unowned GLib.GenericArray<string> get_checksums ();
		[Version (since = "1.4.0")]
		public uint64 get_created ();
		[Version (since = "0.9.3")]
		public unowned string get_description ();
		[Version (since = "1.3.3")]
		public unowned string get_detach_caption ();
		[Version (since = "1.3.3")]
		public unowned string get_detach_image ();
		[Version (since = "1.2.4")]
		public unowned string get_details_url ();
		[Version (since = "0.9.3")]
		public unowned string get_filename ();
		[Version (since = "1.2.6")]
		public Fwupd.ReleaseFlags get_flags ();
		[Version (since = "0.9.3")]
		public unowned string get_homepage ();
		[Version (since = "1.2.1")]
		public uint32 get_install_duration ();
		[Version (since = "1.3.2")]
		public unowned GLib.GenericArray<string> get_issues ();
		[Version (since = "0.9.3")]
		public unowned string get_license ();
		[Version (since = "1.5.6")]
		public unowned GLib.GenericArray<string> get_locations ();
		[Version (since = "1.0.4")]
		public unowned GLib.HashTable<void*,void*> get_metadata ();
		[Version (since = "1.0.4")]
		public unowned string get_metadata_item (string key);
		[Version (since = "0.9.3")]
		public unowned string get_name ();
		[Version (since = "1.3.2")]
		public unowned string get_name_variant_suffix ();
		[Version (since = "1.2.2")]
		public unowned string get_protocol ();
		[Version (since = "0.9.3")]
		public unowned string get_remote_id ();
		[Version (since = "0.9.3")]
		public uint64 get_size ();
		[Version (since = "1.2.4")]
		public unowned string get_source_url ();
		[Version (since = "0.9.3")]
		public unowned string get_summary ();
		[Version (since = "0.9.8")]
		public Fwupd.TrustFlags get_trust_flags ();
		[Version (since = "1.4.5")]
		public unowned string get_update_image ();
		[Version (since = "1.2.4")]
		public unowned string get_update_message ();
		[Version (since = "1.4.0")]
		public Fwupd.ReleaseUrgency get_urgency ();
		[Version (deprecated = true, deprecated_since = "1.5.6", since = "0.9.3")]
		public unowned string get_uri ();
		[Version (since = "0.9.3")]
		public unowned string get_vendor ();
		[Version (since = "0.9.3")]
		public unowned string get_version ();
		[Version (since = "1.2.7")]
		public bool has_category (string category);
		[Version (since = "1.2.6")]
		public bool has_checksum (string checksum);
		[Version (since = "1.2.6")]
		public bool has_flag (Fwupd.ReleaseFlags flag);
		[Version (since = "1.2.6")]
		public void remove_flag (Fwupd.ReleaseFlags flag);
		[Version (since = "0.9.3")]
		public void set_appstream_id (string appstream_id);
		[Version (since = "1.5.0")]
		public void set_branch (string branch);
		[Version (since = "1.4.0")]
		public void set_created (uint64 created);
		[Version (since = "0.9.3")]
		public void set_description (string description);
		[Version (since = "1.3.3")]
		public void set_detach_caption (string detach_caption);
		[Version (since = "1.3.3")]
		public void set_detach_image (string detach_image);
		[Version (since = "1.2.4")]
		public void set_details_url (string details_url);
		[Version (since = "0.9.3")]
		public void set_filename (string filename);
		[Version (since = "1.2.6")]
		public void set_flags (Fwupd.ReleaseFlags flags);
		[Version (since = "0.9.3")]
		public void set_homepage (string homepage);
		[Version (since = "1.2.1")]
		public void set_install_duration (uint32 duration);
		[Version (since = "0.9.3")]
		public void set_license (string license);
		[Version (since = "0.9.3")]
		public void set_name (string name);
		[Version (since = "1.3.2")]
		public void set_name_variant_suffix (string name_variant_suffix);
		[Version (since = "1.2.2")]
		public void set_protocol (string protocol);
		[Version (since = "0.9.3")]
		public void set_remote_id (string remote_id);
		[Version (since = "0.9.3")]
		public void set_size (uint64 size);
		[Version (since = "1.2.4")]
		public void set_source_url (string source_url);
		[Version (since = "0.9.3")]
		public void set_summary (string summary);
		[Version (since = "0.9.8")]
		public void set_trust_flags (Fwupd.TrustFlags trust_flags);
		[Version (since = "1.4.5")]
		public void set_update_image (string update_image);
		[Version (since = "1.2.4")]
		public void set_update_message (string update_message);
		[Version (since = "1.4.0")]
		public void set_urgency (Fwupd.ReleaseUrgency urgency);
		[Version (deprecated = true, deprecated_since = "1.5.6", since = "0.9.3")]
		public void set_uri (string uri);
		[Version (since = "0.9.3")]
		public void set_vendor (string vendor);
		[Version (since = "0.9.3")]
		public void set_version (string version);
		[Version (since = "0.9.3")]
		public string to_string ();
		[Version (since = "1.0.0")]
		public GLib.Variant to_variant ();
		[Version (since = "1.4.0")]
		public static Fwupd.ReleaseUrgency urgency_from_string (string release_urgency);
		[Version (since = "1.4.0")]
		public static unowned string urgency_to_string (Fwupd.ReleaseUrgency release_urgency);
	}
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_remote_get_type ()")]
	public class Remote : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.9.3")]
		public Remote ();
		[Version (since = "1.2.10")]
		public static GLib.GenericArray<weak Fwupd.Remote> array_from_variant (GLib.Variant value);
		[Version (since = "0.9.7")]
		public string build_firmware_uri (string url) throws GLib.Error;
		[Version (since = "1.0.0")]
		public static Fwupd.Remote from_variant (GLib.Variant value);
		[Version (since = "0.9.5")]
		public uint64 get_age ();
		[Version (since = "1.0.7")]
		public unowned string get_agreement ();
		[Version (since = "1.2.6")]
		public bool get_approval_required ();
		[Version (since = "1.3.3")]
		public bool get_automatic_reports ();
		[Version (since = "1.5.0")]
		public bool get_automatic_security_reports ();
		[Version (since = "1.0.0")]
		public unowned string get_checksum ();
		[Version (since = "0.9.3")]
		public bool get_enabled ();
		[Version (since = "0.9.6")]
		public unowned string get_filename_cache ();
		[Version (since = "0.9.7")]
		public unowned string get_filename_cache_sig ();
		[Version (since = "0.9.8")]
		public unowned string get_filename_source ();
		[Version (since = "0.9.7")]
		public unowned string get_firmware_base_uri ();
		[Version (since = "0.9.3")]
		public unowned string get_id ();
		[Version (since = "0.9.7")]
		public Fwupd.KeyringKind get_keyring_kind ();
		[Version (since = "0.9.6")]
		public Fwupd.RemoteKind get_kind ();
		[Version (since = "0.9.7")]
		public unowned string get_metadata_uri ();
		[Version (since = "0.9.7")]
		public unowned string get_metadata_uri_sig ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.9.5")]
		public unowned string[] get_order_after ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.9.5")]
		public unowned string[] get_order_before ();
		[Version (since = "0.9.5")]
		public unowned string get_password ();
		[Version (since = "0.9.5")]
		public int get_priority ();
		[Version (since = "1.3.1")]
		public unowned string get_remotes_dir ();
		[Version (since = "1.0.4")]
		public unowned string get_report_uri ();
		[Version (since = "1.5.0")]
		public unowned string get_security_report_uri ();
		[Version (since = "0.9.8")]
		public unowned string get_title ();
		[Version (since = "0.9.5")]
		public unowned string get_username ();
		[Version (since = "0.9.6")]
		public static Fwupd.RemoteKind kind_from_string (string kind);
		[Version (since = "0.9.6")]
		public static unowned string kind_to_string (Fwupd.RemoteKind kind);
		[Version (since = "0.9.3")]
		public bool load_from_filename (string filename, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.4.0")]
		public bool load_signature (string filename) throws GLib.Error;
		[Version (since = "1.4.5")]
		public bool load_signature_bytes (GLib.Bytes bytes) throws GLib.Error;
		[Version (since = "1.0.7")]
		public void set_agreement (string agreement);
		[Version (since = "1.5.3")]
		public void set_keyring_kind (Fwupd.KeyringKind keyring_kind);
		[Version (since = "0.9.5")]
		public void set_mtime (uint64 mtime);
		[Version (since = "0.9.5")]
		public void set_priority (int priority);
		[Version (since = "1.3.1")]
		public void set_remotes_dir (string directory);
		[Version (since = "1.0.0")]
		public GLib.Variant to_variant ();
		[NoAccessorMethod]
		[Version (since = "1.2.6")]
		public bool approval_required { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.3.3")]
		public bool automatic_reports { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.5.0")]
		public bool automatic_security_reports { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.3")]
		public bool enabled { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.9.3")]
		public string id { owned get; set; }
	}
	[CCode (cheader_filename = "fwupd.h", type_id = "fwupd_security_attr_get_type ()")]
	public class SecurityAttr : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "1.5.0")]
		public SecurityAttr (string? appstream_id);
		[Version (since = "1.5.0")]
		public void add_flag (Fwupd.SecurityAttrFlags flag);
		[Version (since = "1.5.0")]
		public void add_metadata (string key, string? value);
		[Version (since = "1.5.0")]
		public void add_obsolete (string appstream_id);
		[Version (since = "1.5.0")]
		public static GLib.GenericArray<weak Fwupd.SecurityAttr> array_from_variant (GLib.Variant value);
		[Version (since = "1.5.0")]
		public static unowned string flag_to_string (Fwupd.SecurityAttrFlags flag);
		[Version (since = "1.5.0")]
		public static unowned string flag_to_suffix (Fwupd.SecurityAttrFlags flag);
		[Version (since = "1.5.0")]
		public static Fwupd.SecurityAttr from_variant (GLib.Variant value);
		[Version (since = "1.5.0")]
		public unowned string get_appstream_id ();
		[Version (since = "1.5.0")]
		public Fwupd.SecurityAttrFlags get_flags ();
		[Version (since = "1.5.0")]
		public Fwupd.SecurityAttrLevel get_level ();
		[Version (since = "1.5.0")]
		public unowned string? get_metadata (string key);
		[Version (since = "1.5.0")]
		public unowned string get_name ();
		[Version (since = "1.5.0")]
		public unowned GLib.GenericArray<string> get_obsoletes ();
		[Version (since = "1.5.0")]
		public unowned string get_plugin ();
		[Version (since = "1.5.0")]
		public Fwupd.SecurityAttrResult get_result ();
		[Version (since = "1.5.0")]
		public unowned string get_url ();
		[Version (since = "1.5.0")]
		public bool has_flag (Fwupd.SecurityAttrFlags flag);
		[Version (since = "1.5.0")]
		public bool has_obsolete (string appstream_id);
		[Version (since = "1.5.0")]
		public static unowned string result_to_string (Fwupd.SecurityAttrResult result);
		[Version (since = "1.5.0")]
		public void set_appstream_id (string appstream_id);
		[Version (since = "1.5.0")]
		public void set_flags (Fwupd.SecurityAttrFlags flags);
		[Version (since = "1.5.0")]
		public void set_level (Fwupd.SecurityAttrLevel level);
		[Version (since = "1.5.0")]
		public void set_name (string name);
		[Version (since = "1.5.0")]
		public void set_plugin (string plugin);
		[Version (since = "1.5.0")]
		public void set_result (Fwupd.SecurityAttrResult result);
		[Version (since = "1.5.0")]
		public void set_url (string url);
		[Version (since = "1.5.0")]
		public string to_string ();
		[Version (since = "1.5.0")]
		public GLib.Variant to_variant ();
	}
	[CCode (cheader_filename = "fwupd.h")]
	[SimpleType]
	public struct DeviceFlags : uint64 {
	}
	[CCode (cheader_filename = "fwupd.h")]
	[SimpleType]
	public struct PluginFlags : uint64 {
	}
	[CCode (cheader_filename = "fwupd.h")]
	[SimpleType]
	public struct ReleaseFlags : uint64 {
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_CLIENT_DOWNLOAD_FLAG_", has_type_id = false)]
	[Flags]
	public enum ClientDownloadFlags {
		NONE,
		ONLY_IPFS
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_CLIENT_UPLOAD_FLAG_", has_type_id = false)]
	[Flags]
	public enum ClientUploadFlags {
		NONE,
		ALWAYS_MULTIPART
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_FEATURE_FLAG_", has_type_id = false)]
	[Flags]
	public enum FeatureFlags {
		NONE,
		CAN_REPORT,
		DETACH_ACTION,
		UPDATE_ACTION,
		SWITCH_BRANCH
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_GUID_FLAG_", has_type_id = false)]
	[Flags]
	public enum GuidFlags {
		NONE,
		NAMESPACE_MICROSOFT,
		MIXED_ENDIAN
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_INSTALL_FLAG_", has_type_id = false)]
	[Flags]
	public enum InstallFlags {
		NONE,
		OFFLINE,
		ALLOW_REINSTALL,
		ALLOW_OLDER,
		FORCE,
		NO_HISTORY,
		ALLOW_BRANCH_SWITCH,
		IGNORE_CHECKSUM,
		IGNORE_VID_PID,
		IGNORE_POWER,
		NO_SEARCH
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_KEYRING_KIND_", has_type_id = false)]
	public enum KeyringKind {
		UNKNOWN,
		NONE,
		GPG,
		PKCS7,
		JCAT;
		[Version (since = "0.9.7")]
		public static Fwupd.KeyringKind from_string (string keyring_kind);
		[Version (since = "0.9.7")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_RELEASE_URGENCY_", has_type_id = false)]
	public enum ReleaseUrgency {
		UNKNOWN,
		LOW,
		MEDIUM,
		HIGH,
		CRITICAL
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_REMOTE_KIND_", has_type_id = false)]
	public enum RemoteKind {
		UNKNOWN,
		DOWNLOAD,
		LOCAL,
		DIRECTORY
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_SECURITY_ATTR_FLAG_", has_type_id = false)]
	[Flags]
	public enum SecurityAttrFlags {
		NONE,
		SUCCESS,
		OBSOLETED,
		RUNTIME_UPDATES,
		RUNTIME_ATTESTATION,
		RUNTIME_ISSUE
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_SECURITY_ATTR_LEVEL_", has_type_id = false)]
	public enum SecurityAttrLevel {
		NONE,
		CRITICAL,
		IMPORTANT,
		THEORETICAL,
		SYSTEM_PROTECTION,
		SYSTEM_ATTESTATION
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_SECURITY_ATTR_RESULT_", has_type_id = false)]
	public enum SecurityAttrResult {
		UNKNOWN,
		ENABLED,
		NOT_ENABLED,
		VALID,
		NOT_VALID,
		LOCKED,
		NOT_LOCKED,
		ENCRYPTED,
		NOT_ENCRYPTED,
		TAINTED,
		NOT_TAINTED,
		FOUND,
		NOT_FOUND,
		SUPPORTED,
		NOT_SUPPORTED
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_SELF_SIGN_FLAG_", has_type_id = false)]
	[Flags]
	public enum SelfSignFlags {
		NONE,
		ADD_TIMESTAMP,
		ADD_CERT
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_STATUS_", has_type_id = false)]
	public enum Status {
		UNKNOWN,
		IDLE,
		LOADING,
		DECOMPRESSING,
		DEVICE_RESTART,
		DEVICE_WRITE,
		DEVICE_VERIFY,
		SCHEDULING,
		DOWNLOADING,
		DEVICE_READ,
		DEVICE_ERASE,
		WAITING_FOR_AUTH,
		DEVICE_BUSY,
		SHUTDOWN;
		[Version (since = "0.1.1")]
		public static Fwupd.Status from_string (string status);
		[Version (since = "0.1.1")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_TRUST_FLAG_", has_type_id = false)]
	[Flags]
	public enum TrustFlags {
		NONE,
		PAYLOAD,
		METADATA
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_UPDATE_STATE_", has_type_id = false)]
	public enum UpdateState {
		UNKNOWN,
		PENDING,
		SUCCESS,
		FAILED,
		NEEDS_REBOOT,
		FAILED_TRANSIENT;
		[Version (since = "0.7.0")]
		public static Fwupd.UpdateState from_string (string update_state);
		[Version (since = "0.7.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_VERSION_FORMAT_", has_type_id = false)]
	public enum VersionFormat {
		UNKNOWN,
		PLAIN,
		NUMBER,
		PAIR,
		TRIPLET,
		QUAD,
		BCD,
		INTEL_ME,
		INTEL_ME2,
		SURFACE_LEGACY,
		SURFACE,
		DELL_BIOS,
		HEX;
		[Version (since = "1.2.9")]
		public static Fwupd.VersionFormat from_string (string str);
		[Version (since = "1.2.9")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "fwupd.h", cprefix = "FWUPD_ERROR_")]
	public errordomain Error {
		INTERNAL,
		VERSION_NEWER,
		VERSION_SAME,
		ALREADY_PENDING,
		AUTH_FAILED,
		READ,
		WRITE,
		INVALID_FILE,
		NOT_FOUND,
		NOTHING_TO_DO,
		NOT_SUPPORTED,
		SIGNATURE_INVALID,
		AC_POWER_REQUIRED,
		PERMISSION_DENIED,
		BROKEN_SYSTEM,
		BATTERY_LEVEL_TOO_LOW,
		NEEDS_USER_ACTION;
		[Version (since = "0.7.0")]
		public static unowned Fwupd.Error from_string (string error);
		[Version (since = "0.1.1")]
		public static GLib.Quark quark ();
		[Version (since = "0.7.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DBUS_INTERFACE")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DBUS_PATH")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DBUS_SERVICE")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_ADD_COUNTERPART_GUIDS")]
	public const int DEVICE_FLAG_ADD_COUNTERPART_GUIDS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_ANOTHER_WRITE_REQUIRED")]
	public const int DEVICE_FLAG_ANOTHER_WRITE_REQUIRED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_BACKUP_BEFORE_INSTALL")]
	public const int DEVICE_FLAG_BACKUP_BEFORE_INSTALL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_CAN_VERIFY")]
	public const int DEVICE_FLAG_CAN_VERIFY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_CAN_VERIFY_IMAGE")]
	public const int DEVICE_FLAG_CAN_VERIFY_IMAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_DUAL_IMAGE")]
	public const int DEVICE_FLAG_DUAL_IMAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_ENSURE_SEMVER")]
	public const int DEVICE_FLAG_ENSURE_SEMVER;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_HAS_MULTIPLE_BRANCHES")]
	public const int DEVICE_FLAG_HAS_MULTIPLE_BRANCHES;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_HISTORICAL")]
	public const int DEVICE_FLAG_HISTORICAL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_IGNORE_VALIDATION")]
	public const int DEVICE_FLAG_IGNORE_VALIDATION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_INSTALL_ALL_RELEASES")]
	public const int DEVICE_FLAG_INSTALL_ALL_RELEASES;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_INSTALL_PARENT_FIRST")]
	public const int DEVICE_FLAG_INSTALL_PARENT_FIRST;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_INTERNAL")]
	public const int DEVICE_FLAG_INTERNAL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_IS_BOOTLOADER")]
	public const int DEVICE_FLAG_IS_BOOTLOADER;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_LOCKED")]
	public const int DEVICE_FLAG_LOCKED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_MD_SET_ICON")]
	public const int DEVICE_FLAG_MD_SET_ICON;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_MD_SET_NAME")]
	public const int DEVICE_FLAG_MD_SET_NAME;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_MD_SET_NAME_CATEGORY")]
	public const int DEVICE_FLAG_MD_SET_NAME_CATEGORY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_MD_SET_VERFMT")]
	public const int DEVICE_FLAG_MD_SET_VERFMT;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NEEDS_ACTIVATION")]
	public const int DEVICE_FLAG_NEEDS_ACTIVATION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NEEDS_BOOTLOADER")]
	public const int DEVICE_FLAG_NEEDS_BOOTLOADER;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NEEDS_REBOOT")]
	public const int DEVICE_FLAG_NEEDS_REBOOT;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NEEDS_SHUTDOWN")]
	public const int DEVICE_FLAG_NEEDS_SHUTDOWN;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NONE")]
	public const int DEVICE_FLAG_NONE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NOTIFIED")]
	public const int DEVICE_FLAG_NOTIFIED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NO_AUTO_INSTANCE_IDS")]
	public const int DEVICE_FLAG_NO_AUTO_INSTANCE_IDS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_NO_GUID_MATCHING")]
	public const int DEVICE_FLAG_NO_GUID_MATCHING;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_ONLY_OFFLINE")]
	public const int DEVICE_FLAG_ONLY_OFFLINE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_ONLY_SUPPORTED")]
	public const int DEVICE_FLAG_ONLY_SUPPORTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_REGISTERED")]
	public const int DEVICE_FLAG_REGISTERED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_REPORTED")]
	public const int DEVICE_FLAG_REPORTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_REQUIRE_AC")]
	public const int DEVICE_FLAG_REQUIRE_AC;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_SELF_RECOVERY")]
	public const int DEVICE_FLAG_SELF_RECOVERY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_SKIPS_RESTART")]
	public const int DEVICE_FLAG_SKIPS_RESTART;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_SUPPORTED")]
	public const int DEVICE_FLAG_SUPPORTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_TRUSTED")]
	public const int DEVICE_FLAG_TRUSTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_UPDATABLE")]
	public const int DEVICE_FLAG_UPDATABLE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_UPDATABLE_HIDDEN")]
	public const int DEVICE_FLAG_UPDATABLE_HIDDEN;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_USABLE_DURING_UPDATE")]
	public const int DEVICE_FLAG_USABLE_DURING_UPDATE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_USE_RUNTIME_VERSION")]
	public const int DEVICE_FLAG_USE_RUNTIME_VERSION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_VERSION_CHECK_REQUIRED")]
	public const int DEVICE_FLAG_VERSION_CHECK_REQUIRED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_WAIT_FOR_REPLUG")]
	public const int DEVICE_FLAG_WAIT_FOR_REPLUG;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_FLAG_WILL_DISAPPEAR")]
	public const int DEVICE_FLAG_WILL_DISAPPEAR;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_DEVICE_ID_ANY")]
	public const string DEVICE_ID_ANY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_CAPSULES_UNSUPPORTED")]
	public const int PLUGIN_FLAG_CAPSULES_UNSUPPORTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_CLEAR_UPDATABLE")]
	public const int PLUGIN_FLAG_CLEAR_UPDATABLE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_DISABLED")]
	public const int PLUGIN_FLAG_DISABLED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_EFIVAR_NOT_MOUNTED")]
	public const int PLUGIN_FLAG_EFIVAR_NOT_MOUNTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_ESP_NOT_FOUND")]
	public const int PLUGIN_FLAG_ESP_NOT_FOUND;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_FAILED_OPEN")]
	public const int PLUGIN_FLAG_FAILED_OPEN;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_LEGACY_BIOS")]
	public const int PLUGIN_FLAG_LEGACY_BIOS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_NONE")]
	public const int PLUGIN_FLAG_NONE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_NO_HARDWARE")]
	public const int PLUGIN_FLAG_NO_HARDWARE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_REQUIRE_HWID")]
	public const int PLUGIN_FLAG_REQUIRE_HWID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_UNLOCK_REQUIRED")]
	public const int PLUGIN_FLAG_UNLOCK_REQUIRED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_PLUGIN_FLAG_USER_WARNING")]
	public const int PLUGIN_FLAG_USER_WARNING;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_BLOCKED_APPROVAL")]
	public const int RELEASE_FLAG_BLOCKED_APPROVAL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_BLOCKED_VERSION")]
	public const int RELEASE_FLAG_BLOCKED_VERSION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_IS_ALTERNATE_BRANCH")]
	public const int RELEASE_FLAG_IS_ALTERNATE_BRANCH;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_IS_DOWNGRADE")]
	public const int RELEASE_FLAG_IS_DOWNGRADE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_IS_UPGRADE")]
	public const int RELEASE_FLAG_IS_UPGRADE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_NONE")]
	public const int RELEASE_FLAG_NONE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_TRUSTED_METADATA")]
	public const int RELEASE_FLAG_TRUSTED_METADATA;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RELEASE_FLAG_TRUSTED_PAYLOAD")]
	public const int RELEASE_FLAG_TRUSTED_PAYLOAD;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_APPSTREAM_ID")]
	public const string RESULT_KEY_APPSTREAM_ID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_BRANCH")]
	public const string RESULT_KEY_BRANCH;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_CATEGORIES")]
	public const string RESULT_KEY_CATEGORIES;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_CHECKSUM")]
	public const string RESULT_KEY_CHECKSUM;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_CREATED")]
	public const string RESULT_KEY_CREATED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_DESCRIPTION")]
	public const string RESULT_KEY_DESCRIPTION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_DETACH_CAPTION")]
	public const string RESULT_KEY_DETACH_CAPTION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_DETACH_IMAGE")]
	public const string RESULT_KEY_DETACH_IMAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_DETAILS_URL")]
	public const string RESULT_KEY_DETAILS_URL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_DEVICE_ID")]
	public const string RESULT_KEY_DEVICE_ID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_FILENAME")]
	public const string RESULT_KEY_FILENAME;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_FLAGS")]
	public const string RESULT_KEY_FLAGS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_FLASHES_LEFT")]
	public const string RESULT_KEY_FLASHES_LEFT;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_GUID")]
	public const string RESULT_KEY_GUID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_HOMEPAGE")]
	public const string RESULT_KEY_HOMEPAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_HSI_LEVEL")]
	public const string RESULT_KEY_HSI_LEVEL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_HSI_RESULT")]
	public const string RESULT_KEY_HSI_RESULT;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_ICON")]
	public const string RESULT_KEY_ICON;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_INSTALL_DURATION")]
	public const string RESULT_KEY_INSTALL_DURATION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_INSTANCE_IDS")]
	public const string RESULT_KEY_INSTANCE_IDS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_ISSUES")]
	public const string RESULT_KEY_ISSUES;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_LICENSE")]
	public const string RESULT_KEY_LICENSE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_LOCATIONS")]
	public const string RESULT_KEY_LOCATIONS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_METADATA")]
	public const string RESULT_KEY_METADATA;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_MODIFIED")]
	public const string RESULT_KEY_MODIFIED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_NAME")]
	public const string RESULT_KEY_NAME;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_NAME_VARIANT_SUFFIX")]
	public const string RESULT_KEY_NAME_VARIANT_SUFFIX;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_PARENT_DEVICE_ID")]
	public const string RESULT_KEY_PARENT_DEVICE_ID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_PLUGIN")]
	public const string RESULT_KEY_PLUGIN;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_PROTOCOL")]
	public const string RESULT_KEY_PROTOCOL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_RELEASE")]
	public const string RESULT_KEY_RELEASE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_REMOTE_ID")]
	public const string RESULT_KEY_REMOTE_ID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_SERIAL")]
	public const string RESULT_KEY_SERIAL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_SIZE")]
	public const string RESULT_KEY_SIZE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_SOURCE_URL")]
	public const string RESULT_KEY_SOURCE_URL;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_STATUS")]
	public const string RESULT_KEY_STATUS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_SUMMARY")]
	public const string RESULT_KEY_SUMMARY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_TRUST_FLAGS")]
	public const string RESULT_KEY_TRUST_FLAGS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_UPDATE_ERROR")]
	public const string RESULT_KEY_UPDATE_ERROR;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_UPDATE_IMAGE")]
	public const string RESULT_KEY_UPDATE_IMAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_UPDATE_MESSAGE")]
	public const string RESULT_KEY_UPDATE_MESSAGE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_UPDATE_STATE")]
	public const string RESULT_KEY_UPDATE_STATE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_URGENCY")]
	public const string RESULT_KEY_URGENCY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_URI")]
	public const string RESULT_KEY_URI;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VENDOR")]
	public const string RESULT_KEY_VENDOR;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VENDOR_ID")]
	public const string RESULT_KEY_VENDOR_ID;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION")]
	public const string RESULT_KEY_VERSION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_BOOTLOADER")]
	public const string RESULT_KEY_VERSION_BOOTLOADER;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_BOOTLOADER_RAW")]
	public const string RESULT_KEY_VERSION_BOOTLOADER_RAW;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_FORMAT")]
	public const string RESULT_KEY_VERSION_FORMAT;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_LOWEST")]
	public const string RESULT_KEY_VERSION_LOWEST;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_LOWEST_RAW")]
	public const string RESULT_KEY_VERSION_LOWEST_RAW;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_RESULT_KEY_VERSION_RAW")]
	public const string RESULT_KEY_VERSION_RAW;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_ACPI_DMAR")]
	public const string SECURITY_ATTR_ID_ACPI_DMAR;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_ENCRYPTED_RAM")]
	public const string SECURITY_ATTR_ID_ENCRYPTED_RAM;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_FWUPD_ATTESTATION")]
	public const string SECURITY_ATTR_ID_FWUPD_ATTESTATION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_FWUPD_PLUGINS")]
	public const string SECURITY_ATTR_ID_FWUPD_PLUGINS;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_FWUPD_UPDATES")]
	public const string SECURITY_ATTR_ID_FWUPD_UPDATES;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_BOOTGUARD_ACM")]
	public const string SECURITY_ATTR_ID_INTEL_BOOTGUARD_ACM;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_BOOTGUARD_ENABLED")]
	public const string SECURITY_ATTR_ID_INTEL_BOOTGUARD_ENABLED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_BOOTGUARD_OTP")]
	public const string SECURITY_ATTR_ID_INTEL_BOOTGUARD_OTP;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_BOOTGUARD_POLICY")]
	public const string SECURITY_ATTR_ID_INTEL_BOOTGUARD_POLICY;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_BOOTGUARD_VERIFIED")]
	public const string SECURITY_ATTR_ID_INTEL_BOOTGUARD_VERIFIED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_CET_ACTIVE")]
	public const string SECURITY_ATTR_ID_INTEL_CET_ACTIVE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_CET_ENABLED")]
	public const string SECURITY_ATTR_ID_INTEL_CET_ENABLED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_DCI_ENABLED")]
	public const string SECURITY_ATTR_ID_INTEL_DCI_ENABLED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_DCI_LOCKED")]
	public const string SECURITY_ATTR_ID_INTEL_DCI_LOCKED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_INTEL_SMAP")]
	public const string SECURITY_ATTR_ID_INTEL_SMAP;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_IOMMU")]
	public const string SECURITY_ATTR_ID_IOMMU;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_KERNEL_LOCKDOWN")]
	public const string SECURITY_ATTR_ID_KERNEL_LOCKDOWN;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_KERNEL_SWAP")]
	public const string SECURITY_ATTR_ID_KERNEL_SWAP;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_KERNEL_TAINTED")]
	public const string SECURITY_ATTR_ID_KERNEL_TAINTED;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_MEI_MANUFACTURING_MODE")]
	public const string SECURITY_ATTR_ID_MEI_MANUFACTURING_MODE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_MEI_OVERRIDE_STRAP")]
	public const string SECURITY_ATTR_ID_MEI_OVERRIDE_STRAP;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_MEI_VERSION")]
	public const string SECURITY_ATTR_ID_MEI_VERSION;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_SPI_BIOSWE")]
	public const string SECURITY_ATTR_ID_SPI_BIOSWE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_SPI_BLE")]
	public const string SECURITY_ATTR_ID_SPI_BLE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_SPI_SMM_BWP")]
	public const string SECURITY_ATTR_ID_SPI_SMM_BWP;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_SUSPEND_TO_IDLE")]
	public const string SECURITY_ATTR_ID_SUSPEND_TO_IDLE;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_SUSPEND_TO_RAM")]
	public const string SECURITY_ATTR_ID_SUSPEND_TO_RAM;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_TPM_RECONSTRUCTION_PCR0")]
	public const string SECURITY_ATTR_ID_TPM_RECONSTRUCTION_PCR0;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_TPM_VERSION_20")]
	public const string SECURITY_ATTR_ID_TPM_VERSION_20;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_UEFI_PK")]
	public const string SECURITY_ATTR_ID_UEFI_PK;
	[CCode (cheader_filename = "fwupd.h", cname = "FWUPD_SECURITY_ATTR_ID_UEFI_SECUREBOOT")]
	public const string SECURITY_ATTR_ID_UEFI_SECUREBOOT;
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.0.4")]
	public static string build_history_report_json (GLib.GenericArray<Fwupd.Device> devices) throws GLib.Error;
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.0.4")]
	public static string build_machine_id (string salt) throws GLib.Error;
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.0.3")]
	public static string build_user_agent (string package_name, string package_version);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.9.3")]
	public static string checksum_format_for_display (string checksum);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.9.4")]
	public static unowned string checksum_get_best (GLib.GenericArray<string> checksums);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.9.4")]
	public static unowned string checksum_get_by_kind (GLib.GenericArray<string> checksums, GLib.ChecksumType kind);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.9.3")]
	public static GLib.ChecksumType checksum_guess_kind (string checksum);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.4.5")]
	public static Fwupd.FeatureFlags feature_flag_from_string (string feature_flag);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.4.5")]
	public static unowned string feature_flag_to_string (Fwupd.FeatureFlags feature_flag);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.0.7")]
	public static GLib.HashTable<weak string,weak string> get_os_release () throws GLib.Error;
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.2.5")]
	public static bool guid_from_string (string? guidstr, uint8 guid, Fwupd.GuidFlags flags) throws GLib.Error;
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.2.5")]
	public static string guid_hash_data (uint8 data, size_t datasz, Fwupd.GuidFlags flags);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.2.5")]
	public static string guid_hash_string (string str);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.2.5")]
	public static bool guid_is_valid (string guid);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "1.2.5")]
	public static string guid_to_string (uint8 guid, Fwupd.GuidFlags flags);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.7.0")]
	public static Fwupd.TrustFlags trust_flag_from_string (string trust_flag);
	[CCode (cheader_filename = "fwupd.h")]
	[Version (since = "0.7.0")]
	public static unowned string trust_flag_to_string (Fwupd.TrustFlags trust_flag);
}
