/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SignatureSchemeInfo {
    static final int historical_rsa_md5 = 257;
    static final int historical_rsa_sha224 = 769;
    static final int historical_dsa_sha1 = 514;
    static final int historical_dsa_sha224 = 770;
    static final int historical_dsa_sha256 = 1026;
    static final int historical_ecdsa_sha224 = 771;
    private final int signatureScheme;
    private final String name;
    private final String jcaSignatureAlgorithm;
    private final String keyAlgorithm;
    private final AlgorithmParameters algorithmParameters;
    private final boolean enabled;

    static String[] getJcaSignatureAlgorithms(Collection<SignatureSchemeInfo> collection) {
        if (null == collection) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : collection) {
            arrayList.add(signatureSchemeInfo.getJcaSignatureAlgorithm());
        }
        return arrayList.toArray(new String[0]);
    }

    static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int n) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException();
        }
        short s = SignatureScheme.getHashAlgorithm(n);
        short s2 = SignatureScheme.getSignatureAlgorithm(n);
        return SignatureAndHashAlgorithm.getInstance(s, s2);
    }

    static int getSignatureScheme(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (null == signatureAndHashAlgorithm) {
            throw new NullPointerException();
        }
        short s = signatureAndHashAlgorithm.getHash();
        short s2 = signatureAndHashAlgorithm.getSignature();
        return (s & 0xFF) << 8 | s2 & 0xFF;
    }

    SignatureSchemeInfo(int n, String string, String string2, String string3, AlgorithmParameters algorithmParameters, boolean bl) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException();
        }
        this.signatureScheme = n;
        this.name = string;
        this.jcaSignatureAlgorithm = string2;
        this.keyAlgorithm = string3;
        this.algorithmParameters = algorithmParameters;
        this.enabled = bl;
    }

    short getHashAlgorithm() {
        return SignatureScheme.getHashAlgorithm(this.signatureScheme);
    }

    String getJcaSignatureAlgorithm() {
        return this.jcaSignatureAlgorithm;
    }

    String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    String getName() {
        return this.name;
    }

    short getSignatureAlgorithm() {
        return SignatureScheme.getSignatureAlgorithm(this.signatureScheme);
    }

    SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return SignatureSchemeInfo.getSignatureAndHashAlgorithm(this.signatureScheme);
    }

    int getSignatureScheme() {
        return this.signatureScheme;
    }

    boolean isActive(BCAlgorithmConstraints bCAlgorithmConstraints) {
        return this.enabled && this.isPermittedBy(bCAlgorithmConstraints);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isPermittedBy(BCAlgorithmConstraints bCAlgorithmConstraints) {
        Set<BCCryptoPrimitive> set = JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC;
        return bCAlgorithmConstraints.permits(set, this.name, null) && bCAlgorithmConstraints.permits(set, this.keyAlgorithm, null) && bCAlgorithmConstraints.permits(set, this.jcaSignatureAlgorithm, this.algorithmParameters);
    }

    public String toString() {
        return this.name + "(0x" + Integer.toHexString(this.signatureScheme) + ")";
    }
}

