from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.Message import *
from OCC.Core.Geom2d import *
from OCC.Core.Geom import *
from OCC.Core.TopLoc import *
from OCC.Core.TopAbs import *

BinTools_LocationSetPtr = NewType('BinTools_LocationSetPtr', BinTools_LocationSet)

class bintools:
	@overload
	@staticmethod
	def Read(theShape: TopoDS_Shape, theFile: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
	@overload
	@staticmethod
	def Write(theShape: TopoDS_Shape, theFile: str, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

class BinTools_Curve2dSet:
	def __init__(self) -> None: ...
	def Add(self, C: Geom2d_Curve) -> int: ...
	def Clear(self) -> None: ...
	def Curve2d(self, I: int) -> Geom2d_Curve: ...
	def Index(self, C: Geom2d_Curve) -> int: ...

class BinTools_CurveSet:
	def __init__(self) -> None: ...
	def Add(self, C: Geom_Curve) -> int: ...
	def Clear(self) -> None: ...
	def Curve(self, I: int) -> Geom_Curve: ...
	def Index(self, C: Geom_Curve) -> int: ...

class BinTools_LocationSet:
	def __init__(self) -> None: ...
	def Add(self, L: TopLoc_Location) -> int: ...
	def Clear(self) -> None: ...
	def Index(self, L: TopLoc_Location) -> int: ...
	def Location(self, I: int) -> TopLoc_Location: ...
	def NbLocations(self) -> int: ...

class BinTools_ShapeSet:
	def __init__(self, isWithTriangles: Optional[bool] = False) -> None: ...
	def Add(self, S: TopoDS_Shape) -> int: ...
	def AddGeometry(self, S: TopoDS_Shape) -> None: ...
	def AddShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
	def ChangeLocations(self) -> BinTools_LocationSet: ...
	def Clear(self) -> None: ...
	def FormatNb(self) -> int: ...
	def Index(self, S: TopoDS_Shape) -> int: ...
	def IsWithTriangles(self) -> bool: ...
	def Locations(self) -> BinTools_LocationSet: ...
	def NbShapes(self) -> int: ...
	def SetFormatNb(self, theFormatNb: int) -> None: ...
	def SetWithTriangles(self, isWithTriangles: bool) -> None: ...
	def Shape(self, I: int) -> TopoDS_Shape: ...

class BinTools_SurfaceSet:
	def __init__(self) -> None: ...
	def Add(self, S: Geom_Surface) -> int: ...
	def Clear(self) -> None: ...
	def Index(self, S: Geom_Surface) -> int: ...
	def Surface(self, I: int) -> Geom_Surface: ...

# harray1 classes
# harray2 classes
# hsequence classes

bintools_GetBool = bintools.GetBool
bintools_GetExtChar = bintools.GetExtChar
bintools_GetInteger = bintools.GetInteger
bintools_GetReal = bintools.GetReal
bintools_GetShortReal = bintools.GetShortReal
bintools_PutBool = bintools.PutBool
bintools_PutExtChar = bintools.PutExtChar
bintools_PutInteger = bintools.PutInteger
bintools_PutReal = bintools.PutReal
bintools_PutShortReal = bintools.PutShortReal
bintools_Read = bintools.Read
bintools_Read = bintools.Read
bintools_Write = bintools.Write
bintools_Write = bintools.Write
BinTools_Curve2dSet_ReadCurve2d = BinTools_Curve2dSet.ReadCurve2d
BinTools_Curve2dSet_WriteCurve2d = BinTools_Curve2dSet.WriteCurve2d
BinTools_CurveSet_ReadCurve = BinTools_CurveSet.ReadCurve
BinTools_CurveSet_WriteCurve = BinTools_CurveSet.WriteCurve
BinTools_SurfaceSet_ReadSurface = BinTools_SurfaceSet.ReadSurface
BinTools_SurfaceSet_WriteSurface = BinTools_SurfaceSet.WriteSurface
