/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.math.RoundingMode;
import java.text.DecimalFormat;

public class RealTick {
    protected static final int MIN_PIXELS = 10;
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private final double min;
    private final double max;
    private final double minTick;
    private final double maxTick;
    private final double tick;
    private final int exponent;

    public RealTick(double min, double max, double minTick, double maxTick, double tick, int exponent) {
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        this.min = min;
        this.max = max;
        this.minTick = minTick;
        this.maxTick = maxTick;
        this.tick = tick;
        this.exponent = exponent;
    }

    public static RealTick create(double min, double max, int width) {
        double tick;
        int tickPixels;
        double diff = Math.abs(max - min);
        double minTick = diff / 100.0;
        int exponent = (int)Math.round(Math.log10(minTick));
        int minTickPixels = 10;
        int mult = 1;
        do {
            tick = exponent > 0 ? Math.pow(10.0, Math.abs(exponent)) : 1.0 / Math.pow(10.0, Math.abs(exponent));
            double countTicks = diff / (tick *= (double)mult);
            tickPixels = (int)Math.round((double)width / countTicks);
            if (mult == 1) {
                mult = 5;
                continue;
            }
            ++exponent;
            mult = 1;
        } while (tickPixels < minTickPixels);
        double minStart = (double)((int)(min / tick)) * tick;
        double maxEnd = (double)((int)Math.ceil(max / tick)) * tick;
        return new RealTick(min, max, minStart, maxEnd, tick, exponent);
    }

    public int getNumberTicks() {
        return (int)(Math.abs(this.maxTick - this.minTick) / this.tick);
    }

    public double getTickPosition(int index) {
        return ((double)index * this.tick - (this.min - this.minTick)) / (this.max - this.min);
    }

    public int getTickRank(int index) {
        double t = this.minTick + (double)index * this.tick;
        if ((t = this.round(t, this.exponent >= 0 ? 1 : Math.abs(this.exponent))) % (this.tick * 10.0) == 0.0) {
            return 2;
        }
        if (t % (this.tick * 5.0) == 0.0) {
            return 1;
        }
        return 0;
    }

    public String getTickValue(int index) {
        double val = this.minTick + this.tick * (double)index;
        this.decimalFormat.setMaximumFractionDigits(Math.abs(this.exponent) + 1);
        return this.decimalFormat.format(val);
    }

    public int getTickPixelPosition(int index, int width) {
        double pos = this.getTickPosition(index);
        return (int)((double)width * pos);
    }

    public double getMax() {
        return this.max;
    }

    public double getMaxTick() {
        return this.maxTick;
    }

    public double getMin() {
        return this.min;
    }

    public double getMinTick() {
        return this.minTick;
    }

    public double getTick() {
        return this.tick;
    }

    public int getExponent() {
        return this.exponent;
    }

    private double round(double valueToRound, int numberOfDecimalPlaces) {
        double multipicationFactor = Math.pow(10.0, numberOfDecimalPlaces);
        double interestedInZeroDPs = valueToRound * multipicationFactor;
        return (double)Math.round(interestedInZeroDPs) / multipicationFactor;
    }
}

