/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gephi.appearance.plugin.palette.Palette;
import org.gephi.appearance.plugin.palette.PaletteManager;
import org.gephi.appearance.plugin.palette.Preset;
import org.openide.util.NbBundle;

public class PaletteGeneratorPanel
extends JPanel {
    private Preset selectedPreset;
    private Palette selectedPalette;
    private JPanel centerPanel;
    private JScrollPane centerScrollPanel;
    private JLabel colorCountLabel;
    private JTable colorTable;
    private JButton generateButton;
    private JLabel labelColorCount;
    private JLabel labelPreset;
    private JSpinner limitColorSpinner;
    private JCheckBox limitColorsCheckbox;
    private JComboBox presetCombo;

    public PaletteGeneratorPanel() {
        this.initComponents();
        DefaultComboBoxModel<Preset> model = new DefaultComboBoxModel<Preset>();
        for (Preset preset : PaletteManager.getInstance().getPresets()) {
            model.addElement(preset);
        }
        this.selectedPreset = (Preset)model.getElementAt(0);
        this.presetCombo.setModel(model);
        this.limitColorsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaletteGeneratorPanel.this.limitColorSpinner.setEnabled(true);
                } else {
                    PaletteGeneratorPanel.this.limitColorSpinner.setEnabled(false);
                }
            }
        });
        this.presetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PaletteGeneratorPanel.this.presetCombo.getSelectedItem() != PaletteGeneratorPanel.this.selectedPreset) {
                    PaletteGeneratorPanel.this.selectedPreset = (Preset)PaletteGeneratorPanel.this.presetCombo.getSelectedItem();
                }
            }
        });
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteGeneratorPanel.this.generate();
            }
        });
    }

    private void generate() {
        int colorCount;
        int paletteCount = colorCount = Integer.parseInt(this.colorCountLabel.getText());
        if (this.limitColorsCheckbox.isSelected()) {
            paletteCount = ((Number)this.limitColorSpinner.getValue()).intValue();
        }
        this.selectedPalette = PaletteManager.getInstance().generatePalette(paletteCount, this.selectedPreset);
        if (paletteCount < colorCount) {
            Color[] cols = Arrays.copyOf(this.selectedPalette.getColors(), colorCount);
            for (int i = paletteCount; i < cols.length; ++i) {
                cols[i] = Color.LIGHT_GRAY;
            }
            this.selectedPalette = new Palette(cols);
        }
        Object[] columnNames = new String[]{"Color"};
        DefaultTableModel model = new DefaultTableModel(columnNames, colorCount){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.colorTable.setModel(model);
        TableColumn colorCol = this.colorTable.getColumnModel().getColumn(0);
        colorCol.setCellRenderer(new ColorCellRenderer());
        int row = 0;
        for (Color c : this.selectedPalette.getColors()) {
            model.setValueAt(c, row++, 0);
        }
    }

    public void setup(int colorsCount) {
        this.colorCountLabel.setText(String.valueOf(colorsCount));
        this.limitColorSpinner.setModel(new SpinnerNumberModel(Math.min(colorsCount, 8), 1, colorsCount, 1));
    }

    public Palette getSelectedPalette() {
        return this.selectedPalette;
    }

    private void initComponents() {
        this.labelColorCount = new JLabel();
        this.colorCountLabel = new JLabel();
        this.labelPreset = new JLabel();
        this.presetCombo = new JComboBox();
        this.generateButton = new JButton();
        this.centerScrollPanel = new JScrollPane();
        this.centerPanel = new JPanel();
        this.colorTable = new JTable();
        this.limitColorsCheckbox = new JCheckBox();
        this.limitColorSpinner = new JSpinner();
        this.labelColorCount.setText(NbBundle.getMessage(PaletteGeneratorPanel.class, (String)"PaletteGeneratorPanel.labelColorCount.text"));
        this.labelPreset.setText(NbBundle.getMessage(PaletteGeneratorPanel.class, (String)"PaletteGeneratorPanel.labelPreset.text"));
        this.generateButton.setText(NbBundle.getMessage(PaletteGeneratorPanel.class, (String)"PaletteGeneratorPanel.generateButton.text"));
        this.centerScrollPanel.setBorder(null);
        this.centerScrollPanel.setOpaque(false);
        this.centerPanel.setLayout(new GridBagLayout());
        this.colorTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.colorTable.setOpaque(false);
        this.colorTable.setRowHeight(22);
        this.colorTable.setSelectionMode(0);
        this.colorTable.setShowHorizontalLines(false);
        this.colorTable.setShowVerticalLines(false);
        this.colorTable.setTableHeader(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.colorTable, gridBagConstraints);
        this.centerScrollPanel.setViewportView(this.centerPanel);
        this.limitColorsCheckbox.setSelected(true);
        this.limitColorsCheckbox.setText(NbBundle.getMessage(PaletteGeneratorPanel.class, (String)"PaletteGeneratorPanel.limitColorsCheckbox.text"));
        this.limitColorsCheckbox.setHorizontalTextPosition(2);
        this.limitColorSpinner.setModel(new SpinnerNumberModel((Number)8, Integer.valueOf(1), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.centerScrollPanel).addGroup(layout.createSequentialGroup().addComponent(this.presetCombo, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 73, Short.MAX_VALUE).addComponent(this.generateButton)).addGroup(layout.createSequentialGroup().addComponent(this.labelPreset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.limitColorSpinner, -2, 60, -2)).addGroup(layout.createSequentialGroup().addComponent(this.labelColorCount).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colorCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.limitColorsCheckbox))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelColorCount).addComponent(this.colorCountLabel)).addComponent(this.limitColorsCheckbox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.labelPreset)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.limitColorSpinner, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.presetCombo, -2, -1, -2).addComponent(this.generateButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerScrollPanel, -1, 191, Short.MAX_VALUE).addContainerGap()));
    }

    class ColorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color c = (Color)value;
            this.setBackground(c);
            return this;
        }
    }
}

