/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public final class DefaultDependencyManager
implements DependencyManager {
    private final Map<Object, String> managedVersions;
    private final Map<Object, String> managedScopes;
    private final Map<Object, Boolean> managedOptionals;
    private final Map<Object, String> managedLocalPaths;
    private final Map<Object, Collection<Exclusion>> managedExclusions;
    private int hashCode;

    public DefaultDependencyManager() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private DefaultDependencyManager(Map<Object, String> managedVersions, Map<Object, String> managedScopes, Map<Object, Boolean> managedOptionals, Map<Object, String> managedLocalPaths, Map<Object, Collection<Exclusion>> managedExclusions) {
        this.managedVersions = managedVersions;
        this.managedScopes = managedScopes;
        this.managedOptionals = managedOptionals;
        this.managedLocalPaths = managedLocalPaths;
        this.managedExclusions = managedExclusions;
    }

    @Override
    public DependencyManager deriveChildManager(DependencyCollectionContext context) {
        Map<Object, String> versions = this.managedVersions;
        Map<Object, String> scopes = this.managedScopes;
        Map<Object, Boolean> optionals = this.managedOptionals;
        Map<Object, String> localPaths = this.managedLocalPaths;
        Map<Object, Collection<Exclusion>> exclusions = this.managedExclusions;
        for (Dependency managedDependency : context.getManagedDependencies()) {
            Collection<Exclusion> managed;
            String localPath;
            Boolean optional;
            String scope;
            Artifact artifact = managedDependency.getArtifact();
            Object key2 = this.getKey(artifact);
            String version = artifact.getVersion();
            if (version.length() > 0 && !versions.containsKey(key2)) {
                if (versions == this.managedVersions) {
                    versions = new HashMap<Object, String>(this.managedVersions);
                }
                versions.put(key2, version);
            }
            if ((scope = managedDependency.getScope()).length() > 0 && !scopes.containsKey(key2)) {
                if (scopes == this.managedScopes) {
                    scopes = new HashMap<Object, String>(this.managedScopes);
                }
                scopes.put(key2, scope);
            }
            if ((optional = managedDependency.getOptional()) != null && !optionals.containsKey(key2)) {
                if (optionals == this.managedOptionals) {
                    optionals = new HashMap<Object, Boolean>(this.managedOptionals);
                }
                optionals.put(key2, optional);
            }
            if ((localPath = managedDependency.getArtifact().getProperty("localPath", null)) != null && !localPaths.containsKey(key2)) {
                if (localPaths == this.managedLocalPaths) {
                    localPaths = new HashMap<Object, String>(this.managedLocalPaths);
                }
                localPaths.put(key2, localPath);
            }
            if (managedDependency.getExclusions().isEmpty()) continue;
            if (exclusions == this.managedExclusions) {
                exclusions = new HashMap<Object, Collection<Exclusion>>(this.managedExclusions);
            }
            if ((managed = exclusions.get(key2)) == null) {
                managed = new LinkedHashSet<Exclusion>();
                exclusions.put(key2, managed);
            }
            managed.addAll(managedDependency.getExclusions());
        }
        return new DefaultDependencyManager(versions, scopes, optionals, localPaths, exclusions);
    }

    @Override
    public DependencyManagement manageDependency(Dependency dependency) {
        Collection<Exclusion> exclusions;
        Boolean optional;
        String localPath;
        String scope;
        DependencyManagement management = null;
        Object key2 = this.getKey(dependency.getArtifact());
        String version = this.managedVersions.get(key2);
        if (version != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            management.setVersion(version);
        }
        if ((scope = this.managedScopes.get(key2)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            management.setScope(scope);
            if (!"system".equals(scope) && dependency.getArtifact().getProperty("localPath", null) != null) {
                HashMap<String, String> properties = new HashMap<String, String>(dependency.getArtifact().getProperties());
                properties.remove("localPath");
                management.setProperties(properties);
            }
        }
        if ((scope != null && "system".equals(scope) || scope == null && "system".equals(dependency.getScope())) && (localPath = this.managedLocalPaths.get(key2)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            HashMap<String, String> properties = new HashMap<String, String>(dependency.getArtifact().getProperties());
            properties.put("localPath", localPath);
            management.setProperties(properties);
        }
        if ((optional = this.managedOptionals.get(key2)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            management.setOptional(optional);
        }
        if ((exclusions = this.managedExclusions.get(key2)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            LinkedHashSet<Exclusion> result = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            result.addAll(exclusions);
            management.setExclusions(result);
        }
        return management;
    }

    private Object getKey(Artifact a) {
        return new Key(a);
    }

    public boolean equals(Object obj) {
        boolean equal = obj instanceof DefaultDependencyManager;
        if (equal) {
            DefaultDependencyManager that = (DefaultDependencyManager)obj;
            equal = Objects.equals(this.managedVersions, that.managedVersions) && Objects.equals(this.managedScopes, that.managedScopes) && Objects.equals(this.managedOptionals, that.managedOptionals) && Objects.equals(this.managedExclusions, that.managedExclusions);
        }
        return equal;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.managedVersions, this.managedScopes, this.managedOptionals, this.managedExclusions);
        }
        return this.hashCode;
    }

    static class Key {
        private final Artifact artifact;
        private final int hashCode;

        Key(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = Objects.hash(artifact.getGroupId(), artifact.getArtifactId());
        }

        public boolean equals(Object obj) {
            boolean equal = obj instanceof Key;
            if (equal) {
                Key that = (Key)obj;
                return Objects.equals(this.artifact.getArtifactId(), that.artifact.getArtifactId()) && Objects.equals(this.artifact.getGroupId(), that.artifact.getGroupId()) && Objects.equals(this.artifact.getExtension(), that.artifact.getExtension()) && Objects.equals(this.artifact.getClassifier(), that.artifact.getClassifier());
            }
            return equal;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

