/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorMiddle;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class FtileCircleStop
extends AbstractFtile {
    private static final int SIZE = 22;
    private final HColor backColor;
    private final Swimlane swimlane;
    private double shadowing;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileCircleStop(ISkinParam skinParam, HColor backColor, Swimlane swimlane, Style style) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
        if (UseStyle.useBetaStyle()) {
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else if (this.skinParam().shadowing(null)) {
            this.shadowing = 3.0;
        }
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(22.0, 22.0);
        circle.setDeltaShadow(this.shadowing);
        ug.apply(this.backColor).apply(HColorUtils.WHITE.bg()).draw(circle);
        double delta = 5.0;
        UEllipse circleSmall = new UEllipse(12.0, 12.0);
        ug.apply(new HColorMiddle(this.backColor, HColorUtils.WHITE)).apply(this.backColor.bg()).apply(new UTranslate(5.0, 5.0)).draw(circleSmall);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(22.0, 22.0, 11.0, 0.0);
    }
}

