/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.geom.AbstractPolyline;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.PolylineBreakeable;

public class SpiderWeb {
    private final int pointsInCircle = 16;
    private int nbRow;
    private int nbCol;
    private final int widthCell;
    private final int heightCell;
    private final int xMargin = 50;
    private final int yMargin = 50;
    private final List<PolylineBreakeable> lines = new ArrayList<PolylineBreakeable>();

    public SpiderWeb(int widthCell, int heightCell) {
        Log.info("widthCell=" + widthCell + " heightCell=" + heightCell);
        this.widthCell = widthCell;
        this.heightCell = heightCell;
    }

    public Point2DInt getMainPoint(int row, int col) {
        return new Point2DInt(col * (this.widthCell + 50), row * (this.heightCell + 50));
    }

    public Collection<Point2DInt> getHangPoints(int row, int col) {
        ArrayList<Point2DInt> result = new ArrayList<Point2DInt>();
        int dist = (int)Math.round(Math.sqrt(this.widthCell * this.widthCell + this.heightCell * this.heightCell) / 10.0);
        for (int i = 0; i < 16; ++i) {
            Point2DInt main = this.getMainPoint(row, col);
            int x = main.getXint();
            int y = main.getYint();
            if (i == 0) {
                result.add(new Point2DInt(x + dist, y));
                continue;
            }
            if (i == 4) {
                result.add(new Point2DInt(x, y + dist));
                continue;
            }
            if (i == 8) {
                result.add(new Point2DInt(x - dist, y));
                continue;
            }
            if (i == 12) {
                result.add(new Point2DInt(x, y - dist));
                continue;
            }
            double angle = Math.PI * 2 * (double)i / 16.0;
            double x1 = (double)x + (double)dist * Math.cos(angle);
            double y1 = (double)y + (double)dist * Math.sin(angle);
            result.add(new Point2DInt((int)Math.round(x1), (int)Math.round(y1)));
        }
        return result;
    }

    public PolylineBreakeable addPolyline(int row1, int col1, int row2, int col2) {
        PolylineBreakeable result = this.computePolyline(row1, col1, row2, col2);
        if (result != null) {
            this.lines.add(result);
        }
        return result;
    }

    private PolylineBreakeable computePolyline(int row1, int col1, int row2, int col2) {
        PolylineBreakeable direct;
        if (row1 > this.nbRow) {
            this.nbRow = row1;
        }
        if (row2 > this.nbRow) {
            this.nbRow = row2;
        }
        if (col1 > this.nbCol) {
            this.nbCol = col1;
        }
        if (col2 > this.nbCol) {
            this.nbCol = col2;
        }
        if (this.directLinkPossibleForGeometry(row1, col1, row2, col2) && this.isCompatible(direct = new PolylineBreakeable(this.getMainPoint(row1, col1), this.getMainPoint(row2, col2)))) {
            return direct;
        }
        return this.bestLevel1Line(row1, col1, row2, col2);
    }

    private boolean isCompatible(PolylineBreakeable toTest) {
        for (PolylineBreakeable p : this.lines) {
            if (!p.doesTouch(toTest)) continue;
            return false;
        }
        return true;
    }

    private PolylineBreakeable bestLevel1Line(int row1, int col1, int row2, int col2) {
        AbstractPolyline result = null;
        for (int u = 5; u <= 95; u += 5) {
            for (int d = -200; d <= 200; d += 5) {
                PolylineBreakeable cur = new PolylineBreakeable(this.getMainPoint(row1, col1), this.getMainPoint(row2, col2));
                cur.insertBetweenPoint(u, d);
                if (result != null && !(cur.getLength() < result.getLength()) || !this.isCompatible(cur)) continue;
                result = cur;
            }
        }
        return result;
    }

    boolean directLinkPossibleForGeometry(int row1, int col1, int row2, int col2) {
        int rowMin = Math.min(row1, row2);
        int rowMax = Math.max(row1, row2);
        int colMin = Math.min(col1, col2);
        int colMax = Math.max(col1, col2);
        LineSegmentInt seg = new LineSegmentInt(col1, row1, col2, row2);
        for (int r = rowMin; r <= rowMax; ++r) {
            for (int c = colMin; c <= colMax; ++c) {
                if (r == row1 && c == col1 || r == row2 && c == col2 || !seg.containsPoint(new Point2DInt(c, r))) continue;
                return false;
            }
        }
        return true;
    }

    final int getPointsInCircle() {
        return 16;
    }
}

