/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class HtmlColorAndStyle {
    private final HColor arrowHeadColor;
    private final HColor arrowColor;
    private final LinkStyle style;

    public String toString() {
        return this.arrowColor + " " + this.style;
    }

    public HtmlColorAndStyle(HColor color, HColor arrowHeadColor) {
        this(color, LinkStyle.NORMAL(), arrowHeadColor);
    }

    public HtmlColorAndStyle(HColor arrowColor, LinkStyle style, HColor arrowHeadColor) {
        if (arrowColor == null) {
            throw new IllegalArgumentException();
        }
        this.arrowColor = arrowColor;
        this.arrowHeadColor = arrowHeadColor == null ? arrowColor : arrowHeadColor;
        this.style = style;
    }

    public HColor getArrowColor() {
        return this.arrowColor;
    }

    public HColor getArrowHeadColor() {
        return this.arrowHeadColor;
    }

    public LinkStyle getStyle() {
        return this.style;
    }

    public static final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public static HtmlColorAndStyle build(ISkinParam skinParam, String definition) {
        HColor arrowColor;
        Object style;
        HColor arrowHeadColor = null;
        if (UseStyle.useBetaStyle()) {
            style = HtmlColorAndStyle.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
            arrowColor = ((Style)style).value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        } else {
            arrowColor = Rainbow.build((ISkinParam)skinParam).getColors().get((int)0).arrowColor;
            arrowColor = Rainbow.build((ISkinParam)skinParam).getColors().get((int)0).arrowHeadColor;
        }
        style = LinkStyle.NORMAL();
        HColorSet set = skinParam.getIHtmlColorSet();
        for (String s : definition.split(",")) {
            LinkStyle tmpStyle = LinkStyle.fromString1(s);
            if (!tmpStyle.isNormal()) {
                style = tmpStyle;
                continue;
            }
            HColor tmpColor = set.getColorIfValid(s);
            if (tmpColor == null) continue;
            arrowColor = tmpColor;
        }
        return new HtmlColorAndStyle(arrowColor, (LinkStyle)style, arrowHeadColor);
    }
}

