/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ElementButton
extends AbstractElementText
implements Element {
    private final double stroke = 2.5;
    private final double marginX = 2.0;
    private final double marginY = 2.0;

    public ElementButton(String text, UFont font, ISkinSimple spriteContainer) {
        super(text, font, true, spriteContainer);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        Dimension2D dim = this.getTextDimensionAt(stringBounder, x + 2.5 + 2.0);
        dim = Dimension2DDouble.delta(dim, 4.0, 4.0);
        return Dimension2DDouble.delta(dim, 5.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        Dimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(new UStroke(2.5));
        ug = ug.apply(HColorSet.instance().getColorIfValid("#EEEEEE").bg());
        ug.apply(new UTranslate(2.5, 2.5)).draw(new URectangle(dim.getWidth() - 5.0, dim.getHeight() - 5.0).rounded(10.0));
        Dimension2D dimPureText = this.getPureTextDimension(ug.getStringBounder());
        this.drawText(ug, (dim.getWidth() - dimPureText.getWidth()) / 2.0, 4.5);
    }
}

