/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.owlxml.parser.OWLElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

class OWLLiteralElementHandler
extends OWLElementHandler<OWLLiteral> {
    OWLLiteral literal;
    IRI iri;
    String lang;

    OWLLiteralElementHandler(@Nonnull OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    void startElement(String name) {
        super.startElement(name);
    }

    @Override
    void attribute(@Nonnull String localName, @Nonnull String value) {
        if (localName.equals(OWLXMLVocabulary.DATATYPE_IRI.getShortForm())) {
            this.iri = this.handler.getIRI(value);
        } else if (localName.equals("lang")) {
            this.lang = value;
        }
    }

    @Override
    void endElement() {
        this.literal = this.iri != null && !this.iri.isPlainLiteral() ? this.df.getOWLLiteral(this.getText(), this.df.getOWLDatatype(OWLAPIPreconditions.verifyNotNull(this.iri))) : this.df.getOWLLiteral(this.getText(), this.lang);
        this.lang = null;
        this.iri = null;
        this.getParentHandler().handleChild(this);
    }

    @Override
    OWLLiteral getOWLObject() {
        return OWLAPIPreconditions.verifyNotNull(this.literal);
    }

    @Override
    boolean isTextContentPossible() {
        return true;
    }
}

