/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import sun.management.counter.StringCounter;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.management.counter.perf.PerfByteArrayCounter;
import sun.management.counter.perf.StringCounterSnapshot;

public class PerfStringCounter
extends PerfByteArrayCounter
implements StringCounter {
    private static Charset defaultCharset = Charset.defaultCharset();
    private static final long serialVersionUID = 6802913433363692452L;

    PerfStringCounter(String name, Variability v, int flags, ByteBuffer bb) {
        this(name, v, flags, bb.limit(), bb);
    }

    PerfStringCounter(String name, Variability v, int flags, int maxLength, ByteBuffer bb) {
        super(name, Units.STRING, v, flags, maxLength, bb);
    }

    @Override
    public boolean isVector() {
        return false;
    }

    @Override
    public int getVectorLength() {
        return 0;
    }

    @Override
    public Object getValue() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        int i;
        String str = "";
        byte[] b = this.byteArrayValue();
        if (b == null || b.length <= 1) {
            return str;
        }
        for (i = 0; i < b.length && b[i] != 0; ++i) {
        }
        return new String(b, 0, i, defaultCharset);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new StringCounterSnapshot(this.getName(), this.getUnits(), this.getVariability(), this.getFlags(), this.stringValue());
    }
}

