/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_HT = "\u0dc4\u0dba\u0dd2\u0da7\u0dd2";
        final String metaValue_TO = "\u0da7\u0ddc\u0d82\u0d9c\u0dcf";
        final String metaValue_ar = "\u0d85\u0dbb\u0dcf\u0db6\u0dd2";
        final String metaValue_bn = "\u0db6\u0dd9\u0d82\u0d9c\u0dcf\u0dbd\u0dd2";
        final String metaValue_el = "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a";
        final String metaValue_gu = "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2";
        final String metaValue_he = "\u0dc4\u0dd3\u0db6\u0df2";
        final String metaValue_hy = "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_ja = "\u0da2\u0db4\u0db1\u0dca";
        final String metaValue_ka = "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_km = "\u0d9a\u0db8\u0dbb\u0dca";
        final String metaValue_kn = "\u0d9a\u0dab\u0dca\u0dab\u0da9";
        final String metaValue_ko = "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_la = "\u0dbd\u0dad\u0dd2\u0db1\u0dca";
        final String metaValue_lo = "\u0dbd\u0dcf\u0d95";
        final String metaValue_ml = "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca";
        final String metaValue_si = "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd";
        final String metaValue_ta = "\u0daf\u0dd9\u0db8\u0dc5";
        final String metaValue_te = "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4";
        final String metaValue_th = "\u0dad\u0dcf\u0dba\u0dd2";
        final String metaValue_type_hc_h11 = "\u0db4\u0dd0\u0dba 12 \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba";
        final String metaValue_type_hc_h23 = "\u0db4\u0dd0\u0dba 24 \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0d9a\u0ddc\u0dbd\u0ddc\u0d9c\u0dca\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "mwl", "\u0db8\u0dd2\u0dbb\u0db1\u0dca\u0da9\u0dd3\u0dc3\u0dca" },
            { "Zsym", "\u0dc3\u0d82\u0d9a\u0dda\u0dad" },
            { "Zsye", "\u0d89\u0db8\u0ddc\u0da2\u0dd2" },
            { "ccp", "\u0da0\u0d9a\u0dca\u0db8\u0dcf" },
            { "tem", "\u0da7\u0dd2\u0db8\u0dca\u0db1\u0dd9" },
            { "teo", "\u0da7\u0dd9\u0dc3\u0ddd" },
            { "rap", "\u0dbb\u0db4\u0db1\u0dd4\u0dba\u0dd2" },
            { "AC", "\u0d87\u0dc3\u0dd9\u0db1\u0dca\u0dc2\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "rar", "\u0dbb\u0dbb\u0ddc\u0da7\u0ddc\u0db1\u0dca\u0d9c\u0db1\u0dca" },
            { "tet", "\u0da7\u0dda\u0da7\u0db8\u0dca" },
            { "AD", "\u0d87\u0db1\u0dca\u0da9\u0ddd\u0dbb\u0dcf\u0dc0" },
            { "AE", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dca \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "nl_BE", "\u0dc6\u0dca\u0dbd\u0dd9\u0db8\u0dd2\u0dc1\u0dca" },
            { "AF", "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "AG", "\u0d87\u0db1\u0dca\u0da7\u0dd2\u0d9c\u0dd4\u0dc0\u0dcf \u0dc3\u0dc4 \u0db6\u0dcf\u0db6\u0dd2\u0dba\u0dd4\u0da9\u0dcf\u0dc0" },
            { "type.ca.ethiopic", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "AI", "\u0d87\u0db1\u0dca\u0d9c\u0dd4\u0dba\u0dd2\u0dbd\u0dcf\u0dc0" },
            { "AL", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AM", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AO", "\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0dc0" },
            { "AQ", "\u0d87\u0db1\u0dca\u0da7\u0dcf\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "AR", "\u0d86\u0dbb\u0dca\u0da2\u0dd9\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf\u0dc0" },
            { "AS", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AW", "\u0d85\u0dbb\u0dd6\u0db6\u0dcf" },
            { "en_US", "\u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "AX", "\u0d95\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "AZ", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dba" },
            { "BA", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf\u0dc0" },
            { "BB", "\u0db6\u0dcf\u0db6\u0da9\u0ddd\u0dc3\u0dca" },
            { "ceb", "\u0dc3\u0dd9\u0db6\u0dd4\u0d85\u0db1\u0ddc" },
            { "BD", "\u0db6\u0d82\u0d9c\u0dca\u0dbd\u0dcf\u0daf\u0dda\u0dc1\u0dba" },
            { "kum", "\u0d9a\u0dd4\u0db8\u0dd2\u0d9a\u0dca" },
            { "BE", "\u0db6\u0dd9\u0dbd\u0dca\u0da2\u0dd2\u0dba\u0db8" },
            { "BF", "\u0db6\u0dbb\u0dca\u0d9a\u0dd2\u0db1\u0dcf \u0dc6\u0dcf\u0dc3\u0ddd" },
            { "BG", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BH", "\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca" },
            { "BI", "\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0daf\u0dd2" },
            { "BJ", "\u0db6\u0dd9\u0db1\u0dd2\u0db1\u0dca" },
            { "BL", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db6\u0dbb\u0dca\u0dad\u0dbd\u0dd9\u0db8\u0dd2" },
            { "BM", "\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf" },
            { "myv", "\u0d91\u0dbb\u0dca\u0dc3\u0dca\u0dba\u0dcf" },
            { "BN", "\u0db6\u0df2\u0db1\u0dcf\u0dba\u0dd2" },
            { "BO", "\u0db6\u0ddc\u0dbd\u0dd3\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BQ", "\u0d9a\u0dd0\u0dbb\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd\u0dba" },
            { "BS", "\u0db6\u0dc4\u0db8\u0dcf\u0dc3\u0dca" },
            { "xog", "\u0dc3\u0ddc\u0d9c\u0dcf" },
            { "BT", "\u0db7\u0dd6\u0dad\u0dcf\u0db1\u0dba" },
            { "BV", "\u0db6\u0dd4\u0dc0\u0da7\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca" },
            { "BW", "\u0db6\u0ddc\u0da7\u0dca\u0dc3\u0dca\u0dc0\u0dcf\u0db1\u0dcf" },
            { "BY", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dca" },
            { "BZ", "\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca" },
            { "type.ca.persian", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.nu.hebr", "\u0dc4\u0dd3\u0db6\u0df2 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "CA", "\u0d9a\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "CC", "\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "mzn", "\u0db8\u0dd0\u0dc3\u0db1\u0dca\u0da9\u0dbb\u0db1\u0dd2" },
            { "CD", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddd\u0dc0 (\u0da9\u0dd3\u0d86\u0dbb\u0dca\u0dc3\u0dd3)" },
            { "CF", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "CG", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0db6\u0dca\u200d\u0dbb\u0dc3\u0dcf\u0dc0\u0dd2\u0dbd\u0dca" },
            { "CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "CI", "\u0d9a\u0ddd\u0da7\u0dca \u0daf\u0dd2 \u0d85\u0dba\u0dd2\u0dc0\u0dbb\u0dd2" },
            { "CK", "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CL", "\u0da0\u0dd2\u0dbd\u0dd3" },
            { "CM", "\u0d9a\u0dd0\u0db8\u0dbb\u0dd6\u0db1\u0dca" },
            { "CN", "\u0da0\u0dd3\u0db1\u0dba" },
            { "CO", "\u0d9a\u0ddc\u0dc5\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "CP", "\u0d9a\u0dca\u0dbd\u0dd3\u0db4\u0dbb\u0dca\u0da7\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "CR", "\u0d9a\u0ddc\u0dc3\u0dca\u0da7\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "CU", "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0dc0" },
            { "CV", "\u0d9a\u0dda\u0db4\u0dca \u0dc0\u0dbb\u0dca\u0da9\u0dca" },
            { "CW", "\u0d9a\u0dd4\u0dbb\u0d9a\u0dcf\u0dc0\u0ddd" },
            { "CX", "\u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0db8\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "CY", "\u0dc3\u0dba\u0dd2\u0db4\u0dca\u200d\u0dbb\u0dc3\u0dba" },
            { "CZ", "\u0da0\u0dd9\u0da0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "eka", "\u0d91\u0d9a\u0da2\u0dd4\u0d9a\u0dca" },
            { "DE", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2\u0dba" },
            { "ace", "\u0d85\u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "cgg", "\u0da0\u0dd2\u0d9c\u0dcf" },
            { "DG", "\u0daf\u0dd2\u0dba\u0dcf\u0d9c\u0ddd \u0d9c\u0dcf\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf" },
            { "type.nu.deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "DJ", "\u0da2\u0dd2\u0db6\u0dd4\u0da7\u0dd2" },
            { "DK", "\u0da9\u0dd9\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dba" },
            { "Brai", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dca" },
            { "DM", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "type.nu.armnlow", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "DO", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "gor", "\u0d9c\u0ddc\u0dbb\u0ddc\u0db1\u0dca\u0da7\u0dcf\u0dbd\u0ddc" },
            { "zun", "\u0dc3\u0dd4\u0db1\u0dd2" },
            { "tig", "\u0da7\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0dd9" },
            { "DZ", "\u0d87\u0dbd\u0dca\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "pag", "\u0db4\u0db1\u0dca\u0d9c\u0dc3\u0dd3\u0db1\u0db1\u0dca" },
            { "EA", "\u0dc3\u0dd9\u0dba\u0dd4\u0da7\u0dcf \u0dc3\u0dc4 \u0db8\u0dd9\u0dbd\u0dd2\u0dbd\u0dca\u0dbd\u0dcf" },
            { "pam", "\u0db4\u0db1\u0dca\u0db4\u0db1\u0dca\u0d9c" },
            { "EC", "\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "pap", "\u0db4\u0db4\u0dd2\u0dba\u0db8\u0dd9\u0db1\u0dca\u0da7\u0ddc" },
            { "ada", "\u0d85\u0da9\u0db1\u0dca\u0d9c\u0dca\u0db8\u0dd9" },
            { "EE", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EG", "\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4\u0dc0" },
            { "EH", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc3\u0dc4\u0dbb\u0dcf\u0dc0" },
            { "pau", "\u0db4\u0dbd\u0dc0\u0dd4\u0dc0\u0db1\u0dca" },
            { "chk", "\u0da0\u0dd6\u0d9a\u0dd3\u0dc3\u0dca" },
            { "chm", "\u0db8\u0dbb\u0dd2" },
            { "cho", "\u0da0\u0ddc\u0d9a\u0dca\u0da7\u0ddc\u0dc0\u0dca" },
            { "chr", "\u0da0\u0dd9\u0dbb\u0ddc\u0d9a\u0dd3" },
            { "ER", "\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ES", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4\u0dba" },
            { "ET", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EU", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dcf \u0dc3\u0d82\u0d9c\u0db8\u0dba" },
            { "type.ca.gregorian", "\u0d9c\u0dca\u200d\u0dbb\u0dd9\u0d9c\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "EZ", "\u0dba\u0dd4\u0dbb\u0ddd \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "chy", "\u0da0\u0dd9\u0dba\u0dd9\u0db1\u0dca\u0db1\u0dd9" },
            { "type.nu.gujr", "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "ady", "\u0d85\u0da9\u0dd2\u0d9d\u0dd9" },
            { "aeb", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0db1\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "FI", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "FJ", "\u0dc6\u0dd3\u0da2\u0dd3" },
            { "FK", "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FM", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "FO", "\u0dc6\u0dd0\u0dbb\u0ddd \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "Taml", metaValue_ta },
            { "FR", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1\u0dba" },
            { "root", "\u0dbb\u0dd6\u0da7\u0dca" },
            { "GA", "\u0d9c\u0dd0\u0db6\u0ddc\u0db1\u0dca" },
            { "GB", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0dbb\u0dcf\u0da2\u0db0\u0dcf\u0db1\u0dd2\u0dba" },
            { "pcm", "\u0db1\u0ddb\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0db1\u0dca \u0db4\u0dd9\u0db1\u0dca\u0d9c\u0dd2\u0db1\u0dca" },
            { "GD", "\u0d9c\u0dca\u200d\u0dbb\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "GE", "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "GG", "\u0d9c\u0dbb\u0dca\u0db1\u0dca\u0dc3\u0dd2\u0dba" },
            { "GH", "\u0d9d\u0dcf\u0db1\u0dcf\u0dc0" },
            { "GI", "\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "GL", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "GM", "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GN", "\u0d9c\u0dd2\u0dab\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GP", "\u0d9c\u0dca\u0dc0\u0ddd\u0da9\u0dbd\u0ddd\u0db4\u0dca" },
            { "GQ", "\u0dc3\u0db8\u0d9a \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GR", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0dba" },
            { "GS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd0\u0db1\u0dca\u0da9\u0dca\u0dc0\u0dd2\u0da0\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "GT", "\u0d9c\u0ddd\u0dad\u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "GU", "\u0d9c\u0dd4\u0dc0\u0dcf\u0db8\u0dca" },
            { "GW", "\u0d9c\u0dd2\u0db1\u0dd2 \u0db6\u0dd2\u0dc3\u0dc0\u0dca" },
            { "tlh", "\u0d9a\u0dca\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0ddc\u0db1\u0dca" },
            { "GY", "\u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "ckb", "\u0dc3\u0ddc\u0dbb\u0dcf\u0db1\u0dd2 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2\u0dc2\u0dca" },
            { "zxx", "\u0dc0\u0dcf\u0d9c\u0dca \u0dc0\u0dd2\u0daf\u0dca\u200d\u0dba\u0dcf \u0d85\u0db1\u0dca\u0dad\u0dbb\u0dca\u0d9c\u0dad\u0dba\u0d9a\u0dca \u0db1\u0dd0\u0dad" },
            { "de_AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "HK", "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "HM", "\u0dc4\u0dbb\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0dca\u0da9\u0ddc\u0db1\u0dbd\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "HN", "\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0dc3\u0dca" },
            { "HR", "\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "agq", "\u0d87\u0d9c\u0db8\u0dca" },
            { "gsw", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0dcf\u0db1\u0dd4" },
            { "HT", metaValue_HT },
            { "HU", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IC", "\u0d9a\u0dd0\u0db1\u0dbb\u0dd2 \u0dc3\u0dd6\u0db4\u0dad\u0dca" },
            { "nan", "\u0db8\u0dd2\u0db1\u0dca \u0db1\u0db1\u0dca \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "ID", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IE", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "nap", "\u0db1\u0dd2\u0dba\u0dcf\u0db4\u0ddc\u0dbd\u0dd2\u0da7\u0db1\u0dca" },
            { "naq", "\u0db1\u0dcf\u0db8\u0dcf" },
            { "zza", "\u0dc3\u0dcf\u0dc3\u0dcf" },
            { "IL", "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd\u0dba" },
            { "IM", "\u0d85\u0dba\u0dd2\u0dbd\u0dca \u0d94\u0dc6\u0dca \u0db8\u0dd1\u0db1\u0dca" },
            { "IN", "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IO", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0db1\u0dca\u0daf\u0dd3\u0dba \u0dc3\u0dcf\u0d9c\u0dbb \u0db6\u0dbd \u0db4\u0dca\u200d\u0dbb\u0daf\u0dda\u0dc1\u0dba" },
            { "IQ", "\u0d89\u0dbb\u0dcf\u0d9a\u0dba" },
            { "IR", "\u0d89\u0dbb\u0dcf\u0db1\u0dba" },
            { "IS", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "IT", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2\u0dba" },
            { "Zmth", "\u0d9c\u0dab\u0dd2\u0dad\u0db8\u0dba \u0dc3\u0d82\u0d9a\u0dda\u0dad" },
            { "type.nu.thai", "\u0dad\u0dcf\u0dba\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.beng", "\u0db6\u0dd9\u0d82\u0d9c\u0dcf\u0dbd\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "JE", "\u0da2\u0dbb\u0dca\u0dc3\u0dd2" },
            { "type.ca.islamic", "\u0d89\u0dc3\u0dca\u0dbd\u0dcf\u0db8\u0dd3\u0dba \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "Beng", metaValue_bn },
            { "JM", "\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "JO", "\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dba" },
            { "JP", "\u0da2\u0db4\u0dcf\u0db1\u0dba" },
            { "ain", "\u0d85\u0dba\u0dd2\u0db1\u0dd4" },
            { "guz", "\u0d9c\u0dd4\u0dc3\u0dd3" },
            { "type.nu.knda", "\u0d9a\u0db1\u0dca\u0db1\u0da9 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "de_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0d8b\u0dc3\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "type.ca.buddhist", "\u0db6\u0ddc\u0daf\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "KE", "\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0dc0" },
            { "419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "KG", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "KH", "\u0d9a\u0dcf\u0db8\u0dca\u0db6\u0ddd\u0da2\u0dba" },
            { "KI", "\u0d9a\u0dd2\u0dbb\u0dd2\u0db6\u0dad\u0dd2" },
            { "KM", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0ddd\u0dc3\u0dca" },
            { "Knda", metaValue_kn },
            { "KN", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0d9a\u0dd2\u0da7\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0db1\u0dda\u0dc0\u0dd2\u0dc3\u0dca" },
            { "fr_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "KP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KR", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "fr_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "KW", "\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dba" },
            { "tpi", "\u0da7\u0ddc\u0d9a\u0dca \u0db4\u0dd2\u0dc3\u0dd2\u0db1\u0dca" },
            { "KY", "\u0d9a\u0dda\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "KZ", "\u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "Cyrl", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dbd\u0dd2\u0d9a\u0dca" },
            { "LA", "\u0dbd\u0dcf\u0d95\u0dc3\u0dba" },
            { "LB", "\u0dbd\u0dd9\u0db6\u0db1\u0db1\u0dba" },
            { "LC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf" },
            { "gwi", "\u0d9c\u0dca\u0dc0\u0dd2\u0da0\u0dd2\u0db1\u0dca" },
            { "nds", "\u0db4\u0dc4\u0dc5 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "LI", "\u0dbd\u0dd2\u0d9a\u0dca\u0da7\u0db1\u0dca\u0dc3\u0dca\u0da7\u0dba\u0dd2\u0db1\u0dca" },
            { "LK", "\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0" },
            { "LR", "\u0dbd\u0dba\u0dd2\u0db6\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LS", "\u0dbd\u0dd9\u0dc3\u0dad\u0ddd" },
            { "LT", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LU", "\u0dbd\u0d9a\u0dca\u0dc1\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "LV", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "Kana", "\u0d9a\u0dad\u0d9a\u0db1\u0dcf" },
            { "LY", "\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "lad", "\u0dbd\u0da9\u0dd2\u0db1\u0ddc" },
            { "vun", "\u0dc0\u0dd4\u0db1\u0dca\u0da2\u0ddd" },
            { "lag", "\u0dbd\u0d82\u0d9c\u0dd2" },
            { "Thaa", "\u0dad\u0dcf\u0db1" },
            { "MA", "\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd\u0dc0" },
            { "MC", "\u0db8\u0ddc\u0db1\u0dcf\u0d9a\u0ddd\u0dc0" },
            { "MD", "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0dc0" },
            { "ME", "\u0db8\u0ddc\u0db1\u0dca\u0da7\u0dd9\u0db1\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "MF", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dca" },
            { "MG", "\u0db8\u0dd0\u0da9\u0d9c\u0dc3\u0dca\u0d9a\u0dbb\u0dba" },
            { "Thai", metaValue_th },
            { "MH", "\u0db8\u0dcf\u0dc2\u0dbd\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "ale", "\u0d87\u0dbd\u0dd4\u0d91\u0da7\u0dca" },
            { "MK", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ML", "\u0db8\u0dcf\u0dbd\u0dd2" },
            { "MM", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dba (\u0db6\u0dd4\u0dbb\u0dd4\u0db8\u0dba)" },
            { "MN", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "new", "\u0db1\u0dd9\u0dc0\u0dcf\u0dbb\u0dd2" },
            { "MO", "\u0db8\u0d9a\u0dcf\u0dc0\u0dd4 \u0d91\u0dc3\u0dca\u0d92\u0d86\u0dbb\u0dca" },
            { "MP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dcf \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "MQ", "\u0db8\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dd2\u0d9a\u0dca" },
            { "MR", "\u0db8\u0ddc\u0dbb\u0dd2\u0da7\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MS", "\u0db8\u0ddc\u0db1\u0dca\u0dc3\u0dd9\u0dbb\u0dcf\u0da7\u0dca" },
            { "MT", "\u0db8\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "MU", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2\u0dba" },
            { "alt", "\u0dc3\u0dad\u0dbb\u0dca\u0db1\u0dca \u0d85\u0dbd\u0dca\u0da7\u0dba\u0dca" },
            { "MV", "\u0db8\u0dcf\u0dbd \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "MW", "\u0db8\u0dbd\u0dcf\u0dc0\u0dd2" },
            { "MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd\u0dc0" },
            { "type.ca.japanese", "\u0da2\u0db4\u0db1\u0dca \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "MY", "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MZ", "\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0dca" },
            { "NA", "\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "202", "\u0d8b\u0db4-\u0dc3\u0dc4\u0dbb\u0dcf\u0db1\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "type.ca.hebrew", "\u0dc4\u0dd3\u0db6\u0df2 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.co.dictionary", "\u0dc1\u0db6\u0dca\u0daf\u0d9a\u0ddd\u0dc2 \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "NC", "\u0db1\u0dc0 \u0d9a\u0dd0\u0dbd\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NE", "\u0db1\u0dba\u0dd2\u0da2\u0dbb\u0dca" },
            { "NF", "\u0db1\u0ddd\u0dc6\u0ddd\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "NG", "\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "trv", "\u0da7\u0dbb\u0ddc\u0d9a\u0ddc" },
            { "NI", "\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0dc0" },
            { "NL", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "NO", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dda" },
            { "NP", "\u0db1\u0dda\u0db4\u0dcf\u0dbd\u0dba" },
            { "NR", "\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4" },
            { "NU", "\u0db1\u0dd2\u0dba\u0dd6" },
            { "rof", "\u0dbb\u0ddd\u0db8\u0dca\u0db6\u0ddd" },
            { "NZ", "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "OM", "\u0d95\u0db8\u0dcf\u0db1\u0dba" },
            { "anp", "\u0d85\u0db1\u0dca\u0d9c\u0dd2\u0d9a" },
            { "crs", "\u0dc3\u0dd9\u0dc3\u0dd9\u0dbd\u0dca\u0dc0 \u0d9a\u0dca\u200d\u0dbb\u0ddc\u0dbd\u0dca \u0dc6\u0dca\u200d\u0dbb\u0dd9\u0db1\u0dca\u0da0\u0dca" },
            { "PA", "\u0db4\u0dd0\u0db1\u0db8\u0dcf\u0dc0" },
            { "en_GB", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "PE", "\u0db4\u0dda\u0dbb\u0dd4" },
            { "PF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PG", "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PH", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1\u0dba" },
            { "PK", "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "PL", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "ewo", "\u0d91\u0dc0\u0ddc\u0db1\u0dca\u0da9\u0ddc" },
            { "PM", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca" },
            { "PN", "\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dca\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "PR", "\u0db4\u0dd4\u0dc0\u0dbb\u0dca\u0da7\u0ddd \u0dbb\u0dd2\u0d9a\u0ddd" },
            { "PS", "\u0db4\u0dbd\u0dc3\u0dca\u0dad\u0dd3\u0db1 \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "PT", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dcf\u0dbd\u0dba" },
            { "PW", "\u0db4\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "nia", "\u0db1\u0dd2\u0dba\u0dcf\u0dc3\u0dca" },
            { "type.nu.greklow", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "PY", "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda" },
            { "tum", "\u0da7\u0dd4\u0db8\u0dca\u0db6\u0dd4\u0d9a\u0dcf" },
            { "Hebr", metaValue_he },
            { "QA", "\u0d9a\u0da7\u0dcf\u0dbb\u0dca" },
            { "niu", "\u0db1\u0dd2\u0dba\u0dd4\u0d91\u0db1\u0dca" },
            { "QO", "\u0d88\u0dad \u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "lez", "\u0dbd\u0dd9\u0dc3\u0dca\u0d9c\u0dd2\u0dba\u0db1\u0dca" },
            { "tvl", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd4" },
            { "001", "\u0dbd\u0ddd\u0d9a\u0dba" },
            { "002", "\u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "003", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "RE", "\u0dbb\u0dd3\u0dba\u0dd4\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "005", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "jbo", "\u0dbd\u0ddc\u0da2\u0dca\u0db6\u0db1\u0dca" },
            { "009", "\u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RO", "\u0dbb\u0dd4\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RS", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RU", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RW", "\u0dbb\u0dd4\u0dc0\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "SA", "\u0dc3\u0dde\u0daf\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2\u0dba" },
            { "SB", "\u0dc3\u0ddc\u0dbd\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "twq", "\u0da7\u0dc3\u0dc0\u0dcf\u0d9a\u0dca" },
            { "011", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SC", "\u0dc3\u0dd3\u0dc1\u0dd9\u0dbd\u0dca\u0dc3\u0dca" },
            { "SD", "\u0dc3\u0dd6\u0da9\u0dcf\u0db1\u0dba" },
            { "013", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SE", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dba" },
            { "014", "\u0db4\u0dd9\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "015", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SG", "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4\u0dc0" },
            { "SH", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc4\u0dd9\u0dbd\u0dda\u0db1\u0dcf" },
            { "type.lb.strict", "\u0dad\u0daf \u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "017", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SI", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "018", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SJ", "\u0dc3\u0dca\u0dc0\u0dd9\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da9\u0dca \u0dc3\u0dc4 \u0da2\u0dda\u0db1\u0dca \u0db8\u0dba\u0dda\u0db1\u0dca" },
            { "019", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "SK", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SL", "\u0dc3\u0dd2\u0dba\u0dbb\u0dcf\u0dbd\u0dd2\u0dba\u0ddd\u0db1\u0dca" },
            { "SM", "\u0dc3\u0dd0\u0db1\u0dca \u0db8\u0dd0\u0dbb\u0dd2\u0db1\u0ddd" },
            { "SN", "\u0dc3\u0dd9\u0db1\u0d9c\u0dcf\u0dbd\u0dba" },
            { "SO", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "arn", "\u0db8\u0db4\u0dd4\u0da0\u0dd9" },
            { "arp", "\u0d87\u0dbb\u0db4\u0dc4\u0ddc" },
            { "type.nu.taml", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0daf\u0dd9\u0db8\u0dc5 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "SR", "\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8\u0dba" },
            { "SS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd4\u0da9\u0dcf\u0db1\u0dba" },
            { "ST", "\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca" },
            { "SV", "\u0d91\u0dbd\u0dca \u0dc3\u0dd0\u0dbd\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "SX", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd9\u0db1\u0dca" },
            { "SY", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SZ", "\u0d91\u0dc3\u0dca\u0dc0\u0dcf\u0da7\u0dd2\u0db1\u0dd2" },
            { "TA", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0da7\u0db1\u0dca \u0daf \u0d9a\u0dd4\u0db1\u0dca\u0dc4\u0dcf" },
            { "asa", "\u0d85\u0dc3\u0dd4" },
            { "type.ms.ussystem", "\u0d91\u0da2 \u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "021", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "TC", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0d9a\u0dba\u0dd2\u0d9a\u0ddc\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "yav", "\u0dba\u0db1\u0dca\u0d9c\u0dca\u0db6\u0dd9\u0db1\u0dca" },
            { "TD", "\u0da0\u0dd0\u0da0\u0dca" },
            { "TF", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dd6\u0dc4\u0dba" },
            { "TG", "\u0da7\u0ddc\u0d9c\u0ddd" },
            { "TH", "\u0dad\u0dcf\u0dba\u0dd2\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "TJ", "\u0da7\u0da2\u0dd2\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "029", "\u0d9a\u0dd0\u0dbb\u0dd3\u0db6\u0dd2\u0dba\u0db1\u0dca" },
            { "TK", "\u0da7\u0ddc\u0d9a\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "TL", "\u0da7\u0dd2\u0db8\u0ddd\u0dbb\u0dca - \u0dbd\u0dd9\u0dc3\u0dca\u0dad\u0dca" },
            { "ybb", "\u0dba\u0dd9\u0db8\u0dca\u0db6\u0dcf" },
            { "TM", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "TN", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TO", metaValue_TO },
            { "TR", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2\u0dba" },
            { "TT", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da9\u0dd1\u0da9\u0dca \u0dc3\u0dc4 \u0da7\u0ddc\u0db6\u0dd0\u0d9c\u0ddd" },
            { "TV", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd6" },
            { "TW", "\u0dad\u0dcf\u0dba\u0dd2\u0dc0\u0dcf\u0db1\u0dba" },
            { "ast", "\u0d87\u0dc3\u0dca\u0da7\u0dd2\u0dba\u0dd4\u0dbb\u0dd2\u0dba\u0db1\u0dca" },
            { "TZ", "\u0da7\u0dd0\u0db1\u0dca\u0dc3\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "nmg", "\u0d9a\u0dd4\u0dc0\u0dcf\u0dc3\u0dd2\u0d94" },
            { "Zzzz", "\u0db1\u0ddc\u0daf\u0dad\u0dca \u0d85\u0d9a\u0dca\u0dc2\u0dbb \u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "UA", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dba" },
            { "rup", "\u0d87\u0dbb\u0ddc\u0db8\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "030", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "tyv", "\u0da7\u0dd4\u0dc0\u0dd2\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "sw_CD", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddd \u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "034", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "035", "\u0d85\u0d9c\u0dca\u0db1\u0dd2\u0daf\u0dd2\u0d9c \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "UG", "\u0d8b\u0d9c\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "hak", "\u0dc4\u0d9a\u0dcf \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "039", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "Sinh", metaValue_si },
            { "UM", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf \u0d88\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "UN", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0dcf\u0dad\u0dd3\u0db1\u0dca" },
            { "US", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf\u0dba" },
            { "haw", "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2" },
            { "UY", "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda" },
            { "prg", "\u0db4\u0dd8\u0dc1\u0dd2\u0dba\u0db1\u0dca" },
            { "UZ", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "tzm", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0da7\u0dca\u0dbd\u0dc3\u0dca \u0da7\u0db8\u0dc3\u0dd2\u0da7\u0dca" },
            { "nnh", "\u0db1\u0dca\u0d9c\u0dd2\u0dba\u0dcf\u0db8\u0dca\u0db6\u0dd6\u0db1\u0dca" },
            { "VA", "\u0dc0\u0dad\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0d9c\u0dbb\u0dba" },
            { "VC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc0\u0dd2\u0db1\u0dca\u0dc3\u0db1\u0dca\u0da7\u0dca \u0dc3\u0dc4 \u0d9c\u0dca\u200d\u0dbb\u0dd9\u0db1\u0da9\u0dd2\u0db1\u0dca\u0dc3\u0dca" },
            { "VE", "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf\u0dc0" },
            { "VG", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VI", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VN", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dba" },
            { "VU", "\u0dc0\u0db1\u0dd4\u0dc0\u0dcf\u0da7\u0dd4" },
            { "nog", "\u0db1\u0ddc\u0d9c\u0dcf\u0dba\u0dd2" },
            { "rwk", "\u0dbb\u0dca\u0dc0\u0dcf" },
            { "053", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dbd\u0dda\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "054", "\u0db8\u0dd9\u0dbd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "WF", "\u0dc0\u0dd0\u0dbd\u0dd2\u0dc3\u0dca \u0dc3\u0dc4 \u0dc6\u0dd4\u0da7\u0dd4\u0db1\u0dcf" },
            { "057", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "jgo", "\u0db1\u0ddc\u0db8\u0dca\u0db6\u0dcf" },
            { "lkt", "\u0dbd\u0d9a\u0ddc\u0da7" },
            { "wae", "\u0dc0\u0ddc\u0dbd\u0dca\u0dc3\u0dbb\u0dca" },
            { "WS", "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "wal", "\u0dc0\u0ddc\u0dbd\u0dd9\u0da7\u0dca\u0da7" },
            { "XA", "\u0dc0\u0dca\u200d\u0dba\u0dcf\u0da2-\u0d8b\u0da0\u0dca\u0da0\u0dcf\u0dbb\u0dab" },
            { "war", "\u0dc0\u0ddc\u0dbb\u0dd9\u0dba\u0dca" },
            { "XB", "\u0dc0\u0dca\u200d\u0dba\u0dcf\u0da2-\u0db6\u0dd2\u0da9\u0dd2" },
            { "awa", "\u0d85\u0dc0\u0daf\u0dd2" },
            { "061", "\u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "XK", "\u0d9a\u0ddc\u0dc3\u0ddd\u0dc0\u0ddd" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0d85\u0dbd\u0dd2\u0d9b\u0dd2\u0dad" },
            { "wbp", "\u0dc0\u0ddc\u0db4\u0dd2\u0dbb\u0dd2" },
            { "YE", "\u0dba\u0dda\u0db8\u0db1\u0dba" },
            { "nqo", "\u0d91\u0db1\u0dca\u2018\u0d9a\u0ddd" },
            { "type.co.standard", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "YT", "\u0db8\u0dba\u0ddd\u0da7\u0dca" },
            { "ZA", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "type.lb.loose", "\u0dbd\u0dd2\u0dc4\u0dd2\u0dbd\u0dca \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "Deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3" },
            { "type.nu.geor", "\u0da2\u0ddd\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "Hira", "\u0dc4\u0dd2\u0dbb\u0d9f\u0db1\u0dcf" },
            { "ZM", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ZW", "\u0dc3\u0dd2\u0db8\u0dca\u0db6\u0dcf\u0db6\u0dca\u0dc0\u0dda" },
            { "ZZ", "\u0dc4\u0db3\u0dd4\u0db1\u0dcf \u0db1\u0ddc\u0d9c\u0dad\u0dca \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "type.ms.metric", "\u0db8\u0dd9\u0da7\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "type.ca.iso8601", "\u0d85\u0d91\u0dc3\u0dca\u0d94-8601 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "nso", "\u0db1\u0ddc\u0daf\u0dbb\u0dca\u0db1\u0dca \u0dc3\u0ddc\u0dad\u0ddc" },
            { "type.nu.telu", "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "loz", "\u0dbd\u0ddc\u0dc3\u0dd2" },
            { "jmc", "\u0db8\u0dd0\u0d9a\u0dcf\u0db8\u0dd3" },
            { "type.nu.hansfin", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5 \u0da0\u0dd3\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "hil", "\u0dc4\u0dd2\u0dbd\u0dd2\u0d9c\u0dd9\u0db1\u0db1\u0dca" },
            { "type.nu.arabext", "\u0dc0\u0dd0\u0da9\u0dd2 \u0d9a\u0dc5 \u0d89\u0db1\u0dca\u0daf\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "nus", "\u0db1\u0ddc\u0dba\u0dbb\u0dca" },
            { "dak", "\u0da9\u0d9a\u0ddc\u0da7\u0dcf" },
            { "type.nu.fullwide", "\u0dc3\u0db8\u0dca\u0db4\u0dd6\u0dbb\u0dca\u0dab \u0db4\u0dc5\u0dbd \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "dar", "\u0da9\u0dcf\u0dbb\u0dca\u0d9c\u0dca\u0dc0\u0dcf" },
            { "dav", "\u0da7\u0dba\u0dd2\u0da7\u0dcf" },
            { "lrc", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dbd\u0dd4\u0dbb\u0dd2" },
            { "udm", "\u0d85\u0da9\u0dca\u0db8\u0dbb\u0dca\u0da7\u0dca" },
            { "Khmr", metaValue_km },
            { "sad", "\u0dc3\u0db1\u0dca\u0da9\u0dc0\u0dd9" },
            { "type.nu.roman", "\u0dbb\u0ddd\u0db8\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "sah", "\u0dc3\u0d9b\u0dcf" },
            { "saq", "\u0dc3\u0db8\u0dca\u0db6\u0dd4\u0dbb\u0dd4" },
            { "sat", "\u0dc3\u0dd1\u0db1\u0dca\u0da7\u0dbd\u0dd2" },
            { "sba", "\u0db1\u0dca\u0d9c\u0db8\u0dca\u0db6\u0dd9" },
            { "Guru", "\u0d9c\u0dd4\u0dbb\u0dca\u0db8\u0dd4\u0d9b\u0dd2" },
            { "lua", "\u0dbd\u0dd4\u0db6-\u0dbd\u0dd4\u0dbd\u0dd4\u0d85" },
            { "sbp", "\u0dc3\u0d82\u0d9c\u0dd4" },
            { "nyn", "\u0db1\u0dba\u0db1\u0dca\u0d9a\u0ddd\u0dbd\u0dd9" },
            { "lun", "\u0dbd\u0dd4\u0db1\u0dca\u0da9" },
            { "luo", "\u0dbd\u0dd4\u0d94" },
            { "fil", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1" },
            { "hmn", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0dca" },
            { "lus", "\u0db8\u0dd2\u0dc3\u0ddc" },
            { "ban", "\u0db6\u0dd0\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dca" },
            { "luy", "\u0dbd\u0dd4\u0dba\u0dd2\u0dba\u0dcf" },
            { "bas", "\u0db6\u0dc3\u0dcf" },
            { "es_ES", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "sco", "\u0dc3\u0dca\u0d9a\u0ddc\u0da7\u0dca\u0dc3\u0dca" },
            { "scn", "\u0dc3\u0dd2\u0dc3\u0dd2\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "aa", "\u0d85\u0dc6\u0dcf\u0dbb\u0dca" },
            { "ab", "\u0d87\u0db6\u0dca\u0d9a\u0dcf\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "af", "\u0d85\u0dc6\u0dca\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dca\u0dc3\u0dca" },
            { "ak", "\u0d85\u0d9a\u0dcf\u0db1\u0dca" },
            { "am", "\u0d87\u0db8\u0dca\u0dc4\u0dcf\u0dbb\u0dd2\u0d9a\u0dca" },
            { "Arab", metaValue_ar },
            { "an", "\u0d87\u0dbb\u0d9c\u0ddc\u0db1\u0dd3\u0dc3\u0dca" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0da2\u0dd1\u0db4\u0db1\u0dd3\u0dc3\u0dca \u0dc3\u0dd2\u0dbd\u0db6\u0dbb\u0dd3\u0dc3\u0dca" },
            { "as", "\u0d87\u0dc3\u0dd1\u0db8\u0dca" },
            { "av", "\u0d87\u0dc0\u0dbb\u0dd2\u0d9a\u0dca" },
            { "sdh", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "ay", "\u0d85\u0dba\u0dd2\u0db8\u0dbb\u0dcf" },
            { "az", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca" },
            { "ba", "\u0db6\u0dcf\u0dc2\u0dca\u0d9a\u0dd2\u0dbb\u0dca" },
            { "be", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "bg", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "bi", "\u0db6\u0dd2\u0dc3\u0dca\u0dbd\u0db8\u0dcf" },
            { "bm", "\u0db6\u0db8\u0dca\u0db6\u0dbb\u0dcf" },
            { "bn", metaValue_bn },
            { "bo", "\u0da7\u0dd2\u0db6\u0dd9\u0da7\u0dca" },
            { "dgr", "\u0da9\u0ddc\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db6\u0dca" },
            { "br", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0da7\u0ddc\u0db1\u0dca" },
            { "bs", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Mymr", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb" },
            { "type.nu.laoo", "\u0dbd\u0dcf\u0d95 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "seh", "\u0dc3\u0dd9\u0db1\u0dcf" },
            { "ca", "\u0d9a\u0dd0\u0da7\u0dbd\u0db1\u0dca" },
            { "ses", "\u0d9a\u0ddd\u0dba\u0dd2\u0dbb\u0dcf\u0db6\u0ddc\u0dbb\u0ddc \u0dc3\u0dd9\u0db1\u0dca\u0db1\u0dd2" },
            { "ce", "\u0da0\u0dd9\u0da0\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ch", "\u0da0\u0db8\u0ddc\u0dbb\u0ddc" },
            { "co", "\u0d9a\u0ddd\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4" },
            { "Orya", "\u0d94\u0dbb\u0dd2\u0dba\u0dcf" },
            { "cs", "\u0da0\u0dd9\u0d9a\u0dca" },
            { "cu", "\u0da0\u0dbb\u0dca\u0da0\u0dca \u0dc3\u0dca\u0dbd\u0dd0\u0dc0\u0dd2\u0d9a\u0dca" },
            { "cv", "\u0da0\u0dc0\u0dda\u0dc2\u0dca" },
            { "cy", "\u0dc0\u0dd9\u0dbd\u0dca\u0dc2\u0dca" },
            { "type.nu.ethi", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "da", "\u0da9\u0dd0\u0db1\u0dd2\u0dc1\u0dca" },
            { "pt_PT", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "de", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "type.cf.standard", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "bem", "\u0db6\u0dd9\u0db8\u0dca\u0db6\u0dcf" },
            { "dv", "\u0da9\u0dd2\u0dc0\u0dd9\u0dc4\u0dd2" },
            { "es_419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "dz", "\u0da9\u0dd2\u0dc3\u0ddc\u0db1\u0dca\u0d9a\u0dcf" },
            { "bez", "\u0db6\u0dd9\u0db1\u0dcf" },
            { "type.ca.chinese", "\u0da0\u0dd3\u0db1 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "dje", "\u0dc3\u0dbb\u0dca\u0db8\u0dcf" },
            { "type.nu.grek", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "ee", "\u0d89\u0dc0\u0dca" },
            { "type.lb.normal", "\u0dc3\u0dcf\u0db8\u0dcf\u0db1\u0dca\u200d\u0dba \u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "ro_MD", "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0dc0\u0dd2\u0d86\u0db1\u0dd4" },
            { "el", metaValue_el },
            { "en", "\u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "eo", "\u0d91\u0dc3\u0dca\u0db4\u0dd0\u0dbb\u0db1\u0dca\u0da7\u0ddd" },
            { "es", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "et", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Hanb", "\u0dc4\u0dd0\u0db1\u0dca\u0da9\u0dca\u0db6\u0dca" },
            { "eu", "\u0db6\u0dcf\u0dc3\u0dca\u0d9a\u0dca" },
            { "Hang", "\u0dc4\u0dd0\u0db1\u0dca\u0d9c\u0dd4\u0dbd\u0dca" },
            { "shi", "\u0da7\u0da0\u0dda\u0dbd\u0dca\u0dc4\u0dd2\u0da7\u0dca" },
            { "hsb", "\u0d89\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Hani", "\u0dc4\u0db1\u0dca" },
            { "shn", "\u0dc1\u0dcf\u0db1\u0dca" },
            { "fa", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5" },
            { "type.nu.latn", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a" },
            { "ff", "\u0dc6\u0dd4\u0dbd\u0dcf\u0dc4\u0dca" },
            { "hsn", "\u0dc3\u0dd2\u0dba\u0dd0\u0db1\u0dca \u0da0\u0dd3\u0db1" },
            { "fi", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "fj", "\u0dc6\u0dd3\u0da2\u0dd2" },
            { "fon", "\u0dc6\u0ddc\u0db1\u0dca" },
            { "bgn", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0db6\u0dbd\u0ddc\u0da0\u0dd2" },
            { "yue", "\u0d9a\u0dd0\u0db1\u0dca\u0da7\u0ddc\u0db1\u0dd3\u0dc3\u0dca" },
            { "fo", "\u0dc6\u0dcf\u0dbb\u0ddd\u0dc3\u0dca" },
            { "umb", "\u0d8b\u0db6\u0dd4\u0db1\u0dca\u0da9\u0dd4" },
            { "fr", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "fy", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ga", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "gd", "\u0dc3\u0dca\u0d9a\u0ddc\u0da7\u0dca\u0da7\u0dd2\u0dc1\u0dca \u0d9c\u0dd9\u0dbd\u0dd2\u0d9a\u0dca" },
            { "gl", "\u0d9c\u0dd0\u0dbd\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "gn", "\u0d9c\u0dd4\u0dc0\u0dcf\u0dbb\u0db1\u0dd2" },
            { "bho", "\u0db6\u0ddc\u0da2\u0dca\u0db4\u0dd4\u0dbb\u0dd2" },
            { "und", "\u0db1\u0ddc\u0daf\u0db1\u0dca\u0db1\u0dcf \u0db7\u0dcf\u0dc2\u0dcf\u0dc0" },
            { "gu", metaValue_gu },
            { "gv", "\u0db8\u0dd0\u0db1\u0dca\u0d9a\u0dca\u0dc3\u0dca" },
            { "ha", "\u0dc4\u0ddd\u0dc3\u0dcf" },
            { "he", metaValue_he },
            { "hi", "\u0dc4\u0dd2\u0db1\u0dca\u0daf\u0dd2" },
            { "hup", "\u0dc4\u0dd4\u0db4\u0dcf" },
            { "bin", "\u0db6\u0dd2\u0db1\u0dd2" },
            { "hr", "\u0d9a\u0ddd\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ht", metaValue_HT },
            { "hu", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "hy", metaValue_hy },
            { "hz", "\u0dc4\u0dd9\u0dbb\u0dd9\u0dbb\u0ddc" },
            { "ia", "\u0d89\u0db1\u0dca\u0da7\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dd4\u0d86" },
            { "Jamo", "\u0da2\u0dcf\u0db8\u0ddc" },
            { "id", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "type.nu.tibt", "\u0da7\u0dd2\u0db6\u0dd9\u0da7 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "ig", "\u0d89\u0d9c\u0dca\u0db6\u0ddd" },
            { "ii", "\u0dc3\u0dd2\u0da0\u0dd4\u0d86\u0db1\u0dca \u0dba\u0dd3" },
            { "io", "\u0d89\u0da9\u0ddc" },
            { "is", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "it", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2" },
            { "iu", "\u0d89\u0db1\u0dd4\u0d9a\u0dca\u0da7\u0dd2\u0da7\u0dd4\u0da7\u0dca" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "jv", "\u0da2\u0dcf\u0dc0\u0dcf" },
            { "mad", "\u0db8\u0daf\u0dd4\u0dbb\u0dd3\u0dc3\u0dca" },
            { "smj", "\u0dbd\u0dd4\u0dbd\u0dda \u0dc3\u0dcf\u0db8\u0dd2" },
            { "mag", "\u0db8\u0d9d\u0dc4\u0dd2" },
            { "mai", "\u0db8\u0dba\u0dd2\u0dad\u0dd2\u0dbd\u0dd2" },
            { "smn", "\u0d89\u0db1\u0dcf\u0dbb\u0dd2 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "ka", metaValue_ka },
            { "bla", "\u0dc3\u0dd2\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf" },
            { "mak", "\u0db8\u0d9a\u0dcf\u0dc3\u0dcf\u0dbb\u0dca" },
            { "wuu", "\u0dc0\u0dd6 \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "sms", "\u0dc3\u0dca\u0d9a\u0ddc\u0dbd\u0dca\u0da7\u0dca \u0dc3\u0dcf\u0db8\u0dd2" },
            { "ki", "\u0d9a\u0dd2\u0d9a\u0dd4\u0dba\u0dd4" },
            { "mas", "\u0db8\u0dc3\u0dcf\u0dba\u0dd2" },
            { "kj", "\u0d9a\u0dd4\u0dba\u0db1\u0dca\u0dba\u0db8\u0dcf" },
            { "kk", "\u0d9a\u0dc3\u0dcf\u0d9b\u0dca" },
            { "kl", "\u0d9a\u0dbd\u0dcf\u0dbd\u0dd2\u0dc3\u0da7\u0dca" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0d9a\u0db1\u0dd4\u0dbb\u0dd2" },
            { "ks", "\u0d9a\u0dcf\u0dc2\u0dca\u0db8\u0dd3\u0dbb\u0dca" },
            { "ku", "\u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "kv", "\u0d9a\u0ddc\u0db8\u0dd2" },
            { "kw", "\u0d9a\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ky", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca" },
            { "snk", "\u0dc3\u0ddc\u0db1\u0dd2\u0db1\u0dca\u0d9a\u0dd9" },
            { "la", metaValue_la },
            { "lb", "\u0dbd\u0d9a\u0dca\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "type.nu.mlym", "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "lg", "\u0d9c\u0db1\u0dca\u0da9\u0dcf" },
            { "li", "\u0dbd\u0dd2\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dd2\u0dc1\u0dca" },
            { "Tibt", "\u0da7\u0dd2\u200d\u0db6\u0dd9\u0da7\u0dca" },
            { "ln", "\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dbd\u0dcf" },
            { "fur", "\u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dd4\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0dbb\u0dcf\u0da2\u0d9a\u0dd3\u0dba \u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "lt", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "lu", "\u0dbd\u0dd4\u0db6\u0dcf-\u0d9a\u0da7\u0db1\u0dca\u0d9c\u0dcf" },
            { "lv", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mg", "\u0db8\u0dbd\u0d9c\u0dcf\u0dc3\u0dd2" },
            { "mh", "\u0db8\u0dcf\u0dc1\u0dbd\u0dd3\u0dc3\u0dca" },
            { "type.co.ducet", "\u0dba\u0dd4\u0db1\u0dd2\u0d9a\u0dda\u0dad \u0db4\u0dd9\u0dbb\u0db1\u0dd2\u0db8\u0dd2 \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "mi", "\u0db8\u0dcf\u0dc0\u0ddc\u0dbb\u0dd2" },
            { "mk", "\u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ml", metaValue_ml },
            { "mn", "\u0db8\u0ddc\u0d82\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mr", "\u0db8\u0dbb\u0dcf\u0dad\u0dd2" },
            { "ms", "\u0db8\u0dd0\u0dbd\u0dda" },
            { "mt", "\u0db8\u0ddc\u0dbd\u0dca\u0da7\u0dd2\u0dc3\u0dca" },
            { "my", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0db8\u0ddc\u0d9a\u0dca\u0dc1\u0dcf" },
            { "dsb", "\u0db4\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "na", "\u0db1\u0dde\u0dbb\u0dd4" },
            { "type.co.search", "\u0dc3\u0dcf\u0db8\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc3\u0dd9\u0dc0\u0dd3\u0db8" },
            { "nb", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0d9a\u0dca\u0db8\u0dbd\u0dca" },
            { "nd", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d91\u0db1\u0dca\u0da9\u0dd2\u0db6\u0dd9\u0dbd\u0dd9" },
            { "ne", "\u0db1\u0dda\u0db4\u0dcf\u0dbd" },
            { "ng", "\u0db1\u0dca\u0da9\u0ddc\u0db1\u0dca\u0d9c\u0dcf" },
            { "nl", "\u0dbd\u0db1\u0dca\u0daf\u0dda\u0dc3\u0dd2" },
            { "nn", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dba\u0dd2\u0db1\u0ddd\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca" },
            { "nr", "\u0dc3\u0dde\u0dad\u0dca \u0da9\u0dca\u0db6\u0dda\u0dbd\u0dca" },
            { "nv", "\u0db1\u0dc0\u0dcf\u0da2\u0ddc" },
            { "ny", "\u0db1\u0dca\u0dba\u0db1\u0dca\u0da2\u0dcf" },
            { "kac", "\u0d9a\u0da0\u0dd2\u0db1\u0dca" },
            { "kab", "\u0d9a\u0dcf\u0db6\u0dd2\u0dbd\u0dca" },
            { "oc", "\u0d94\u0dc3\u0dd2\u0da7\u0dcf\u0db1\u0dca" },
            { "kaj", "\u0da2\u0dca\u0da2\u0dd4" },
            { "kam", "\u0d9a\u0dd0\u0db8\u0dca\u0db6\u0dcf" },
            { "men", "\u0db8\u0dd9\u0db1\u0dca\u0da9\u0dd9" },
            { "mer", "\u0db8\u0dd9\u0dbb\u0dd4" },
            { "type.nu.armn", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "om", "\u0d94\u0dbb\u0ddc\u0db8\u0ddd" },
            { "or", "\u0d94\u0da9\u0dd2\u0dba\u0dcf" },
            { "os", "\u0d94\u0dc3\u0dd2\u0da7\u0dd9\u0d9a\u0dca" },
            { "kbd", "\u0d9a\u0db6\u0dcf\u0dbb\u0dca\u0da9\u0dd2\u0dba\u0db1\u0dca" },
            { "mfe", "\u0db8\u0ddc\u0dbb\u0dd2\u0dc3\u0dca\u0dba\u0dd9\u0db8\u0dca" },
            { "srn", "\u0dc3\u0dca\u200d\u0dbb\u0db1\u0dca \u0da7\u0ddc\u0db1\u0dca\u0d9c\u0ddc" },
            { "pa", "\u0db4\u0db1\u0dca\u0da2\u0dcf\u0db6\u0dd2" },
            { "dua", "\u0da9\u0dd4\u0d86\u0dbd\u0dcf" },
            { "pl", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad" },
            { "type.ca.dangi", "\u0da9\u0dd0\u0db1\u0dca\u0d9c\u0dd3 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "ps", "\u0db4\u0dc2\u0dca\u0da7\u0ddc" },
            { "pt", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "key.co", "\u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "pt_BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "kcg", "\u0da7\u0dca\u0dba\u0db4\u0dca" },
            { "mgh", "\u0db8\u0d9b\u0dd4\u0dc0\u0dcf-\u0db8\u0dd3\u0da7\u0ddd" },
            { "key.cf", "\u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "key.ca", "\u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "Laoo", metaValue_lo },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "mgo", "\u0db8\u0dd9\u0da7\u0dcf" },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "ssy", "\u0dc3\u0dc4\u0ddc" },
            { "type.nu.mymr", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "qu", "\u0d9a\u0dca\u0dc0\u0dd3\u0da0\u0dd4\u0dc0\u0dcf" },
            { "brx", "\u0db6\u0ddc\u0da9\u0ddc" },
            { "kde", "\u0db8\u0dd0\u0d9a\u0ddc\u0db1\u0dca\u0da9\u0dca" },
            { "Ethi", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "type.hc.h12", metaValue_type_hc_h11 },
            { "type.hc.h11", metaValue_type_hc_h11 },
            { "rm", "\u0dbb\u0ddc\u0db8\u0dd1\u0db1\u0dca\u0dc1\u0dca" },
            { "rn", "\u0dbb\u0dd4\u0db1\u0dca\u0da9\u0dd2" },
            { "key.cu", "\u0dc0\u0dd2\u0db1\u0dd2\u0db8\u0dba" },
            { "ro", "\u0dbb\u0ddc\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "type.nu.orya", "\u0d94\u0dbb\u0dd2\u0dba\u0dcf \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.hanidec", "\u0da0\u0dd3\u0db1 \u0daf\u0dc1\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "ru", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "rw", "\u0d9a\u0dd2\u0db1\u0dca\u0dba\u0dbb\u0dca\u0dc0\u0db1\u0dca\u0da9\u0dcf" },
            { "kea", "\u0d9a\u0db6\u0dd4\u0dc0\u0dd9\u0dbb\u0dca\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mic", "\u0db8\u0dd2\u0d9a\u0dca\u0db8\u0dd0\u0d9a\u0dca" },
            { "suk", "\u0dc3\u0dd4\u0d9a\u0dd4\u0db8\u0dcf" },
            { "en_AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "sa", "\u0dc3\u0d82\u0dc3\u0dca\u0d9a\u0dd8\u0dad" },
            { "sc", "\u0dc3\u0dcf\u0dbb\u0dca\u0da9\u0dd2\u0db1\u0dd2\u0d85\u0db1\u0dca" },
            { "sd", "\u0dc3\u0dd2\u0db1\u0dca\u0db0\u0dd2" },
            { "se", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "min", "\u0db8\u0dd2\u0db1\u0db1\u0dca\u0d9c\u0dca\u0d9a\u0db6\u0dcf\u0dc0\u0dd4" },
            { "sg", "\u0dc3\u0db1\u0dca\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "si", metaValue_si },
            { "sk", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dca" },
            { "sl", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sm", "\u0dc3\u0dd1\u0db8\u0ddc\u0d85\u0db1\u0dca" },
            { "sn", "\u0dc1\u0ddd\u0db1\u0dcf" },
            { "so", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2" },
            { "type.nu.arab", "\u0d89\u0db1\u0dca\u0daf\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "sq", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sr", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ss", "\u0dc3\u0dca\u0dc0\u0dad\u0dd2" },
            { "type.cf.account", "\u0d9c\u0dd2\u0dab\u0dd4\u0db8\u0dca\u0d9a\u0dbb\u0dab \u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "st", "\u0dc3\u0dad\u0dbb\u0dca\u0db1\u0dca \u0dc3\u0ddc\u0dad\u0ddc" },
            { "su", "\u0dc3\u0db1\u0dca\u0da9\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sv", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dca" },
            { "sw", "\u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "type.nu.hantfin", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "ibb", "\u0d89\u0db6\u0dd2\u0db6\u0dd2\u0dba\u0ddc" },
            { "iba", "\u0d89\u0db6\u0db1\u0dca" },
            { "ta", metaValue_ta },
            { "142", "\u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "143", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "te", metaValue_te },
            { "145", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "tg", "\u0da7\u0da2\u0dd2\u0d9a\u0dca" },
            { "th", metaValue_th },
            { "ti", "\u0da7\u0dd2\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dba\u0dcf" },
            { "bug", "\u0db6\u0dd4\u0d9c\u0dd2\u0db1\u0dd3\u0dc3\u0dca" },
            { "kfo", "\u0d9a\u0ddc\u0dbb\u0ddc" },
            { "en_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "tk", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dca" },
            { "tn", "\u0dc3\u0dca\u0dc0\u0db1\u0dcf" },
            { "to", metaValue_TO },
            { "dyo", "\u0da2\u0ddc\u0dbd-\u0dc6\u0ddd\u0db1\u0dd2\u0dba\u0dd2" },
            { "type.nu.jpan", "\u0da2\u0db4\u0dcf\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "tr", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2" },
            { "ts", "\u0dc3\u0ddc\u0db1\u0dca\u0d9c" },
            { "swb", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0dd2\u0dba\u0db1\u0dca" },
            { "tt", "\u0da7\u0dcf\u0da7\u0dbb\u0dca" },
            { "ty", "\u0da7\u0dc4\u0dd2\u0da7\u0dd2\u0dba\u0db1\u0dca" },
            { "150", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "151", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "154", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "dzg", "\u0da9\u0dc3\u0dcf\u0d9c\u0dcf" },
            { "155", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "ug", "\u0d8b\u0dba\u0dd2\u0d9c\u0dbb\u0dca" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0db4\u0ddc\u0daf\u0dd4" },
            { "uk", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ur", "\u0d8b\u0dbb\u0dca\u0daf\u0dd4" },
            { "xal", "\u0d9a\u0dbd\u0dca\u0db8\u0dd2\u0d9a\u0dca" },
            { "uz", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dca" },
            { "kha", "\u0d9b\u0dc3\u0dd2" },
            { "nds_NL", "\u0db4\u0dc4\u0dc5 \u0dc3\u0dd0\u0d9a\u0dca\u0dc3\u0db1\u0dca" },
            { "ve", "\u0dc0\u0dd9\u0db1\u0dca\u0da9\u0dcf" },
            { "type.ca.roc", "\u0db8\u0dd2\u0db1\u0dca\u0d9c\u0dcf \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "vi", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dca" },
            { "khq", "\u0d9a\u0ddc\u0dba\u0dd2\u0dbb\u0dcf \u0da0\u0dd2\u0db1\u0dd2" },
            { "key.hc", "\u0db4\u0dd0\u0dba \u0da0\u0d9a\u0dca\u200d\u0dbb\u0dba" },
            { "vo", "\u0dc0\u0ddc\u0dbd\u0db4\u0dd6\u0d9a\u0dca" },
            { "quc", "\u0d9a\u0dd2\u0dba\u0dd2\u0da0\u0dda" },
            { "gaa", "\u0d9c\u0dcf" },
            { "wa", "\u0dc0\u0dd1\u0dbd\u0dd6\u0db1\u0dca" },
            { "gag", "\u0d9c\u0d9c\u0dcf\u0dc3\u0dca" },
            { "syr", "\u0dc3\u0dca\u200d\u0dbb\u0dba\u0dd1\u0d9a\u0dca" },
            { "Grek", metaValue_el },
            { "gan", "\u0d9c\u0dd0\u0db1\u0dca \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "wo", "\u0dc0\u0ddc\u0dbd\u0ddc\u0dc6\u0dca" },
            { "zgh", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd \u0da7\u0db8\u0dc3\u0dd2\u0d9c\u0dca\u0dad\u0dca" },
            { "ar_001", "\u0db1\u0dd6\u0dad\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "Mong", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mni", "\u0db8\u0db1\u0dd2\u0db4\u0dd4\u0dbb\u0dd2" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5 \u0da0\u0dd3\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "xh", "\u0dc1\u0ddd\u0dc3\u0dcf" },
            { "type.nu.romanlow", "\u0dbb\u0ddd\u0db8\u0dcf\u0db1\u0dd4 \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "byn", "\u0db6\u0dca\u0dbd\u0dd2\u0db1\u0dca" },
            { "moh", "\u0db8\u0ddc\u0dc4\u0ddc\u0dc0\u0dca\u0d9a\u0dca" },
            { "kkj", "\u0d9a\u0d9a\u0ddc" },
            { "yi", "\u0dba\u0dd2\u0da9\u0dd2\u0dc1\u0dca" },
            { "mos", "\u0db8\u0ddc\u0dc3\u0dca\u0dc3\u0dd2" },
            { "yo", "\u0dba\u0ddc\u0dbb\u0dd6\u0db6\u0dcf" },
            { "es_MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "vai", "\u0dc0\u0dba\u0dd2" },
            { "kln", "\u0d9a\u0dbd\u0dd9\u0db1\u0dca\u0da2\u0db1\u0dca" },
            { "zh", "\u0da0\u0dd3\u0db1" },
            { "Bopo", "\u0db6\u0ddc\u0db4\u0ddc\u0db8\u0ddc\u0dc6\u0ddd" },
            { "key.lb", "\u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "zu", "\u0dc3\u0dd4\u0dbd\u0dd4" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0d9a\u0dd2\u0db8\u0dca\u0db6\u0dd4\u0db1\u0dca\u0da9\u0dd4" },
            { "type.nu.jpanfin", "\u0da2\u0db4\u0dcf\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "gez", "\u0d9c\u0dd3\u0dc3\u0dca" },
            { "ebu", "\u0d91\u0db8\u0dca\u0db6\u0dd4" },
            { "zh_Hans", "\u0dc3\u0dbb\u0dbd \u0da0\u0dd3\u0db1" },
            { "koi", "\u0d9a\u0ddc\u0db8\u0dd2-\u0db4\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dcf\u0d9a\u0dca" },
            { "kok", "\u0d9a\u0ddc\u0db1\u0dca\u0d9a\u0db1\u0dd2" },
            { "zh_Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1" },
            { "kpe", "\u0d9a\u0dca\u0db4\u0dd9\u0dbd\u0dd9" },
            { "type.nu.khmr", "\u0d9a\u0db8\u0dbb\u0dca \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "ilo", "\u0d89\u0dbd\u0ddc\u0d9a\u0ddc" },
            { "mua", "\u0db8\u0dd4\u0db1\u0dca\u0da9\u0db1\u0dca" },
            { "type.nu.guru", "\u0d9c\u0dd4\u0dbb\u0dca\u0db8\u0dd4\u0d9a\u0dd3 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "mul", "\u0db6\u0dc4\u0dd4 \u0db7\u0dcf\u0dc2\u0dcf" },
            { "key.ms", "\u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "mus", "\u0d9a\u0dca\u200d\u0dbb\u0dd3\u0d9a\u0dca" },
            { "gil", "\u0d9c\u0dd2\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da7\u0dd3\u0dc3\u0dca" },
            { "type.nu.tamldec", "\u0daf\u0dd9\u0db8\u0dc5 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "krc", "\u0d9a\u0dbb\u0db1\u0dca\u0da0\u0dd2-\u0db6\u0dcf\u0d9a\u0dbb\u0dca" },
            { "inh", "\u0d89\u0db1\u0dca\u0d9c\u0dd4\u0dc2\u0dca" },
            { "fa_AF", "\u0da9\u0dcf\u0dbb\u0dd2" },
            { "krl", "\u0d9a\u0dd0\u0dbb\u0dd9\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "efi", "\u0d91\u0dc6\u0dd2\u0d9a\u0dca" },
            { "key.nu", "\u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "kru", "\u0d9a\u0dd4\u0dbb\u0dd4\u0d9b\u0dca" },
            { "ksb", "\u0dc1\u0dcf\u0db8\u0dca\u0db6\u0dbd\u0dcf" },
            { "Telu", metaValue_te },
            { "ksf", "\u0db6\u0dcf\u0dc6\u0dd2\u0dba\u0dcf" },
        };
        return data;
    }
}
